// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.highlighting.jam

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool
import com.intellij.codeInspection.ProblemsHolder
import com.intellij.openapi.module.Module
import com.intellij.openapi.module.ModuleUtilCore
import com.intellij.openapi.project.Project
import com.intellij.psi.PsiElementVisitor
import com.intellij.spring.SpringLibraryUtil
import com.intellij.spring.model.utils.SpringCommonUtils
import com.intellij.spring.model.utils.SpringModelUtils
import org.jetbrains.uast.UElement

/**
 * @since 2018.1
 */
abstract class SpringUastInspectionBase : AbstractBaseUastLocalInspectionTool() {

  final override fun buildVisitor(holder: ProblemsHolder, isOnTheFly: Boolean): PsiElementVisitor {
    if (!isEnabledForProject(holder.project)) return PsiElementVisitor.EMPTY_VISITOR

    return super.buildVisitor(holder, isOnTheFly)
  }

  open fun isEnabledForProject(project: Project) = SpringLibraryUtil.hasSpringLibrary(project)

  protected fun isInSpringEnabledModule(uElement: UElement): Boolean {
    val psi = uElement.javaPsi ?: return false

    val module = ModuleUtilCore.findModuleForPsiElement(psi) ?: return false
    return isSpringEnabledModule(module)
  }

  protected fun isSpringEnabledModule(module: Module?): Boolean {
    if (module == null) return false
    return SpringCommonUtils.hasSpringFacet(module) ||
           SpringModelUtils.getInstance().hasAutoConfiguredModels(module)
  }

}