// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.model.converters;

import com.intellij.util.xml.Converter;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.WrappingConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyKeyConverter extends WrappingConverter {

  @Override
  @Nullable
  public Converter getConverter(@NotNull final GenericDomValue domValue) {

    return CustomConverterRegistry.getRegistry().getCustomConverter(getClass(), domValue);
  }
}
