// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.contexts.model.diagram.gutter;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

import java.util.Set;

/**
 * Provides additional actions for "Spring Diagram" gutter icon.
 *
 * @since 2018.2
 */
public interface SpringGutterDiagramActionProvider {

  ExtensionPointName<SpringGutterDiagramActionProvider> EP_NAME =
    new ExtensionPointName<>("com.intellij.spring.gutterDiagramActionProvider");

  @NotNull
  Set<AnAction> getOpenDiagramActions(@NotNull PsiElement psiElement);
}
