/*
 * Copyright 2000-2016 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package icons;

import com.intellij.openapi.util.IconLoader;

import javax.swing.*;

/**
 * NOTE THIS FILE IS AUTO-GENERATED
 * DO NOT EDIT IT BY HAND, run "Generate icon classes" configuration instead
 */
public final class DatabaseIcons {
  private static Icon load(String path) {
    return IconLoader.getIcon(path, DatabaseIcons.class);
  }

  private static Icon load(String path, Class<?> clazz) {
    return IconLoader.getIcon(path, clazz);
  }

  public static final Icon Access_method = load("/icons/access_method.svg"); // 16x16
  public static final Icon Adapter_script = load("/icons/adapter_script.svg"); // 16x16
  public static final Icon Add_hover = load("/icons/add-hover.svg"); // 10x10
  public static final Icon Add = load("/icons/add.svg"); // 10x10
  public static final Icon Aggregate = load("/icons/aggregate.svg"); // 16x16
  public static final Icon Argument = load("/icons/argument.svg"); // 16x16
  public static final Icon BlueKey = load("/icons/blueKey.svg"); // 16x16
  public static final Icon Body = load("/icons/body.svg"); // 16x16
  public static final Icon CheckConstraint = load("/icons/checkConstraint.svg"); // 16x16
  public static final Icon Col = load("/icons/col.svg"); // 16x16
  public static final Icon ColBlueKey = load("/icons/colBlueKey.svg"); // 16x16
  public static final Icon ColBlueKeyDot = load("/icons/colBlueKeyDot.svg"); // 16x16
  public static final Icon ColBlueKeyDotIndex = load("/icons/colBlueKeyDotIndex.svg"); // 16x16
  public static final Icon ColBlueKeyIndex = load("/icons/colBlueKeyIndex.svg"); // 16x16
  public static final Icon ColDot = load("/icons/colDot.svg"); // 16x16
  public static final Icon ColDotIndex = load("/icons/colDotIndex.svg"); // 16x16
  public static final Icon ColGoldBlueKey = load("/icons/colGoldBlueKey.svg"); // 16x16
  public static final Icon ColGoldBlueKeyDot = load("/icons/colGoldBlueKeyDot.svg"); // 16x16
  public static final Icon ColGoldBlueKeyDotIndex = load("/icons/colGoldBlueKeyDotIndex.svg"); // 16x16
  public static final Icon ColGoldBlueKeyIndex = load("/icons/colGoldBlueKeyIndex.svg"); // 16x16
  public static final Icon ColGoldKey = load("/icons/colGoldKey.svg"); // 16x16
  public static final Icon ColGoldKeyDot = load("/icons/colGoldKeyDot.svg"); // 16x16
  public static final Icon ColGoldKeyDotIndex = load("/icons/colGoldKeyDotIndex.svg"); // 16x16
  public static final Icon ColGoldKeyIndex = load("/icons/colGoldKeyIndex.svg"); // 16x16
  public static final Icon ColIndex = load("/icons/colIndex.svg"); // 16x16
  public static final Icon Collation = load("/icons/collation.svg"); // 16x16
  public static final Icon CollectionType = load("/icons/collectionType.svg"); // 16x16
  public static final Icon Connector = load("/icons/connector.svg"); // 16x16
  public static final Icon ConsoleRun = load("/icons/consoleRun.svg"); // 16x16
  public static final Icon ConsoleShowPlan = load("/icons/consoleShowPlan.svg"); // 16x16
  public static final Icon Constant = load("/icons/constant.svg"); // 16x16
  public static final Icon Database = load("/icons/database.svg"); // 16x16
  public static final Icon DatabaseGroup = load("/icons/databaseGroup.svg"); // 16x16
  public static final Icon DatabaseLink = load("/icons/databaseLink.svg"); // 16x16
  public static final Icon Dbms = load("/icons/dbms.svg"); // 16x16
  public static final Icon DdlDbms = load("/icons/ddlDbms.svg"); // 16x16
  public static final Icon DefaultConstraint = load("/icons/defaultConstraint.svg"); // 16x16
  public static final Icon Extension = load("/icons/extension.svg"); // 16x16
  public static final Icon External_schema_object = load("/icons/external_schema_object.svg"); // 16x16
  public static final Icon Foreign_datawrapper = load("/icons/foreign_datawrapper.svg"); // 16x16
  public static final Icon Foreign_server = load("/icons/foreign_server.svg"); // 16x16
  public static final Icon Foreign_table = load("/icons/foreign_table.svg"); // 16x16
  public static final Icon Function = load("/icons/function.svg"); // 16x16
  public static final Icon FunctionRun = load("/icons/functionRun.svg"); // 16x16
  public static final Icon GoldKey = load("/icons/goldKey.svg"); // 16x16
  public static final Icon GoldKeyAlt = load("/icons/goldKeyAlt.svg"); // 16x16
  public static final Icon HashCluster = load("/icons/hashCluster.svg"); // 16x16
  public static final Icon Index = load("/icons/index.svg"); // 16x16
  public static final Icon IndexCluster = load("/icons/indexCluster.svg"); // 16x16
  public static final Icon IndexFun = load("/icons/indexFun.svg"); // 16x16
  public static final Icon IndexUnique = load("/icons/indexUnique.svg"); // 16x16
  public static final Icon IndexUniqueFun = load("/icons/indexUniqueFun.svg"); // 16x16
  public static final Icon ManageDataSources = load("/icons/manageDataSources.svg"); // 16x16
  public static final Icon MaterializedLog = load("/icons/materializedLog.svg"); // 16x16
  public static final Icon MaterializedView = load("/icons/materializedView.svg"); // 16x16
  public static final Icon ObjectGroup = load("/icons/objectGroup.svg"); // 16x16
  public static final Icon Operator = load("/icons/operator.svg"); // 16x16
  public static final Icon Package = load("/icons/package.svg"); // 16x16
  public static final Icon Play_back = load("/icons/play_back.svg"); // 16x16
  public static final Icon Play_first = load("/icons/play_first.svg"); // 16x16
  public static final Icon Play_forward = load("/icons/play_forward.svg"); // 16x16
  public static final Icon Play_last = load("/icons/play_last.svg"); // 16x16
  public static final Icon Procedure = load("/icons/procedure.svg"); // 16x16
  public static final Icon ProcedureRun = load("/icons/procedureRun.svg"); // 16x16
  public static final Icon ProcGroup = load("/icons/procGroup.svg"); // 16x16
  public static final Icon Role = load("/icons/role.svg"); // 16x16
  public static final Icon Routine = load("/icons/routine.svg"); // 16x16
  public static final Icon Rule = load("/icons/rule.svg"); // 16x16
  public static final Icon ScheduledEvent = load("/icons/scheduledEvent.svg"); // 16x16
  public static final Icon Schema = load("/icons/schema.svg"); // 16x16
  public static final Icon Scripting_script = load("/icons/scripting_script.svg"); // 16x16
  public static final Icon Sequence = load("/icons/sequence.svg"); // 16x16
  public static final Icon Sql = load("/icons/sql.svg"); // 16x16
  public static final Icon SqlDmlStatement = load("/icons/sqlDmlStatement.svg"); // 16x16
  public static final Icon SqlGroupByType = load("/icons/sqlGroupByType.svg"); // 16x16
  public static final Icon SqlOtherStatement = load("/icons/sqlOtherStatement.svg"); // 16x16
  public static final Icon SqlSelectStatement = load("/icons/sqlSelectStatement.svg"); // 16x16
  public static final Icon SubmitDB = load("/icons/submitDB.svg"); // 16x16
  public static final Icon Synonym = load("/icons/synonym.svg"); // 16x16
  public static final Icon Table = load("/icons/table.svg"); // 16x16
  public static final Icon ToolWindowConsole = load("/icons/toolWindowConsole.svg"); // 13x13
  public static final Icon ToolWindowDatabase = load("/icons/toolWindowDatabase.svg"); // 13x13
  public static final Icon ToolwindowDatabaseChanges = load("/icons/toolwindowDatabaseChanges.svg"); // 13x13
  public static final Icon ToolWindowFiles = load("/icons/toolWindowFiles.svg"); // 13x13
  public static final Icon ToolWindowSQLGenerator = load("/icons/toolWindowSQLGenerator.svg"); // 13x13
  public static final Icon Trigger = load("/icons/trigger.svg"); // 16x16
  public static final Icon Udf_script = load("/icons/udf_script.svg"); // 16x16
  public static final Icon UnspecifiedCluster = load("/icons/unspecifiedCluster.svg"); // 16x16
  public static final Icon User_mapping = load("/icons/user_mapping.svg"); // 16x16
  public static final Icon UserDriver = load("/icons/userDriver.svg"); // 16x16
  public static final Icon View = load("/icons/view.svg"); // 16x16

  /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.Add */
  @SuppressWarnings("unused")
  @Deprecated
  public static final Icon AddRow = load("/general/add.svg", com.intellij.icons.AllIcons.class);

  /** @deprecated to be removed in IDEA 2020 - use AllIcons.Modules.SourceRoot */
  @SuppressWarnings("unused")
  @Deprecated
  public static final Icon Catalog = load("/modules/sourceRoot.svg", com.intellij.icons.AllIcons.class);

  /** @deprecated to be removed in IDEA 2020 - use AllIcons.General.User */
  @SuppressWarnings("unused")
  @Deprecated
  public static final Icon User = load("/general/user.svg", com.intellij.icons.AllIcons.class);
}
