package org.jetbrains.idea.tomcat.server;

import com.intellij.execution.configurations.ConfigurationTypeUtil;
import org.jetbrains.annotations.NotNull;

public final class TomcatConfiguration extends TomcatConfigurationBase {
  public static TomcatConfiguration getInstance() {
    return ConfigurationTypeUtil.findConfigurationType(TomcatConfiguration.class);
  }

  public TomcatConfiguration(TomcatIntegration tomcatIntegration) {
    super("#com.intellij.j2ee.web.tomcat.TomcatRunConfigurationFactory", tomcatIntegration);
  }

  @NotNull
  @Override
  public String getTag() {
    return "tomcat";
  }

  @Override
  public String getHelpTopic() {
    return "reference.dialogs.rundebug.#com.intellij.j2ee.web.tomcat.TomcatRunConfigurationFactory";
  }
}