/*
 * Copyright 2000-2007 JetBrains s.r.o.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.intellij.psi.css;

import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CssBlock extends CssElement {

  @NotNull
  CssDeclaration[] getDeclarations();

  boolean isEqualTo(Object object);

  @Nullable
  PsiElement getLBrace();
  
  @Nullable
  PsiElement getRBrace();

  /**
   * adds the given declaration to the block AFTER the anchor, or as first declaration if anchor is null
   */
  CssDeclaration addDeclaration(@NotNull final String name, @NotNull final String value, @Nullable final CssDeclaration anchor)
    throws IncorrectOperationException;

  void removeDeclaration(@NotNull final CssDeclaration declaration) throws IncorrectOperationException;

  @Nullable
  CssDeclaration findDeclaration(@NotNull String propertyName);

  @Nullable
  CssDeclaration findDeclaration(@NotNull String propertyName, boolean searchInShorthand);
}
