// Copyright 2000-2018 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SpringBootApplicationUrlPathProviderFactory {
  ExtensionPointName<SpringBootApplicationUrlPathProviderFactory> EP_NAME =
    ExtensionPointName.create("com.intellij.spring.boot.run.applicationUrlPathProviderFactory");

  @NotNull
  TextFieldWithAutoCompletionListProvider<?> createCompletionProvider(@NotNull SpringBootApplicationInfo info);

  @Nullable
  String getServletPath(@NotNull SpringBootApplicationInfo info, @NotNull String path);
}
