// Copyright 2000-2017 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package com.intellij.spring.boot.run;

import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public interface SpringBootApplicationRunConfigurationBase extends LocatableConfiguration {
  void setModule(final Module module);

  Module getModule();

  void setSpringBootMainClass(String springBootMainClass);

  String getSpringBootMainClass();

  PsiClass getMainClass();

  @NotNull
  GlobalSearchScope getSearchScope();

  String getUrlPath();

  void setUrlPath(String value);
}
