/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.targets;

import com.intellij.util.Consumer;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryRoot;
import org.jetbrains.jps.model.library.JpsOrderRootType;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.JsBuildMetaInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.compilerRunner.JpsCompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.JpsKotlinCompilerRunner;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.IncrementalJsCache;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProvider;
import org.jetbrains.kotlin.incremental.js.IncrementalDataProviderFromCache;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumer;
import org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl;
import org.jetbrains.kotlin.jps.build.JpsUtilKt;
import org.jetbrains.kotlin.jps.build.KotlinCompileContext;
import org.jetbrains.kotlin.jps.build.KotlinDirtySourceFilesHolder;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalCache;
import org.jetbrains.kotlin.jps.incremental.JpsIncrementalJsCache;
import org.jetbrains.kotlin.jps.model.ModuleSettingsKt;
import org.jetbrains.kotlin.jps.targets.KotlinModuleBuildTarget;
import org.jetbrains.kotlin.utils.JsLibraryUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\r012\u0006\u00102\u001a\u00020\u001fH\u0002J(\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020-H\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020-H\u0016J8\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020D2\u0016\u0010E\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0001\u0012\u0004\u0012\u00020G0F2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0016J.\u0010L\u001a\u00020-2\u0006\u0010M\u001a\u00020G2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020O0\u00112\u0006\u0010P\u001a\u00020Q2\u0006\u0010:\u001a\u00020;H\u0016R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0018\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010 R\u0014\u0010!\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010 R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0013R\u0011\u0010$\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001dR\u0014\u0010&\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000fR\u0011\u0010(\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0013\u00a8\u0006R"}, d2={"Lorg/jetbrains/kotlin/jps/targets/KotlinJsModuleBuildTarget;", "Lorg/jetbrains/kotlin/jps/targets/KotlinModuleBuildTarget;", "Lorg/jetbrains/kotlin/build/JsBuildMetaInfo;", "kotlinContext", "Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;", "jpsModuleBuildTarget", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "(Lorg/jetbrains/kotlin/jps/build/KotlinCompileContext;Lorg/jetbrains/jps/incremental/ModuleBuildTarget;)V", "buildMetaInfoFactory", "Lorg/jetbrains/kotlin/build/JsBuildMetaInfo$Companion;", "getBuildMetaInfoFactory", "()Lorg/jetbrains/kotlin/build/JsBuildMetaInfo$Companion;", "buildMetaInfoFileName", "", "getBuildMetaInfoFileName", "()Ljava/lang/String;", "dependenciesMetaFiles", "", "getDependenciesMetaFiles", "()Ljava/util/List;", "explicitOutputPath", "getExplicitOutputPath", "friendBuildTargetsMetaFiles", "getFriendBuildTargetsMetaFiles", "globalLookupCacheId", "getGlobalLookupCacheId", "implicitOutputFile", "Ljava/io/File;", "getImplicitOutputFile", "()Ljava/io/File;", "isFirstBuild", "", "()Z", "isIncrementalCompilationEnabled", "libraryFiles", "getLibraryFiles", "outputFile", "getOutputFile", "outputFileBaseName", "getOutputFileBaseName", "outputMetaFile", "getOutputMetaFile", "sourceMapRoots", "getSourceMapRoots", "addDependencyMetaFile", "", "module", "Lorg/jetbrains/jps/model/module/JpsModule;", "result", "", "isTests", "compileModuleChunk", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "dirtyFilesHolder", "Lorg/jetbrains/kotlin/jps/build/KotlinDirtySourceFilesHolder;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/JpsCompilerEnvironment;", "copyJsLibraryFilesIfNeeded", "createCacheStorage", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalJsCache;", "paths", "Lorg/jetbrains/jps/builders/storage/BuildDataPaths;", "doAfterBuild", "makeServices", "builder", "Lorg/jetbrains/kotlin/config/Services$Builder;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/jps/incremental/JpsIncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "exceptActualTracer", "Lorg/jetbrains/kotlin/incremental/components/ExpectActualTracker;", "updateCaches", "jpsIncrementalCache", "files", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "jps-plugin"})
public final class KotlinJsModuleBuildTarget
extends KotlinModuleBuildTarget<JsBuildMetaInfo> {
    @Override
    @NotNull
    public String getGlobalLookupCacheId() {
        return "js";
    }

    @Override
    public boolean isIncrementalCompilationEnabled() {
        return IncrementalCompilation.isEnabledForJs();
    }

    @NotNull
    public JsBuildMetaInfo.Companion getBuildMetaInfoFactory() {
        return JsBuildMetaInfo.Companion;
    }

    @Override
    @NotNull
    public String getBuildMetaInfoFileName() {
        return "js-build-meta-info.txt";
    }

    public final boolean isFirstBuild() {
        File targetDataRoot;
        BuildDataManager buildDataManager = this.getJpsGlobalContext().getProjectDescriptor().dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"jpsGlobalContext.projectDescriptor.dataManager");
        File file = targetDataRoot = buildDataManager.getDataPaths().getTargetDataRoot((BuildTarget)this.getJpsModuleBuildTarget());
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"targetDataRoot");
        return !IncrementalJsCache.Companion.hasHeaderFile(file);
    }

    @Override
    public void makeServices(@NotNull Services.Builder builder, @NotNull Map<KotlinModuleBuildTarget<?>, ? extends JpsIncrementalCache> incrementalCaches, @NotNull LookupTracker lookupTracker, @NotNull ExpectActualTracker exceptActualTracer) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Intrinsics.checkParameterIsNotNull(incrementalCaches, (String)"incrementalCaches");
        Intrinsics.checkParameterIsNotNull((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkParameterIsNotNull((Object)exceptActualTracer, (String)"exceptActualTracer");
        super.makeServices(builder, incrementalCaches, lookupTracker, exceptActualTracer);
        Services.Builder $receiver = builder;
        $receiver.register(IncrementalResultsConsumer.class, new IncrementalResultsConsumerImpl());
        if (this.isIncrementalCompilationEnabled() && !this.isFirstBuild()) {
            JpsIncrementalCache jpsIncrementalCache = incrementalCaches.get(this);
            if (jpsIncrementalCache == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.incremental.IncrementalJsCache");
            }
            IncrementalJsCache cache = (IncrementalJsCache)((Object)jpsIncrementalCache);
            $receiver.register(IncrementalDataProvider.class, new IncrementalDataProviderFromCache(cache));
        }
    }

    @Override
    public boolean compileModuleChunk(@NotNull ModuleChunk chunk, @NotNull CommonCompilerArguments commonArguments, @NotNull KotlinDirtySourceFilesHolder dirtyFilesHolder2, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull((Object)commonArguments, (String)"commonArguments");
        Intrinsics.checkParameterIsNotNull((Object)dirtyFilesHolder2, (String)"dirtyFilesHolder");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        boolean bl = Intrinsics.areEqual((Object)chunk.representativeTarget(), (Object)this.getJpsModuleBuildTarget());
        if (!bl) {
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.reportAndSkipCircular(chunk, environment)) {
            return false;
        }
        Collection<File> sources = this.collectSourcesToCompile(dirtyFilesHolder2);
        if (!this.checkShouldCompileAndLog(dirtyFilesHolder2, sources)) {
            return false;
        }
        List libraries = CollectionsKt.plus((Collection)this.getLibraryFiles(), (Iterable)this.getDependenciesMetaFiles());
        new JpsKotlinCompilerRunner().runK2JsCompiler(commonArguments, ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()), environment, sources, (Collection<? extends File>)this.getSourceMapRoots(), libraries, this.getFriendBuildTargetsMetaFiles(), this.getOutputFile());
        return true;
    }

    @Override
    public void doAfterBuild() {
        this.copyJsLibraryFilesIfNeeded();
    }

    private final void copyJsLibraryFilesIfNeeded() {
        if (ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()).getCopyJsLibraryFiles()) {
            String outputLibraryRuntimeDirectory = new File(this.getOutputDir(), ModuleSettingsKt.getKotlinCompilerSettings(this.getModule()).getOutputDirectoryForJsLibraryFiles()).getAbsolutePath();
            List<String> list = this.getLibraryFiles();
            String string = outputLibraryRuntimeDirectory;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputLibraryRuntimeDirectory");
            JsLibraryUtils.copyJsFilesFromLibraries(list, string, ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()).getSourceMap());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<File> getSourceMapRoots() {
        List list;
        CharSequence charSequence = ModuleSettingsKt.getK2JsCompilerArguments(this.getModule()).getSourceMapPrefix();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            list = CollectionsKt.emptyList();
        } else {
            void var3_3;
            Comparable<URI> comparable;
            URI it;
            Collection collection;
            Iterable $receiver$iv$iv;
            JpsUrlList jpsUrlList = this.getModule().getContentRootsList();
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsUrlList, (String)"module.contentRootsList");
            List list2 = jpsUrlList.getUrls();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"module.contentRootsList.urls");
            Iterable $receiver$iv = list2;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                comparable = URI.create((String)((Object)it));
                collection.add(comparable);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                URI uRI = it = (URI)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"it");
                if (!Intrinsics.areEqual((Object)uRI.getScheme(), (Object)"file")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                it = (URI)item$iv$iv;
                collection = destination$iv$iv;
                URI uRI = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"it");
                comparable = new File(uRI.getPath());
                collection.add(comparable);
            }
            list = (List)var3_3;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getFriendBuildTargetsMetaFiles() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.getFriendBuildTargets();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            String string;
            Object object;
            Object element$iv$iv = element$iv$iv$iv;
            KotlinModuleBuildTarget it = (KotlinModuleBuildTarget)element$iv$iv;
            KotlinModuleBuildTarget kotlinModuleBuildTarget = it;
            if (!(kotlinModuleBuildTarget instanceof KotlinJsModuleBuildTarget)) {
                kotlinModuleBuildTarget = null;
            }
            String string2 = (object = (KotlinJsModuleBuildTarget)kotlinModuleBuildTarget) != null && (object = ((KotlinJsModuleBuildTarget)object).getOutputMetaFile()) != null && (object = ((File)object).getAbsoluteFile()) != null ? ((File)object).toString() : null;
            if (string2 == null) continue;
            String it$iv$iv = string = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)var3_3;
    }

    @NotNull
    public final File getOutputFile() {
        File file;
        String string = this.getExplicitOutputPath();
        if (string != null) {
            String string2;
            String it = string2 = string;
            file = new File(it);
        } else {
            file = this.getImplicitOutputFile();
        }
        return file;
    }

    private final String getExplicitOutputPath() {
        return this.isTests() ? ModuleSettingsKt.getTestOutputFilePath(this.getModule()) : ModuleSettingsKt.getProductionOutputFilePath(this.getModule());
    }

    private final File getImplicitOutputFile() {
        String suffix = this.isTests() ? "_test" : "";
        return new File(this.getOutputDir(), this.getModule().getName() + suffix + ".js");
    }

    private final String getOutputFileBaseName() {
        String string = this.getOutputFile().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputFile.path");
        return StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null);
    }

    @NotNull
    public final File getOutputMetaFile() {
        return new File(this.getOutputFileBaseName() + ".meta.js");
    }

    private final List<String> getLibraryFiles() {
        List list;
        List result = list = (List)new ArrayList();
        JpsJavaDependenciesEnumerator jpsJavaDependenciesEnumerator = this.getAllDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsJavaDependenciesEnumerator, (String)"allDependencies");
        for (JpsLibrary library : jpsJavaDependenciesEnumerator.getLibraries()) {
            Iterator iterator2 = library.getRoots(JpsOrderRootType.COMPILED).iterator();
            while (iterator2.hasNext()) {
                JpsLibraryRoot root;
                JpsLibraryRoot jpsLibraryRoot = root = (JpsLibraryRoot)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsLibraryRoot, (String)"root");
                String string = JpsPathUtil.urlToPath((String)jpsLibraryRoot.getUrl());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"JpsPathUtil.urlToPath(root.url)");
                result.add(string);
            }
        }
        return list;
    }

    private final List<String> getDependenciesMetaFiles() {
        List list;
        List result = list = (List)new ArrayList();
        this.getAllDependencies().processModules((Consumer)new Consumer<JpsModule>(result, this){
            final /* synthetic */ List $result;
            final /* synthetic */ KotlinJsModuleBuildTarget this$0;
            {
                this.$result = list;
                this.this$0 = kotlinJsModuleBuildTarget;
            }

            public final void consume(JpsModule module) {
                if (this.this$0.isTests()) {
                    JpsModule jpsModule = module;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                    KotlinJsModuleBuildTarget.access$addDependencyMetaFile(this.this$0, jpsModule, this.$result, true);
                }
                JpsModule jpsModule = module;
                Intrinsics.checkExpressionValueIsNotNull((Object)jpsModule, (String)"module");
                KotlinJsModuleBuildTarget.access$addDependencyMetaFile(this.this$0, jpsModule, this.$result, false);
            }
        });
        return list;
    }

    private final void addDependencyMetaFile(JpsModule module, List<String> result, boolean isTests) {
        File metaFile;
        Map<File, KotlinModuleBuildTarget.Source> map2;
        KotlinModuleBuildTarget<?> dependencyBuildTarget = this.getKotlinContext().getTargetsBinding().get(JpsUtilKt.ModuleBuildTarget(module, isTests));
        if (Intrinsics.areEqual(dependencyBuildTarget, (Object)this) ^ true && dependencyBuildTarget instanceof KotlinJsModuleBuildTarget && !(map2 = dependencyBuildTarget.getSources()).isEmpty() && (metaFile = ((KotlinJsModuleBuildTarget)dependencyBuildTarget).getOutputMetaFile()).exists()) {
            String string = metaFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"metaFile.absolutePath");
            result.add(string);
        }
    }

    @Override
    @NotNull
    public JpsIncrementalJsCache createCacheStorage(@NotNull BuildDataPaths paths) {
        Intrinsics.checkParameterIsNotNull((Object)paths, (String)"paths");
        return new JpsIncrementalJsCache(this.getJpsModuleBuildTarget(), paths);
    }

    @Override
    public void updateCaches(@NotNull JpsIncrementalCache jpsIncrementalCache, @NotNull List<? extends GeneratedFile> files, @NotNull ChangesCollector changesCollector, @NotNull JpsCompilerEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)jpsIncrementalCache, (String)"jpsIncrementalCache");
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull((Object)changesCollector, (String)"changesCollector");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        super.updateCaches(jpsIncrementalCache, files, changesCollector, environment);
        IncrementalResultsConsumer incrementalResultsConsumer = environment.getServices().get(IncrementalResultsConsumer.class);
        if (incrementalResultsConsumer == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.incremental.js.IncrementalResultsConsumerImpl");
        }
        IncrementalResultsConsumerImpl incrementalResults = (IncrementalResultsConsumerImpl)incrementalResultsConsumer;
        IncrementalJsCache jsCache = (IncrementalJsCache)((Object)jpsIncrementalCache);
        jsCache.setHeader(incrementalResults.getHeaderMetadata());
        jsCache.compareAndUpdate(incrementalResults, changesCollector);
        jsCache.clearCacheForRemovedClasses(changesCollector);
    }

    public KotlinJsModuleBuildTarget(@NotNull KotlinCompileContext kotlinContext, @NotNull ModuleBuildTarget jpsModuleBuildTarget) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinContext, (String)"kotlinContext");
        Intrinsics.checkParameterIsNotNull((Object)jpsModuleBuildTarget, (String)"jpsModuleBuildTarget");
        super(kotlinContext, jpsModuleBuildTarget);
    }

    public static final /* synthetic */ void access$addDependencyMetaFile(KotlinJsModuleBuildTarget $this, @NotNull JpsModule module, @NotNull List result, boolean isTests) {
        $this.addDependencyMetaFile(module, result, isTests);
    }
}

