/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vaadin.framework;

import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ui.FacetBasedFrameworkSupportProvider;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.FrameworkLibraryVersionFilter;
import com.intellij.framework.library.LibraryBasedFrameworkSupportProvider;
import com.intellij.gwt.facet.GwtFacetFrameworkSupportProvider;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.ide.util.PackageUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.newProjectWizard.impl.FrameworkSupportModelBase;
import com.intellij.javaee.artifact.JavaeeArtifactUtil;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.model.xml.web.InitParam;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.artifact.WebArtifactUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.vaadin.framework.VaadinFrameworkType;
import com.intellij.vaadin.framework.VaadinLibraryType;
import com.intellij.vaadin.framework.VaadinVersion;
import com.intellij.vaadin.framework.VaadinVersionImpl;
import com.intellij.vaadin.framework.VaadinVersionUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaadinFrameworkSupportProvider
extends LibraryBasedFrameworkSupportProvider {
    public VaadinFrameworkSupportProvider(VaadinFrameworkType type) {
        super((FrameworkTypeEx)type, VaadinLibraryType.class);
    }

    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        if (model == null) {
            VaadinFrameworkSupportProvider.$$$reportNull$$$0(0);
        }
        VaadinFrameworkSupportConfigurable vaadinFrameworkSupportConfigurable = new VaadinFrameworkSupportConfigurable(model);
        if (vaadinFrameworkSupportConfigurable == null) {
            VaadinFrameworkSupportProvider.$$$reportNull$$$0(1);
        }
        return vaadinFrameworkSupportConfigurable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vaadin/framework/VaadinFrameworkSupportProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vaadin/framework/VaadinFrameworkSupportProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class VaadinFrameworkSupportConfigurable
    extends FrameworkSupportInModuleConfigurable {
        private static final String PATH_TO_INSTALLATION_KEY = "PATH_TO_VAADIN_INSTALLATION";
        private final FrameworkSupportModel myModel;
        private JPanel myMainPanel;
        private JCheckBox myCreateSampleAppCheckBox;
        private JTextField myAppNameField;
        private ComboBox myVersionComboBox;
        private JPanel myVaadinSdkPanel;
        private TextFieldWithBrowseButton mySdkPathField;
        private HyperlinkLabel myErrorLabel;

        VaadinFrameworkSupportConfigurable(FrameworkSupportModel model) {
            this.myModel = model;
            this.$$$setupUI$$$();
        }

        @Nullable
        public JComponent createComponent() {
            this.mySdkPathField.addBrowseFolderListener("Path to Vaadin installation directory", null, null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR);
            this.mySdkPathField.setText(PropertiesComponent.getInstance().getValue(PATH_TO_INSTALLATION_KEY, ""));
            this.mySdkPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.onSdkPathChanged();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vaadin/framework/VaadinFrameworkSupportProvider$VaadinFrameworkSupportConfigurable$1", "textChanged"));
                }
            });
            this.myErrorLabel.setHyperlinkTarget("https://vaadin.com/releases");
            this.myErrorLabel.setIcon(AllIcons.General.BalloonError);
            this.myVersionComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<VaadinVersion>(){

                public void customize(JList list, VaadinVersion value, int index, boolean selected, boolean hasFocus) {
                    if (value != null) {
                        this.setText(value.getVersionName());
                    }
                }
            });
            this.myVersionComboBox.setModel((ComboBoxModel)new EnumComboBoxModel(VaadinVersionImpl.class));
            this.myVersionComboBox.setSelectedItem((Object)VaadinVersionUtil.getDefaultVersion());
            this.myVersionComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.onVersionChanged();
                }
            });
            this.myCreateSampleAppCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    myAppNameField.setEnabled(myCreateSampleAppCheckBox.isSelected());
                }
            });
            this.onVersionChanged();
            return this.myMainPanel;
        }

        private void onVersionChanged() {
            this.myModel.updateFrameworkLibraryComponent("vaadin");
            this.myVaadinSdkPanel.setVisible(this.getSelectedVersion().isFullDistributionRequired());
            this.onSdkPathChanged();
        }

        public void onFrameworkSelectionChanged(boolean selected) {
            this.myAppNameField.setEnabled(selected && this.myCreateSampleAppCheckBox.isSelected());
        }

        private void onSdkPathChanged() {
            if (!this.getSelectedVersion().isFullDistributionRequired()) {
                return;
            }
            String path = this.mySdkPathField.getText();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                this.myErrorLabel.setVisible(true);
                this.myErrorLabel.setHyperlinkText("Path to Vaadin installation is not specified. ", "Download Vaadin", "");
            } else {
                this.myErrorLabel.setVisible(false);
                FrameworkSupportConfigurable gwtConfigurable = this.myModel.findFrameworkConfigurable(FacetBasedFrameworkSupportProvider.getProviderId((FacetTypeId)GwtFacetType.ID));
                if (gwtConfigurable instanceof GwtFacetFrameworkSupportProvider.GwtFrameworkSupportConfigurable) {
                    ((GwtFacetFrameworkSupportProvider.GwtFrameworkSupportConfigurable)gwtConfigurable).getSdkPathEditor().setPath(path);
                }
            }
            this.myMainPanel.repaint();
        }

        public void addSupport(@NotNull Module module, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
            String applicationClassName;
            if (module == null) {
                VaadinFrameworkSupportConfigurable.$$$reportNull$$$0(0);
            }
            if (rootModel == null) {
                VaadinFrameworkSupportConfigurable.$$$reportNull$$$0(1);
            }
            if (modifiableModelsProvider == null) {
                VaadinFrameworkSupportConfigurable.$$$reportNull$$$0(2);
            }
            WebFacet webFacet = (WebFacet)ContainerUtil.getFirstItem((Collection)WebFacet.getInstances((Module)module));
            Project project = module.getProject();
            VaadinVersion version = this.getSelectedVersion();
            Library serverLibrary = null;
            if (version.isFullDistributionRequired()) {
                VirtualFile dir;
                LibrariesContainer container;
                String path = this.mySdkPathField.getText();
                if (!StringUtil.isEmpty((String)path)) {
                    PropertiesComponent.getInstance().setValue(PATH_TO_INSTALLATION_KEY, path);
                }
                if (!(container = ((FrameworkSupportModelBase)this.myModel).getLibrariesContainer()).canCreateLibrary(LibrariesContainer.LibraryLevel.PROJECT)) {
                    container = LibrariesContainerFactory.createContainer((Project)project);
                }
                if ((dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path))) != null) {
                    ArrayList<OrderRoot> clientRoots = new ArrayList<OrderRoot>();
                    ArrayList<OrderRoot> serverRoots = new ArrayList<OrderRoot>();
                    for (VirtualFile file : dir.getChildren()) {
                        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
                        if (jar == null) continue;
                        String fileName = file.getName();
                        if (fileName.startsWith("vaadin-client") && !fileName.startsWith("vaadin-client-compiled")) {
                            clientRoots.add(new OrderRoot(jar, OrderRootType.CLASSES));
                            clientRoots.add(new OrderRoot(jar, OrderRootType.SOURCES));
                            continue;
                        }
                        serverRoots.add(new OrderRoot(jar, OrderRootType.CLASSES));
                    }
                    Library clientLibrary = VaadinFrameworkSupportConfigurable.findOrCreateLibrary("Vaadin Client", container, clientRoots);
                    rootModel.addLibraryEntry(clientLibrary).setScope(DependencyScope.PROVIDED);
                    VirtualFile libDir = dir.findChild("lib");
                    if (libDir != null) {
                        for (VirtualFile file : libDir.getChildren()) {
                            VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
                            if (jar == null || jar.getName().startsWith("guava")) continue;
                            serverRoots.add(new OrderRoot(jar, OrderRootType.CLASSES));
                        }
                    }
                    serverLibrary = VaadinFrameworkSupportConfigurable.findOrCreateLibrary("Vaadin Server", container, serverRoots);
                    rootModel.addLibraryEntry(serverLibrary);
                }
            }
            if (this.myCreateSampleAppCheckBox.isSelected()) {
                applicationClassName = this.myAppNameField.getText().trim();
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    if (module == null) {
                        VaadinFrameworkSupportConfigurable.$$$reportNull$$$0(4);
                    }
                    WriteCommandAction.writeCommandAction((Project)project).run(() -> {
                        String packageName;
                        PsiDirectory directory;
                        if (module == null) {
                            VaadinFrameworkSupportConfigurable.$$$reportNull$$$0(5);
                        }
                        if ((directory = PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)(packageName = StringUtil.getPackageName((String)applicationClassName)), null, (boolean)false)) != null) {
                            JavaDirectoryService.getInstance().createClass(directory, StringUtil.getShortName((String)applicationClassName), version.getTemplateNames().getApplication());
                        }
                    });
                });
            } else {
                applicationClassName = null;
            }
            if (webFacet != null) {
                if (serverLibrary != null) {
                    ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project);
                    PackagingElementResolvingContext context = artifactManager.getResolvingContext();
                    Collection artifacts = JavaeeArtifactUtil.getInstance().getArtifactsContainingFacet((JavaeeFacet)webFacet, context, WebArtifactUtil.getInstance().getWebArtifactTypes(), false);
                    for (Artifact artifact : artifacts) {
                        artifactManager.addElementsToDirectory(artifact, "/WEB-INF/lib", (Collection)PackagingElementFactory.getInstance().createLibraryElements(serverLibrary));
                    }
                }
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)new SetupVaadinInWebXmlRunnable(webFacet, version, applicationClassName));
            }
        }

        private static Library findOrCreateLibrary(String libraryName, LibrariesContainer container, List<OrderRoot> clientRoots) {
            for (Library library : container.getLibraries(LibrariesContainer.LibraryLevel.PROJECT)) {
                if (!libraryName.equals(library.getName())) continue;
                return library;
            }
            return container.createLibrary(libraryName, LibrariesContainer.LibraryLevel.PROJECT, clientRoots);
        }

        @NotNull
        public FrameworkLibraryVersionFilter getLibraryVersionFilter() {
            FrameworkLibraryVersionFilter frameworkLibraryVersionFilter = new FrameworkLibraryVersionFilter(){

                public boolean isAccepted(@NotNull FrameworkLibraryVersion version) {
                    if (version == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return !this.getSelectedVersion().isFullDistributionRequired();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/vaadin/framework/VaadinFrameworkSupportProvider$VaadinFrameworkSupportConfigurable$5", "isAccepted"));
                }
            };
            if (frameworkLibraryVersionFilter == null) {
                VaadinFrameworkSupportConfigurable.$$$reportNull$$$0(3);
            }
            return frameworkLibraryVersionFilter;
        }

        private VaadinVersion getSelectedVersion() {
            return (VaadinVersion)ObjectUtils.notNull((Object)((VaadinVersion)this.myVersionComboBox.getSelectedItem()), (Object)VaadinVersionUtil.getDefaultVersion());
        }

        public boolean isVisible() {
            return !this.getSelectedVersion().isFullDistributionRequired();
        }

        @Nullable
        public CustomLibraryDescription createLibraryDescription() {
            return DownloadableLibraryService.getInstance().createDescriptionForType(VaadinLibraryType.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootModel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modifiableModelsProvider";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vaadin/framework/VaadinFrameworkSupportProvider$VaadinFrameworkSupportConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vaadin/framework/VaadinFrameworkSupportProvider$VaadinFrameworkSupportConfigurable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryVersionFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addSupport";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addSupport$1";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$null$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            HyperlinkLabel hyperlinkLabel;
            TextFieldWithBrowseButton textFieldWithBrowseButton;
            JPanel jPanel;
            ComboBox comboBox;
            JTextField jTextField;
            JCheckBox jCheckBox;
            JPanel jPanel2;
            this.myMainPanel = jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myCreateSampleAppCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Create sample application:");
            jPanel2.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 6, null, null, null));
            this.myAppNameField = jTextField = new JTextField();
            jTextField.setText("com.MyVaadinApplication");
            jPanel2.add((Component)jTextField, new GridConstraints(4, 0, 1, 3, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
            JLabel jLabel = new JLabel();
            jLabel.setText("Version:");
            jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myVersionComboBox = comboBox = new ComboBox();
            jPanel2.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            this.myVaadinSdkPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
            this.mySdkPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Vaadin Distribution:");
            jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myErrorLabel = hyperlinkLabel = new HyperlinkLabel();
            jPanel.add((Component)hyperlinkLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }

        private static class SetupVaadinInWebXmlRunnable
        implements Runnable {
            private final WebFacet myWebFacet;
            private final VaadinVersion myVersion;
            @Nullable
            private final String myApplicationClassName;

            SetupVaadinInWebXmlRunnable(@NotNull WebFacet webFacet, @NotNull VaadinVersion version, @Nullable String applicationClassName) {
                if (webFacet == null) {
                    SetupVaadinInWebXmlRunnable.$$$reportNull$$$0(0);
                }
                if (version == null) {
                    SetupVaadinInWebXmlRunnable.$$$reportNull$$$0(1);
                }
                this.myWebFacet = webFacet;
                this.myVersion = version;
                this.myApplicationClassName = applicationClassName;
            }

            @Override
            public void run() {
                XmlFile file;
                WebApp root = this.myWebFacet.getRoot();
                ConfigFile descriptor = this.myWebFacet.getWebXmlDescriptor();
                XmlFile xmlFile = file = descriptor != null ? descriptor.getXmlFile() : null;
                if (root != null && file != null) {
                    Project project = this.myWebFacet.getModule().getProject();
                    WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> this.lambda$run$0(root, project, (PsiFile)file));
                }
            }

            private /* synthetic */ void lambda$run$0(WebApp root, Project project, PsiFile file) throws RuntimeException {
                Servlet servlet = root.addServlet();
                servlet.getServletName().setValue((Object)"VaadinApplicationServlet");
                servlet.getServletClass().setStringValue(this.myVersion.getServletClass());
                if (this.myApplicationClassName != null) {
                    InitParam param = servlet.addInitParam();
                    param.getParamName().setValue((Object)this.myVersion.getApplicationServletParameterName());
                    param.getParamValue().setValue((Object)this.myApplicationClassName);
                }
                ServletMapping mapping = root.addServletMapping();
                mapping.getServletName().setValue((Object)servlet);
                mapping.addUrlPattern().setValue((Object)"/*");
                CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "webFacet";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "version";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/vaadin/framework/VaadinFrameworkSupportProvider$VaadinFrameworkSupportConfigurable$SetupVaadinInWebXmlRunnable";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

