/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.ext.uml;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.ext.uml.MavenDependencyRelationship;
import org.jetbrains.idea.maven.ext.uml.MavenElement;
import org.jetbrains.idea.maven.ext.uml.MavenUmlEdge;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;

public class MavenUmlColorManager
extends DiagramColorManagerBase {
    public static final Color PROJECT_HEADER_COLOR = new JBColor(new Color(158, 188, 195), new Color(13, 41, 62));
    public static final Color TEST_HEADER_COLOR = new JBColor(new Color(190, 238, 217), new Color(49, 59, 50));

    public Color getEdgeColor(DiagramEdge edge) {
        if (edge.getRelationship() instanceof MavenDependencyRelationship) {
            return JBColor.RED;
        }
        if (edge.getRelationship() == MavenUmlEdge.DUPLICATE) {
            return JBColor.RED;
        }
        MavenElement trg = (MavenElement)edge.getTarget().getIdentifyingElement();
        MavenArtifactState state = trg.getState();
        Color result = GENERALIZATION;
        if (state != null) {
            switch (state) {
                case ADDED: 
                case DUPLICATE: {
                    result = GENERALIZATION;
                    break;
                }
                case CONFLICT: 
                case CYCLE: {
                    result = JBColor.RED;
                    break;
                }
                default: {
                    result = JBColor.foreground();
                }
            }
        }
        return result;
    }

    public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
        if (node != null) {
            MavenElement element = (MavenElement)node.getIdentifyingElement();
            if (element.isProject()) {
                return PROJECT_HEADER_COLOR;
            }
            if (element.isTestArtifact()) {
                return TEST_HEADER_COLOR;
            }
            if (element.getScope() == MavenArtifactScope.TEST) {
                return REALIZATION;
            }
        }
        return NODE_HEADER_COLOR;
    }
}

