/*
 * Decompiled with CFR 0.152.
 */
package org.jf.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.util.ExceptionWithContext;

public class ClassFileNameHandler {
    private static final int MAX_FILENAME_LENGTH = 255;
    private static final int NUMERIC_SUFFIX_RESERVE = 6;
    private final int NO_VALUE = -1;
    private final int CASE_INSENSITIVE = 0;
    private final int CASE_SENSITIVE = 1;
    private int forcedCaseSensitivity = -1;
    private DirectoryEntry top;
    private String fileExtension;
    private boolean modifyWindowsReservedFilenames;
    private static Pattern reservedFileNameRegex = Pattern.compile("^(CON|PRN|AUX|NUL|COM[1-9]|LPT[1-9])(\\..*)?$", 2);

    public ClassFileNameHandler(File path, String fileExtension) {
        this.top = new DirectoryEntry(path);
        this.fileExtension = fileExtension;
        this.modifyWindowsReservedFilenames = ClassFileNameHandler.isWindows();
    }

    public ClassFileNameHandler(File path, String fileExtension, boolean caseSensitive, boolean modifyWindowsReservedFilenames) {
        this.top = new DirectoryEntry(path);
        this.fileExtension = fileExtension;
        this.forcedCaseSensitivity = caseSensitive ? 1 : 0;
        this.modifyWindowsReservedFilenames = modifyWindowsReservedFilenames;
    }

    private int getMaxFilenameLength() {
        return 249;
    }

    public File getUniqueFilenameForClass(String className) {
        if (className.charAt(0) != 'L' || className.charAt(className.length() - 1) != ';') {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        int packageElementCount = 1;
        for (int i = 1; i < className.length() - 1; ++i) {
            if (className.charAt(i) != '/') continue;
            ++packageElementCount;
        }
        String[] packageElements = new String[packageElementCount];
        int elementIndex = 0;
        int elementStart = 1;
        for (int i = 1; i < className.length() - 1; ++i) {
            if (className.charAt(i) != '/') continue;
            if (i - elementStart == 0) {
                throw new RuntimeException("Not a valid dalvik class name");
            }
            packageElements[elementIndex++] = className.substring(elementStart, i);
            elementStart = ++i;
        }
        if (elementStart >= className.length() - 1) {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        packageElements[elementIndex] = className.substring(elementStart, className.length() - 1);
        return this.addUniqueChild(this.top, packageElements, 0);
    }

    @Nonnull
    private File addUniqueChild(@Nonnull DirectoryEntry parent, @Nonnull String[] packageElements, int packageElementIndex) {
        if (packageElementIndex == packageElements.length - 1) {
            FileEntry fileEntry = new FileEntry(parent, packageElements[packageElementIndex] + this.fileExtension);
            parent.addChild(fileEntry);
            String physicalName = fileEntry.getPhysicalName();
            assert (physicalName != null);
            return new File(parent.file, physicalName);
        }
        DirectoryEntry directoryEntry = new DirectoryEntry(parent, packageElements[packageElementIndex]);
        directoryEntry = (DirectoryEntry)parent.addChild(directoryEntry);
        return this.addUniqueChild(directoryEntry, packageElements, packageElementIndex + 1);
    }

    private static int utf8Length(String str) {
        int c;
        int utf8Length = 0;
        for (int i = 0; i < str.length(); i += Character.charCount(c)) {
            c = str.codePointAt(i);
            utf8Length += ClassFileNameHandler.utf8Length(c);
        }
        return utf8Length;
    }

    private static int utf8Length(int codePoint) {
        if (codePoint < 128) {
            return 1;
        }
        if (codePoint < 2048) {
            return 2;
        }
        if (codePoint < 65536) {
            return 3;
        }
        return 4;
    }

    @Nonnull
    static String shortenPathComponent(@Nonnull String pathComponent, int bytesToRemove) {
        int i;
        int midPoint;
        int[] codePoints;
        ++bytesToRemove;
        try {
            IntBuffer intBuffer = ByteBuffer.wrap(pathComponent.getBytes("UTF-32BE")).asIntBuffer();
            codePoints = new int[intBuffer.limit()];
            intBuffer.get(codePoints);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        int firstEnd = midPoint = codePoints.length / 2;
        int secondStart = midPoint + 1;
        int bytesRemoved = ClassFileNameHandler.utf8Length(codePoints[midPoint]);
        if (codePoints.length % 2 == 0 && bytesRemoved < bytesToRemove) {
            bytesRemoved += ClassFileNameHandler.utf8Length(codePoints[secondStart]);
            ++secondStart;
        }
        while (bytesRemoved < bytesToRemove && (firstEnd > 0 || secondStart < codePoints.length)) {
            if (firstEnd > 0) {
                bytesRemoved += ClassFileNameHandler.utf8Length(codePoints[--firstEnd]);
            }
            if (bytesRemoved >= bytesToRemove || secondStart >= codePoints.length) continue;
            bytesRemoved += ClassFileNameHandler.utf8Length(codePoints[secondStart]);
            ++secondStart;
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < firstEnd; ++i) {
            sb.appendCodePoint(codePoints[i]);
        }
        sb.append('#');
        for (i = secondStart; i < codePoints.length; ++i) {
            sb.appendCodePoint(codePoints[i]);
        }
        return sb.toString();
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static boolean isReservedFileName(String className) {
        return reservedFileNameRegex.matcher(className).matches();
    }

    private static String addSuffixBeforeExtension(String pathElement, String suffix) {
        int extensionStart = pathElement.lastIndexOf(46);
        StringBuilder newName = new StringBuilder(pathElement.length() + suffix.length() + 1);
        if (extensionStart < 0) {
            newName.append(pathElement);
            newName.append(suffix);
        } else {
            newName.append(pathElement.subSequence(0, extensionStart));
            newName.append(suffix);
            newName.append(pathElement.subSequence(extensionStart, pathElement.length()));
        }
        return newName.toString();
    }

    private class FileEntry
    extends FileSystemEntry {
        private FileEntry(@Nonnull DirectoryEntry parent, String logicalName) {
            super(parent, logicalName);
        }

        @Override
        protected String makePhysicalName(int suffix) {
            if (suffix > 0) {
                return ClassFileNameHandler.addSuffixBeforeExtension(this.getNormalizedName(true), '.' + Integer.toString(suffix));
            }
            return this.getNormalizedName(true);
        }
    }

    private class DirectoryEntry
    extends FileSystemEntry {
        @Nullable
        private File file;
        private int caseSensitivity;
        private final Multimap<String, FileSystemEntry> children;

        public DirectoryEntry(File path) {
            super(null, path.getName());
            this.file = null;
            this.caseSensitivity = ClassFileNameHandler.this.forcedCaseSensitivity;
            this.children = ArrayListMultimap.create();
            this.file = path;
            this.physicalName = this.file.getName();
        }

        public DirectoryEntry(@Nonnull DirectoryEntry parent, String logicalName) {
            super(parent, logicalName);
            this.file = null;
            this.caseSensitivity = ClassFileNameHandler.this.forcedCaseSensitivity;
            this.children = ArrayListMultimap.create();
        }

        public synchronized FileSystemEntry addChild(FileSystemEntry entry) {
            String normalizedChildName = entry.getNormalizedName(false);
            Collection entries = this.children.get((Object)normalizedChildName);
            if (entry instanceof DirectoryEntry) {
                for (FileSystemEntry childEntry : entries) {
                    if (!childEntry.logicalName.equals(entry.logicalName)) continue;
                    return childEntry;
                }
            }
            entry.setSuffix(entries.size());
            entries.add(entry);
            return entry;
        }

        @Override
        protected String makePhysicalName(int suffix) {
            if (suffix > 0) {
                return this.getNormalizedName(true) + "." + Integer.toString(suffix);
            }
            return this.getNormalizedName(true);
        }

        @Override
        public void setSuffix(int suffix) {
            super.setSuffix(suffix);
            String physicalName = this.getPhysicalName();
            if (this.parent != null && physicalName != null) {
                this.file = new File(this.parent.file, physicalName);
            }
        }

        protected boolean isCaseSensitive() {
            if (this.getPhysicalName() == null || this.file == null) {
                throw new IllegalStateException("Must call setSuffix() first");
            }
            if (this.caseSensitivity != -1) {
                return this.caseSensitivity == 1;
            }
            File path = this.file;
            if (path.exists() && path.isFile() && !path.delete()) {
                throw new ExceptionWithContext("Can't delete %s to make it into a directory", path.getAbsolutePath());
            }
            if (!path.exists() && !path.mkdirs()) {
                throw new ExceptionWithContext("Couldn't create directory %s", path.getAbsolutePath());
            }
            try {
                boolean result = this.testCaseSensitivity(path);
                this.caseSensitivity = result ? 1 : 0;
                return result;
            }
            catch (IOException ex) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean testCaseSensitivity(File path) throws IOException {
            File f2;
            File f;
            int num = 1;
            do {
                f = new File(path, "test." + num);
                f2 = new File(path, "TEST." + num++);
            } while (f.exists() || f2.exists());
            try {
                try {
                    FileWriter writer = new FileWriter(f);
                    writer.write("test");
                    writer.flush();
                    writer.close();
                }
                catch (IOException ex) {
                    try {
                        f.delete();
                        throw ex;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw ex;
                }
                if (f2.exists()) {
                    boolean ex = false;
                    return ex;
                }
                if (f2.createNewFile()) {
                    boolean ex = true;
                    return ex;
                }
                CharBuffer buf = CharBuffer.allocate(32);
                FileReader reader = new FileReader(f2);
                while (reader.read(buf) != -1 && buf.length() < 4) {
                }
                if (buf.length() == 4 && buf.toString().equals("test")) {
                    boolean bl = false;
                    return bl;
                }
                assert (false);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    f.delete();
                }
                catch (Exception exception) {}
                try {
                    f2.delete();
                }
                catch (Exception exception) {}
            }
        }
    }

    private abstract class FileSystemEntry {
        @Nullable
        public final DirectoryEntry parent;
        @Nonnull
        public final String logicalName;
        @Nullable
        protected String physicalName = null;

        private FileSystemEntry(@Nonnull DirectoryEntry parent, String logicalName) {
            this.parent = parent;
            this.logicalName = logicalName;
        }

        @Nonnull
        public String getNormalizedName(boolean preserveCase) {
            int utf8Length;
            String elementName = this.logicalName;
            if (!preserveCase && this.parent != null && !this.parent.isCaseSensitive()) {
                elementName = elementName.toLowerCase();
            }
            if (ClassFileNameHandler.this.modifyWindowsReservedFilenames && ClassFileNameHandler.isReservedFileName(elementName)) {
                elementName = ClassFileNameHandler.addSuffixBeforeExtension(elementName, "#");
            }
            if ((utf8Length = ClassFileNameHandler.utf8Length(elementName)) > ClassFileNameHandler.this.getMaxFilenameLength()) {
                elementName = ClassFileNameHandler.shortenPathComponent(elementName, utf8Length - ClassFileNameHandler.this.getMaxFilenameLength());
            }
            return elementName;
        }

        @Nullable
        public String getPhysicalName() {
            return this.physicalName;
        }

        public void setSuffix(int suffix) {
            if (suffix < 0 || suffix > 99999) {
                throw new IllegalArgumentException("suffix must be in [0, 100000)");
            }
            if (this.physicalName != null) {
                throw new IllegalStateException("The suffix can only be set once");
            }
            this.physicalName = this.makePhysicalName(suffix);
        }

        protected abstract String makePhysicalName(int var1);
    }
}

