/*
 * Decompiled with CFR 0.152.
 */
package org.gga.graph.flow;

import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.IntStack;
import java.util.Iterator;
import org.gga.graph.Edge;
import org.gga.graph.EdgeIterator;
import org.gga.graph.Graph;
import org.gga.graph.Reverse;
import org.gga.graph.impl.SparseGraphImpl;
import org.gga.graph.search.bfs.AbstractBfsVisitor;
import org.gga.graph.search.bfs.BreadthFirstSearch;

public class PushRelabelMaxFlow {
    private static final int ALPHA = 6;
    private static final int BETA = 12;
    private static final double GLOBAL_UPDATE_FREQ = 0.5;
    private final Graph g;
    private final Graph reverseGraph;
    private final int src;
    private final int sink;
    private final int[] residualCapacity;
    private final int[] distance;
    private final int[] excessFlow;
    private final Layer[] layers;
    private final EdgeIterator[] current;
    private final int nm;
    private int maxDistance;
    private int maxActive;
    private int minActive;
    private long workSinceLastUpdate;
    private final int n;

    public PushRelabelMaxFlow(Graph g, Graph reverseGraph, int[] capacity, int src, int sink) {
        this.reverseGraph = reverseGraph;
        this.g = g;
        this.src = src;
        this.sink = sink;
        this.n = g.V();
        this.layers = new Layer[this.n + 1];
        for (int i = 0; i < this.layers.length; ++i) {
            this.layers[i] = new Layer();
        }
        this.distance = new int[this.n];
        this.nm = g.E() + g.V() * 6;
        assert (capacity.length == g.E());
        this.residualCapacity = new int[g.E()];
        System.arraycopy(capacity, 0, this.residualCapacity, 0, capacity.length);
        this.excessFlow = new int[g.V()];
        this.current = new EdgeIterator[g.V()];
        for (int v = 0; v < g.V(); ++v) {
            this.excessFlow[v] = 0;
            this.current[v] = g.getEdgeIterator(v);
        }
        this.maxDistance = 0;
        this.maxActive = 0;
        this.minActive = this.n;
        this.excessFlow[src] = Integer.MAX_VALUE;
        Iterator<Edge> i = g.getEdges(src);
        while (i.hasNext()) {
            int w;
            Edge edge = i.next();
            int n = w = edge.w();
            this.excessFlow[n] = this.excessFlow[n] + this.residualCapacity[edge.idx()];
            this.residualCapacity[edge.idx()] = 0;
        }
        this.globalDistanceUpdate();
    }

    private boolean isResidual(Edge e) {
        return this.residualCapacity[e.idx()] > 0;
    }

    private boolean isAdmissible(int v, int w) {
        return this.distance[v] == this.distance[w] + 1;
    }

    private boolean isAdmissible(Edge e) {
        return this.isAdmissible(e.v(), e.w());
    }

    private void relabel(int v) {
        this.workSinceLastUpdate += 12L;
        int minDist = this.n;
        Iterator<Edge> i = this.g.getEdges(v);
        while (i.hasNext()) {
            ++this.workSinceLastUpdate;
            Edge e = i.next();
            int w = e.other(v);
            if (this.distance[w] >= minDist || !this.isResidual(e)) continue;
            minDist = this.distance[w];
        }
        if (minDist < this.n) {
            this.distance[v] = minDist + 1;
            this.addToActiveList(v);
        }
    }

    private void push(Edge e) {
        assert (this.isAdmissible(e));
        int v = e.v();
        int w = e.w();
        int flowDelta = Math.min(this.excessFlow[v], this.residualCapacity[e.idx()]);
        int n = e.idx();
        this.residualCapacity[n] = this.residualCapacity[n] - flowDelta;
        int n2 = v;
        this.excessFlow[n2] = this.excessFlow[n2] - flowDelta;
        if (this.excessFlow[w] == 0 && w != this.sink) {
            this.removeFromInactiveList(w);
            this.addToActiveList(w);
        }
        int n3 = w;
        this.excessFlow[n3] = this.excessFlow[n3] + flowDelta;
    }

    private boolean isActive(int v) {
        return v != this.sink && v != this.src && this.distance[v] < this.n && this.excessFlow[v] > 0;
    }

    private void discharge(int v) {
        EdgeIterator i = this.current[v];
        boolean endOfList = false;
        do {
            Edge e;
            if (this.isAdmissible(e = i.edge()) && this.isResidual(e)) {
                this.push(e);
                continue;
            }
            if (i.hasNext()) {
                i.advance();
                continue;
            }
            this.current[v] = this.g.getEdgeIterator(v);
            endOfList = true;
        } while (!endOfList && this.excessFlow[v] != 0);
        if (endOfList) {
            this.relabel(v);
        }
    }

    private void addToInactiveList(int v) {
        Layer layer = this.layers[this.distance[v]];
        layer.inactive.add(v);
    }

    private void addToActiveList(int v) {
        Layer layer = this.layers[this.distance[v]];
        layer.active.push(v);
        this.maxActive = Math.max(this.distance[v], this.maxActive);
        this.minActive = Math.min(this.distance[v], this.minActive);
    }

    private void removeFromInactiveList(int v) {
        this.layers[this.distance[v]].inactive.remove(v);
    }

    private int maxPreFlow() {
        this.workSinceLastUpdate = 0L;
        while (this.maxActive >= this.minActive) {
            Layer l = this.layers[this.maxActive];
            IntStack active = l.active;
            if (active.empty()) {
                --this.maxActive;
            } else {
                int v = active.pop();
                this.discharge(v);
            }
            if (!((double)this.workSinceLastUpdate * 0.5 > (double)this.nm)) continue;
            this.workSinceLastUpdate = 0L;
        }
        return this.excessFlow[this.sink];
    }

    private void globalDistanceUpdate() {
        for (int v = 0; v < this.n; ++v) {
            this.distance[v] = this.n;
        }
        this.distance[this.sink] = 0;
        for (int l = 0; l < this.maxDistance; ++l) {
            this.layers[l].active.clear();
            this.layers[l].inactive.clear();
        }
        this.maxDistance = 0;
        this.maxActive = 0;
        this.minActive = this.n;
        BreadthFirstSearch.breadthFirstSearch(this.reverseGraph, new AbstractBfsVisitor(){

            @Override
            public void treeEdge(Edge e, Graph g) {
                int v = e.v();
                int w = e.w();
                ((PushRelabelMaxFlow)PushRelabelMaxFlow.this).distance[w] = PushRelabelMaxFlow.this.distance[v] + 1;
                ((PushRelabelMaxFlow)PushRelabelMaxFlow.this).current[w] = PushRelabelMaxFlow.this.g.getEdgeIterator(w);
                PushRelabelMaxFlow.this.maxDistance = Math.max(PushRelabelMaxFlow.this.distance[w], PushRelabelMaxFlow.this.maxDistance);
                if (PushRelabelMaxFlow.this.isActive(w)) {
                    PushRelabelMaxFlow.this.addToActiveList(w);
                } else {
                    PushRelabelMaxFlow.this.addToInactiveList(w);
                }
            }
        }, this.sink);
    }

    public static int maxFlow(Graph graph, int[] capacity, int src, int sink) {
        return PushRelabelMaxFlow.maxFlow(graph, Reverse.reverseGraph(graph, new SparseGraphImpl(graph.V(), true), null), capacity, src, sink);
    }

    public static int maxFlow(Graph graph, Graph reverseGraph, int[] capacity, int src, int sink) {
        assert (capacity.length == graph.E()) : "capacity array size is not equal to graph edge size";
        assert (src >= 0);
        assert (sink >= 0);
        PushRelabelMaxFlow maxFlow = new PushRelabelMaxFlow(graph, reverseGraph, capacity, src, sink);
        return maxFlow.maxPreFlow();
    }

    private static class Layer {
        IntStack active = new IntStack();
        IntArrayList inactive = new IntArrayList();

        private Layer() {
        }

        public String toString() {
            return this.active.toString() + this.inactive.toString();
        }
    }
}

