/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmSelectionModel;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DsmTableSpeedSearch<N>
extends SpeedSearchBase<DsmTableImpl<N>> {
    public DsmTableSpeedSearch(DsmTableImpl<N> component) {
        super(component);
    }

    protected int getSelectedIndex() {
        Collection selection = ((DsmTableImpl)this.getComponent()).getSelectionModel().getSelection();
        DsmSelection firstItem = (DsmSelection)ContainerUtil.getFirstItem(selection);
        if (firstItem == null || firstItem.node1.isEmpty()) {
            return -1;
        }
        return ArrayUtil.indexOf((Object[])this.getAllElements(), (Object)ContainerUtil.getFirstItem(firstItem.node1));
    }

    @NotNull
    protected Object[] getAllElements() {
        DsmTableImpl table = (DsmTableImpl)this.getComponent();
        List rows = table.myCache.myRows;
        LinkedHashSet nodes = ContainerUtil.newLinkedHashSet();
        for (DsmTreeStructure.TreeNode row : rows) {
            this.addNodeAndParents(row, nodes);
        }
        Object[] objectArray = nodes.toArray();
        if (objectArray == null) {
            DsmTableSpeedSearch.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    private void addNodeAndParents(DsmTreeStructure.TreeNode<N> node, Set<DsmTreeStructure.TreeNode<N>> nodes) {
        DsmTreeStructure.TreeNode<N> parent = node.getParent();
        if (parent == null) {
            return;
        }
        this.addNodeAndParents(parent, nodes);
        nodes.add(node);
    }

    @Nullable
    protected String getElementText(Object element) {
        return ((DsmTreeStructure.TreeNode)element).getShortName();
    }

    protected void selectElement(Object element, String selectedText) {
        DsmTreeStructure.TreeNode selected = (DsmTreeStructure.TreeNode)element;
        Map indices = ((DsmTableImpl)this.getComponent()).myCache.rowIndices;
        DsmTreeStructure.TreeNode startNode = selected;
        Integer startIndex = indices.get(selected);
        while (!startNode.isLeaf() && startIndex == null) {
            DsmTreeStructure.TreeNode<N>[] children = startNode.getChildren();
            startNode = children[0];
            startIndex = indices.get(startNode);
        }
        DsmTreeStructure.TreeNode endNode = selected;
        Integer endIndex = indices.get(selected);
        while (!endNode.isLeaf() && endIndex == null) {
            DsmTreeStructure.TreeNode<N>[] children = endNode.getChildren();
            endNode = children[children.length - 1];
            endIndex = indices.get(endNode);
        }
        assert (startIndex != null && endIndex != null);
        DsmSelectionModel selectionModel = ((DsmTableImpl)this.getComponent()).getSelectionModel();
        selectionModel.clear();
        selectionModel.addSelection(DsmSelection.createRowSelection(Collections.singleton(selected), startIndex, endIndex));
        ((DsmTableImpl)this.getComponent()).scrollRowToVisible(selected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dsm/ui/DsmTableSpeedSearch", "getAllElements"));
    }
}

