/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.xml.persistence.mapping;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNameHelper;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericValue;
import org.jetbrains.annotations.Nullable;

public class EntityNameConverter
extends Converter<String> {
    public String fromString(String s, ConvertContext context) {
        if (StringUtil.isEmpty((String)s)) {
            String entityName;
            PersistentEntity entity = (PersistentEntity)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), PersistentEntity.class, (boolean)true);
            if (entity != null && (entityName = this.getEntityName(entity)) != null) {
                return entityName;
            }
            return "unknown";
        }
        return s;
    }

    @Nullable
    protected String getEntityName(PersistentEntity entity) {
        GenericValue classValue = entity.getClazz();
        PsiClass aClass = (PsiClass)classValue.getValue();
        if (aClass != null) {
            return aClass.getName();
        }
        String aClassString = classValue.getStringValue();
        if (aClassString != null) {
            return PsiNameHelper.getShortClassName((String)aClassString);
        }
        return null;
    }

    public String toString(String t, ConvertContext context) {
        return t;
    }
}

