/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.sdk;

import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.gwt.GwtBundle;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.impl.sdk.GwtSdkPathUtil;

public class GwtSdkUtil {
    @NonNls
    public static final String GWT_CLASS_NAME = "com.google.gwt.core.client.GWT";
    @NonNls
    public static final String EMUL_ROOT = "com/google/gwt/emul/";
    @NonNls
    public static final String GWT_DOWNLOAD_URL = "https://code.google.com/webtoolkit/download.html";
    private static final FacetConfigurationQuickFix DOWNLOAD_GWT_FIX = new FacetConfigurationQuickFix(GwtBundle.message("fix.download.gwt", new Object[0])){

        public void run(JComponent place) {
            BrowserUtil.browse((String)GwtSdkUtil.GWT_DOWNLOAD_URL);
        }
    };
    @NonNls
    public static final String GWT_15_COMPILER_MAIN_CLASS = "com.google.gwt.dev.GWTCompiler";
    @NonNls
    public static final String GWT_16_COMPILER_MAIN_CLASS = "com.google.gwt.dev.Compiler";
    public static final String GWT_15_DEV_MODE_CLASS = "com.google.gwt.dev.GWTShell";
    public static final String GWT_20_DEV_MODE_CLASS = "com.google.gwt.dev.DevMode";

    private GwtSdkUtil() {
    }

    private static ValidationResult checkClass(@NonNls String className, @Nullable String oldClassName, String gwtPath, String jarPath) {
        VirtualFile jarFile = JarFileSystem.getInstance().refreshAndFindFileByPath(FileUtil.toSystemIndependentName((String)jarPath) + "!/");
        if (jarFile == null) {
            return GwtSdkUtil.invalidGwtInstallation(gwtPath, GwtBundle.message("error.file.not.found.message", jarPath));
        }
        VirtualFile[] files = new VirtualFile[]{jarFile};
        if (!(LibraryUtil.isClassAvailableInLibrary((VirtualFile[])files, (String)className) || oldClassName != null && LibraryUtil.isClassAvailableInLibrary((VirtualFile[])files, (String)oldClassName))) {
            return GwtSdkUtil.invalidGwtInstallation(gwtPath, GwtBundle.message("error.class.not.found.in.jar", className, jarPath));
        }
        return ValidationResult.OK;
    }

    private static ValidationResult invalidGwtInstallation(String gwtPath, String errorMessage) {
        return new ValidationResult(GwtBundle.message("error.invalid.gwt.installation.message", gwtPath, errorMessage), DOWNLOAD_GWT_FIX);
    }

    public static ValidationResult checkGwtSdkPath(String gwtPath) {
        if (gwtPath.contains("!")) {
            return new ValidationResult(GwtBundle.message("error.message.path.to.gwt.sdk.must.not.contain.character", new Object[0]));
        }
        String devJarPath = GwtSdkPathUtil.getDevJarPath((String)gwtPath);
        ValidationResult result = GwtSdkUtil.checkClass(GWT_16_COMPILER_MAIN_CLASS, GWT_15_COMPILER_MAIN_CLASS, gwtPath, devJarPath);
        if (result.isOk()) {
            result = GwtSdkUtil.checkClass(GWT_20_DEV_MODE_CLASS, GWT_15_DEV_MODE_CLASS, gwtPath, devJarPath);
        }
        if (result.isOk()) {
            result = GwtSdkUtil.checkClass(GWT_CLASS_NAME, null, gwtPath, GwtSdkPathUtil.getUserJarPath((String)gwtPath));
        }
        return result;
    }

    public static Library findOrCreateGwtUserLibrary(@NotNull LibrariesContainer container, @NotNull VirtualFile userJar) {
        Library library;
        if (container == null) {
            GwtSdkUtil.$$$reportNull$$$0(0);
        }
        if (userJar == null) {
            GwtSdkUtil.$$$reportNull$$$0(1);
        }
        if ((library = GwtSdkUtil.findLibrary(container, userJar)) != null) {
            return library;
        }
        return container.createLibrary("gwt-user", LibrariesContainer.LibraryLevel.PROJECT, new VirtualFile[]{userJar}, new VirtualFile[]{userJar});
    }

    @Nullable
    private static Library findLibrary(LibrariesContainer container, VirtualFile userJar) {
        for (Library library : container.getAllLibraries()) {
            VirtualFile[] files;
            for (VirtualFile file : files = library.getFiles(OrderRootType.CLASSES)) {
                if (!userJar.equals(file)) continue;
                return library;
            }
        }
        return null;
    }

    public static String getJreEmulationClassPath(String className) {
        return EMUL_ROOT + className.replace('.', '/') + "." + StdFileTypes.JAVA.getDefaultExtension();
    }

    @Nullable
    public static VirtualFile getUserJar(String homePath) {
        return GwtSdkUtil.findJarFile(GwtSdkPathUtil.getUserJarPath((String)homePath));
    }

    @Nullable
    public static VirtualFile findJarFile(String jarPath) {
        return JarFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)jarPath) + "!/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "container";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "userJar";
                break;
            }
        }
        objectArray[1] = "com/intellij/gwt/sdk/GwtSdkUtil";
        objectArray[2] = "findOrCreateGwtUserLibrary";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

