/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaRunConfigurationExtensionManager;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.facet.FacetManager;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.facet.GwtFacetType;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.run.GwtCommandLineState;
import com.intellij.gwt.run.GwtDevModeServer;
import com.intellij.gwt.run.GwtDevModeServerProvider;
import com.intellij.gwt.run.GwtRunConfigurationEditor;
import com.intellij.gwt.sdk.GwtSdk;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtRunConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule, Element>
implements CommonProgramRunConfigurationParameters {
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    @NonNls
    private static final String MODULE = "module";
    @NonNls
    private static final String PAGE = "page";
    private GwtRunConfigurationState myState;

    public GwtRunConfiguration(String name, Project project, @NotNull ConfigurationFactory configurationFactory) {
        if (configurationFactory == null) {
            GwtRunConfiguration.$$$reportNull$$$0(0);
        }
        super(name, (RunConfigurationModule)new JavaRunConfigurationModule(project, true), configurationFactory);
        this.myState = new GwtRunConfigurationState();
    }

    public GwtRunConfiguration(Project project, @NotNull ConfigurationFactory configurationFactory) {
        if (configurationFactory == null) {
            GwtRunConfiguration.$$$reportNull$$$0(1);
        }
        this(GwtBundle.message("default.gwt.run.configuration.name", new Object[0]), project, configurationFactory);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        group.addEditor(ExecutionBundle.message((String)"run.configuration.configuration.tab.title", (Object[])new Object[0]), (SettingsEditor)new GwtRunConfigurationEditor(this.getProject()));
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        JavaRunConfigurationExtensionManager.getInstance().appendEditors((RunConfigurationBase)this, group);
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            GwtRunConfiguration.$$$reportNull$$$0(2);
        }
        return settingsEditorGroup;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Collection<GwtModule> gwtModules;
        Sdk jdk;
        Module module;
        if (executor == null) {
            GwtRunConfiguration.$$$reportNull$$$0(3);
        }
        if (env == null) {
            GwtRunConfiguration.$$$reportNull$$$0(4);
        }
        if ((module = this.getModule()) == null) {
            throw CantRunException.noModuleConfigured((String)((JavaRunConfigurationModule)this.getConfigurationModule()).getModuleName());
        }
        GwtFacet facet = (GwtFacet)FacetManager.getInstance((Module)module).getFacetByType(GwtFacetType.ID);
        if (facet == null) {
            SmartList facets = new SmartList();
            OrderEnumerator.orderEntries((Module)module).forEachModule(arg_0 -> GwtRunConfiguration.lambda$getState$0((List)facets, arg_0));
            if (facets.isEmpty()) {
                throw new ExecutionException(GwtBundle.message("error.text.gwt.facet.not.configured.in.module.0", module.getName()));
            }
            facet = (GwtFacet)((Object)facets.get(0));
        }
        if ((jdk = ModuleRootManager.getInstance((Module)module).getSdk()) == null) {
            throw CantRunException.noJdkForModule((Module)module);
        }
        if (facet.getSdkVersion().isModulesToLoadSpecifiedInDevMode() && (gwtModules = GwtModulesManager.getInstance(module.getProject()).getCompilableGwtModules(facet.getModule(), false)).isEmpty()) {
            throw new ExecutionException(GwtBundle.message("error.text.no.gwt.modules.in.module.0", facet.getModule().getName()));
        }
        GwtSdk sdk = ((GwtFacetConfiguration)facet.getConfiguration()).getSdk();
        if (!sdk.isValid()) {
            throw new ExecutionException(GwtBundle.message("error.text.gwt.sdk.is.not.specified.correctly", module.getName()));
        }
        GwtDevModeServer selectedServer = null;
        block0: for (GwtDevModeServerProvider provider : (GwtDevModeServerProvider[])GwtDevModeServerProvider.EP_NAME.getExtensions()) {
            for (GwtDevModeServer gwtDevModeServer : provider.getServers()) {
                if (!gwtDevModeServer.getId().equals(this.myState.SERVER_ID)) continue;
                selectedServer = gwtDevModeServer;
                continue block0;
            }
        }
        if (selectedServer == null) {
            throw new ExecutionException("Unknown GWT Dev Mode server: " + this.myState.SERVER_ID);
        }
        return new GwtCommandLineState(module, facet, env, this, selectedServer, executor);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        ((JavaRunConfigurationModule)this.getConfigurationModule()).checkForWarning();
    }

    public GwtRunConfigurationState getGwtState() {
        return this.myState;
    }

    public Collection<Module> getValidModules() {
        return this.getAllModules();
    }

    @Nullable
    public Module getModule() {
        return ((JavaRunConfigurationModule)this.getConfigurationModule()).getModule();
    }

    public boolean isModuleDirMacroSupported() {
        return true;
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        String page;
        if (element == null) {
            GwtRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myState = new GwtRunConfigurationState();
        XmlSerializer.deserializeInto((Object)this.myState, (Element)element);
        this.readModule(element);
        Element module = element.getChild(MODULE);
        if (module != null && !StringUtil.isEmpty((String)(page = module.getAttributeValue(PAGE)))) {
            this.myState.RUN_PAGE = page;
        }
        super.readExternal(element);
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GwtRunConfiguration.$$$reportNull$$$0(6);
        }
        XmlSerializer.serializeInto((Object)this.myState, (Element)element, (SerializationFilter)SERIALIZATION_FILTERS);
        super.writeExternal(element);
    }

    public void setPage(String runPage) {
        if (runPage == null) {
            runPage = "";
        }
        this.myState.RUN_PAGE = runPage;
    }

    public String getPage() {
        return this.myState.RUN_PAGE;
    }

    public void setProgramParameters(@Nullable String value) {
        this.myState.SHELL_PARAMETERS = value;
    }

    @Nullable
    public String getProgramParameters() {
        return this.myState.SHELL_PARAMETERS;
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.myState.WORKING_DIRECTORY = value;
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.myState.WORKING_DIRECTORY;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            GwtRunConfiguration.$$$reportNull$$$0(7);
        }
        this.myState.ENVIRONMENT_VARIABLES = envs;
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myState.ENVIRONMENT_VARIABLES;
        if (map == null) {
            GwtRunConfiguration.$$$reportNull$$$0(8);
        }
        return map;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myState.PASS_PARENT_ENVS = passParentEnvs;
    }

    public boolean isPassParentEnvs() {
        return this.myState.PASS_PARENT_ENVS;
    }

    public void onNewConfigurationCreated() {
        List facets = ProjectFacetManager.getInstance((Project)this.getProject()).getFacets(GwtFacetType.ID);
        for (GwtFacet facet : facets) {
            if (!facet.getSdkVersion().isSuperDevModeUsedByDefault()) continue;
            this.getGwtState().USE_SUPER_DEV_MODE = true;
            break;
        }
    }

    private static /* synthetic */ boolean lambda$getState$0(List facets, Module m) {
        GwtFacet f = (GwtFacet)FacetManager.getInstance((Module)m).getFacetByType(GwtFacetType.ID);
        ContainerUtil.addIfNotNull((Collection)facets, (Object)((Object)f));
        return f == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFactory";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/run/GwtRunConfiguration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/run/GwtRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class GwtRunConfigurationState {
        @NonNls
        public String VM_PARAMETERS = "-Xmx512m";
        public String SHELL_PARAMETERS = "";
        public String RUN_PAGE = "";
        public String CUSTOM_WEB_XML;
        public String GWT_MODULE;
        public String SERVER_ID = "default";
        public boolean OPEN_IN_BROWSER = true;
        public boolean START_JAVASCRIPT_DEBUGGER = false;
        public String BROWSER;
        public boolean UPDATE_RESOURCES_ON_FRAME_DEACTIVATION;
        public boolean USE_SUPER_DEV_MODE = false;
        public boolean PASS_PARENT_ENVS = true;
        public String ALTERNATIVE_JRE_PATH;
        public String WORKING_DIRECTORY;
        @Tag(value="envs")
        @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="env", keyAttributeName="name")
        public Map<String, String> ENVIRONMENT_VARIABLES = new HashMap<String, String>();
        @XCollection(propertyElementName="gwt-modules", elementName="gwt-module", valueAttributeName="name")
        public List<String> GWT_MODULES = new ArrayList<String>();

        @Transient
        @Nullable
        public List<String> getGwtModules() {
            if (!this.GWT_MODULES.isEmpty()) {
                return this.GWT_MODULES;
            }
            if (this.GWT_MODULE != null) {
                return Collections.singletonList(this.GWT_MODULE);
            }
            return null;
        }

        @Transient
        public void setGwtModules(@Nullable List<String> gwtModules) {
            this.GWT_MODULES = Collections.emptyList();
            this.GWT_MODULE = null;
            if (gwtModules != null) {
                if (gwtModules.size() == 1) {
                    this.GWT_MODULE = gwtModules.get(0);
                } else {
                    this.GWT_MODULES = Collections.unmodifiableList(new ArrayList<String>(gwtModules));
                }
            }
        }
    }
}

