/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run;

import com.intellij.execution.Location;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.run.GwtRunConfiguration;
import com.intellij.gwt.run.GwtRunConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.xml.XmlFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtConfigurationProvider
extends RuntimeConfigurationProducer {
    public GwtConfigurationProvider() {
        super(ConfigurationTypeUtil.findConfigurationType(GwtRunConfigurationType.class));
    }

    public PsiElement getSourceElement() {
        return this.restoreSourceElement();
    }

    protected RunnerAndConfigurationSettings createConfigurationByElement(Location location, ConfigurationContext context) {
        Pair<GwtModule, String> pair = GwtConfigurationProvider.findGwtModule(location);
        if (pair != null) {
            this.storeSourceElement(location.getPsiElement());
            RunManager runManager = RunManager.getInstance((Project)location.getProject());
            GwtModule gwtModule = (GwtModule)pair.getFirst();
            RunnerAndConfigurationSettings settings = runManager.createConfiguration(gwtModule.getShortName(), this.getConfigurationFactory());
            GwtRunConfiguration gwtConfiguration = (GwtRunConfiguration)settings.getConfiguration();
            gwtConfiguration.setModule(gwtModule.getModule());
            gwtConfiguration.setPage((String)pair.getSecond());
            return settings;
        }
        return null;
    }

    public int compareTo(Object o) {
        return -1;
    }

    protected RunnerAndConfigurationSettings findExistingByElement(Location location, @NotNull List<RunnerAndConfigurationSettings> existingConfigurations, ConfigurationContext context) {
        Pair<GwtModule, String> pair;
        if (existingConfigurations == null) {
            GwtConfigurationProvider.$$$reportNull$$$0(0);
        }
        if ((pair = GwtConfigurationProvider.findGwtModule(location)) != null) {
            for (RunnerAndConfigurationSettings existingConfiguration : existingConfigurations) {
                RunConfiguration configuration = existingConfiguration.getConfiguration();
                if (!(configuration instanceof GwtRunConfiguration)) continue;
                GwtRunConfiguration gwtRunConfiguration = (GwtRunConfiguration)configuration;
                String pagePath1 = gwtRunConfiguration.getPage();
                Module module1 = gwtRunConfiguration.getModule();
                GwtModule gwtModule = (GwtModule)pair.getFirst();
                String pagePath2 = (String)pair.getSecond();
                Module module2 = gwtModule.getModule();
                if (!pagePath2.equals(pagePath1) || !Comparing.equal((Object)module1, (Object)module2)) continue;
                return existingConfiguration;
            }
        }
        return null;
    }

    @Nullable
    private static Pair<GwtModule, String> findGwtModule(Location<?> location) {
        PsiClass psiClass;
        GwtModule module;
        PsiClass[] classes;
        PsiFile psiFile = location.getPsiElement().getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null || !GwtFacet.isInModuleWithGwtFacet(location.getProject(), file)) {
            return null;
        }
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(location.getProject());
        GwtModule gwtModule = gwtModulesManager.getGwtModuleByXmlFile(psiFile);
        if (gwtModule != null) {
            return GwtConfigurationProvider.getModuleWithFile(gwtModulesManager, gwtModule);
        }
        if (psiFile instanceof PsiJavaFile && (classes = ((PsiJavaFile)psiFile).getClasses()).length == 1 && (module = gwtModulesManager.findGwtModuleByEntryPoint(psiClass = classes[0])) != null) {
            return GwtConfigurationProvider.getModuleWithFile(gwtModulesManager, module);
        }
        return null;
    }

    @Nullable
    private static Pair<GwtModule, String> getModuleWithFile(@NotNull GwtModulesManager gwtModulesManager, @NotNull GwtModule gwtModule) {
        XmlFile[] psiHtmlFiles;
        if (gwtModulesManager == null) {
            GwtConfigurationProvider.$$$reportNull$$$0(1);
        }
        if (gwtModule == null) {
            GwtConfigurationProvider.$$$reportNull$$$0(2);
        }
        for (XmlFile psiHtmlFile : psiHtmlFiles = gwtModulesManager.findHtmlFilesByModule(gwtModule)) {
            String path;
            VirtualFile htmlFile = psiHtmlFile.getVirtualFile();
            if (htmlFile == null || (path = gwtModulesManager.getOutputPath(gwtModule, htmlFile)) == null) continue;
            return Pair.create((Object)gwtModule, (Object)path);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingConfigurations";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModulesManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModule";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gwt/run/GwtConfigurationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findExistingByElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleWithFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

