/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.rpc;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.module.model.GwtServlet;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.CommonServlet;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtServletUtil {
    private GwtServletUtil() {
    }

    @NotNull
    public static String getDefaultServletPath(GwtModule module, String serviceName) {
        String string = "/" + serviceName;
        if (string == null) {
            GwtServletUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getServletPath(GwtModule gwtModule, String serviceName, PsiClass serviceImpl) {
        String path;
        PsiAnnotationMemberValue value;
        PsiAnnotation servicePath;
        PsiModifierList modifierList;
        PsiClass serviceInterface = RemoteServiceUtil.findRemoteServiceInterface(serviceImpl);
        if (serviceInterface != null && (modifierList = serviceInterface.getModifierList()) != null && (servicePath = modifierList.findAnnotation("com.google.gwt.user.client.rpc.RemoteServiceRelativePath")) != null && (value = servicePath.findAttributeValue("value")) != null && (path = (String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)value, String.class)) != null) {
            String string = path;
            if (string == null) {
                GwtServletUtil.$$$reportNull$$$0(1);
            }
            return string;
        }
        List<GwtServlet> list = gwtModule.getServlets();
        String serviceImplName = serviceImpl.getQualifiedName();
        if (serviceImplName != null) {
            for (GwtServlet servlet : list) {
                String path2;
                if (!serviceImplName.equals(servlet.getServletClass().getValue()) || (path2 = (String)servlet.getPath().getValue()) == null) continue;
                if (!path2.startsWith("/")) {
                    path2 = "/" + path2;
                }
                String string = path2;
                if (string == null) {
                    GwtServletUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
        }
        String string = GwtServletUtil.getDefaultServletPath(gwtModule, serviceName);
        if (string == null) {
            GwtServletUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static String getServletUrlPattern(GwtFacet gwtFacet, GwtModule module, String serviceName, PsiClass serviceImpl) {
        return GwtServletUtil.getServletUrlPattern(gwtFacet, module, GwtServletUtil.getServletPath(module, serviceName, serviceImpl));
    }

    public static String getServletUrlPattern(GwtFacet gwtFacet, GwtModule module, String servletPath) {
        String base = ((GwtFacetConfiguration)gwtFacet.getConfiguration()).getPackagingRelativePath(module);
        return DeploymentUtil.concatPaths((String[])new String[]{base, servletPath});
    }

    public static void registerServletForService(GwtFacet gwtFacet, GwtModule gwtModule, WebApp root, PsiClass servletImpl, String serviceName) {
        GwtServletUtil.registerServletForService(gwtModule, root, servletImpl, serviceName, GwtServletUtil.getServletUrlPattern(gwtFacet, gwtModule, serviceName, servletImpl));
    }

    public static void registerServletForService(GwtModule gwtModule, @NotNull WebApp root, PsiClass servletImpl, String serviceName, String servletUrlPattern) {
        if (root == null) {
            GwtServletUtil.$$$reportNull$$$0(4);
        }
        Servlet servlet = root.addServlet();
        servlet.getServletClass().setValue((Object)servletImpl);
        String servletName = gwtModule.getQualifiedName() + " " + serviceName;
        servlet.getServletName().setValue((Object)servletName);
        GwtServletUtil.addServletMapping(root, (CommonServlet)servlet, servletUrlPattern);
    }

    public static void addServletMapping(WebApp root, CommonServlet servlet, String servletUrlPattern) {
        ServletMapping mapping = root.addServletMapping();
        mapping.getServletName().setValue((Object)servlet);
        mapping.addUrlPattern().setValue((Object)servletUrlPattern);
    }

    @Nullable
    public static CommonServlet findServletByPath(GwtModule gwtModule, String relativePath) {
        GwtFacet facet = GwtFacet.getInstance(gwtModule);
        if (facet == null) {
            return null;
        }
        WebFacet webFacet = facet.getWebFacet();
        if (webFacet == null) {
            return null;
        }
        WebApp root = webFacet.getRoot();
        if (root == null) {
            return null;
        }
        String urlPattern = GwtServletUtil.getServletUrlPattern(facet, gwtModule, relativePath);
        for (ServletMapping mapping : root.getServletMappings()) {
            List urlPatterns = mapping.getUrlPatterns();
            for (GenericDomValue pattern : urlPatterns) {
                if (!urlPattern.equals(pattern.getStringValue())) continue;
                return (CommonServlet)mapping.getServletName().getValue();
            }
        }
        return null;
    }

    @NotNull
    public static List<String> getAllGwtServletsPaths(@NotNull GwtModule gwtModule) {
        GwtFacet facet;
        if (gwtModule == null) {
            GwtServletUtil.$$$reportNull$$$0(5);
        }
        if ((facet = GwtFacet.getInstance(gwtModule)) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GwtServletUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        WebFacet webFacet = facet.getWebFacet();
        if (webFacet == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GwtServletUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        WebApp root = webFacet.getRoot();
        if (root == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                GwtServletUtil.$$$reportNull$$$0(8);
            }
            return list;
        }
        String rootPath = ((GwtFacetConfiguration)facet.getConfiguration()).getPackagingRelativePath(gwtModule) + "/";
        ArrayList<String> paths = new ArrayList<String>();
        for (ServletMapping servletMapping : root.getServletMappings()) {
            CommonServlet servlet = (CommonServlet)servletMapping.getServletName().getValue();
            if (servlet == null || !RemoteServiceUtil.isRemoteServiceImplementation(servlet.getPsiClass())) continue;
            for (GenericDomValue pattern : servletMapping.getUrlPatterns()) {
                String value = (String)pattern.getValue();
                if (value == null || !value.startsWith(rootPath)) continue;
                paths.add(value.substring(rootPath.length()));
            }
        }
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            GwtServletUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static boolean hasServlets(@NotNull GwtFacet facet) {
        WebFacet webFacet;
        if (facet == null) {
            GwtServletUtil.$$$reportNull$$$0(10);
        }
        if ((webFacet = facet.getWebFacet()) == null) {
            return false;
        }
        WebApp root = webFacet.getRoot();
        if (root == null) {
            return false;
        }
        for (Servlet servlet : root.getServlets()) {
            if (!RemoteServiceUtil.isRemoteServiceImplementation((PsiClass)servlet.getServletClass().getValue())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Servlet findServlet(WebApp root, PsiClass servletImpl) {
        List servlets = root.getServlets();
        PsiManager psiManager = servletImpl.getManager();
        for (Servlet servlet : servlets) {
            if (!psiManager.areElementsEquivalent((PsiElement)servletImpl, (PsiElement)servlet.getServletClass().getValue())) continue;
            return servlet;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/rpc/GwtServletUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModule";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultServletPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServletPath";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/rpc/GwtServletUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllGwtServletsPaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerServletForService";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllGwtServletsPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasServlets";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

