/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.rpc;

import com.intellij.gwt.rpc.GwtSearcherBase;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.Processor;

public class GwtOverridingServiceMethodsSearcher
extends GwtSearcherBase<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    @Override
    protected PsiFile getContainingFile(OverridingMethodsSearch.SearchParameters parameters) {
        return parameters.getMethod().getContainingFile();
    }

    @Override
    public boolean doExecute(OverridingMethodsSearch.SearchParameters queryParameters, Processor<? super PsiMethod> consumer) {
        PsiMethod syncMethod;
        PsiMethod method = queryParameters.getMethod();
        PsiClass async = method.getContainingClass();
        PsiClass sync = RemoteServiceUtil.findSynchronousInterface(async);
        if (sync != null && (syncMethod = RemoteServiceUtil.findMethodInSync(method, sync)) != null) {
            if (!consumer.process((Object)syncMethod)) {
                return false;
            }
            if (!OverridingMethodsSearch.search((PsiMethod)syncMethod, (SearchScope)queryParameters.getScope(), (boolean)queryParameters.isCheckDeep()).forEach(consumer)) {
                return false;
            }
        }
        return true;
    }
}

