/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.rpc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtGenericsUtil {
    @NonNls
    public static final String TYPE_ARGS_TAG = "gwt.typeArgs";

    private GwtGenericsUtil() {
    }

    public static List<PsiType> getTypeParameters(@NotNull PsiElement context, @Nullable String typeParametersString) {
        if (context == null) {
            GwtGenericsUtil.$$$reportNull$$$0(0);
        }
        if (typeParametersString == null) {
            return Collections.emptyList();
        }
        ArrayList<PsiType> types = new ArrayList<PsiType>();
        StringTokenizer tokenizer = new StringTokenizer(typeParametersString, "<>,");
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        while (tokenizer.hasMoreTokens()) {
            String type = tokenizer.nextToken();
            try {
                types.add(elementFactory.createTypeFromText(type, context));
            }
            catch (IncorrectOperationException incorrectOperationException) {}
        }
        return types;
    }

    @Nullable
    public static String getReturnTypeParametersString(PsiMethod method) {
        return GwtGenericsUtil.getTypeParametersString(method, null);
    }

    @Nullable
    public static String getTypeParametersString(PsiMethod method, @Nullable String parameterName) {
        PsiDocTag[] tags;
        PsiDocComment comment = method.getDocComment();
        if (comment == null) {
            return null;
        }
        for (PsiDocTag tag : tags = comment.findTagsByName(TYPE_ARGS_TAG)) {
            String text;
            PsiElement[] elements = tag.getDataElements();
            if (parameterName != null && elements.length >= 2 && parameterName.equals(elements[0].getText())) {
                return elements[1].getText();
            }
            if (parameterName != null || elements.length < 1 || !StringUtil.startsWithChar((CharSequence)(text = elements[0].getText().trim()), (char)'<') || !StringUtil.endsWithChar((CharSequence)text, (char)'>')) continue;
            return text;
        }
        return null;
    }

    public static void removeTypeArgsJavadocTags(PsiMethod method) throws IncorrectOperationException {
        GwtGenericsUtil.removeJavadocTags(method, TYPE_ARGS_TAG);
    }

    public static void removeJavadocTags(PsiMethod method, String tagName) throws IncorrectOperationException {
        PsiDocComment comment = method.getDocComment();
        if (comment != null) {
            PsiDocTag[] tags;
            for (PsiDocTag tag : tags = comment.findTagsByName(tagName)) {
                tag.delete();
            }
            if (comment.getTags().length == 0) {
                boolean deleteComment = true;
                for (PsiElement element : comment.getDescriptionElements()) {
                    deleteComment &= CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)element.getText());
                }
                if (deleteComment) {
                    comment.delete();
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/rpc/GwtGenericsUtil", "getTypeParameters"));
    }
}

