/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.psi;

import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.make.GwtCompilerPaths;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtFileSet;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.module.model.GwtRelativePath;
import com.intellij.gwt.module.model.impl.GwtFilePatternUtil;
import com.intellij.gwt.psi.GwtLanguageLevelPusher;
import com.intellij.gwt.superSource.GwtSuperSourceClassCache;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.ArrayUtil;
import com.intellij.util.JdomKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.webcore.ModuleHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.impl.GwtSourcePath;
import org.jetbrains.jps.gwt.model.impl.GwtSourcePathsSet;

public class GwtSourcePathsRefresher
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.psi.GwtSourcePathsRefresher");
    private final Project myProject;
    private final GwtSourcePathsSet mySourcePathsSet = new GwtSourcePathsSet();
    private final MergingUpdateQueue myUpdateQueue = new MergingUpdateQueue("GwtSourcePathRefresherUpdateQueue", 1000, true, null, (Disposable)this);

    public static GwtSourcePathsRefresher getInstance(Project project) {
        return (GwtSourcePathsRefresher)ServiceManager.getService((Project)project, GwtSourcePathsRefresher.class);
    }

    public GwtSourcePathsRefresher(Project project) {
        File gwtSourcePathsFile;
        this.myUpdateQueue.setPassThrough(false);
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
        if (!ApplicationManager.getApplication().isUnitTestMode() && (gwtSourcePathsFile = GwtCompilerPaths.getGwtSourcePaths(project)).exists()) {
            try {
                Element element = JDOMUtil.load((File)gwtSourcePathsFile);
                PathMacroManager.getInstance((ComponentManager)this.myProject).expandPaths(element);
                XmlSerializer.deserializeInto((Object)this.mySourcePathsSet, (Element)element);
            }
            catch (IOException | JDOMException e) {
                LOG.error("Unable to load file " + gwtSourcePathsFile.getAbsolutePath(), e);
            }
        }
        this.init();
    }

    public MergingUpdateQueue getUpdateQueue() {
        return this.myUpdateQueue;
    }

    public void dispose() {
        this.myUpdateQueue.cancelAllUpdates();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            File gwtSourcePathsFile = GwtCompilerPaths.getGwtSourcePaths(this.myProject);
            Element element = XmlSerializer.serialize((Object)this.mySourcePathsSet);
            try {
                if (!gwtSourcePathsFile.exists()) {
                    if (this.mySourcePathsSet.mySourcePaths.isEmpty()) {
                        return;
                    }
                    FileUtil.createParentDirs((File)gwtSourcePathsFile);
                    gwtSourcePathsFile.createNewFile();
                }
                PathMacroManager.getInstance((ComponentManager)this.myProject).collapsePathsRecursively(element);
                JdomKt.write((Parent)element, (Path)gwtSourcePathsFile.toPath());
            }
            catch (IOException e) {
                LOG.error("Unable to save file " + gwtSourcePathsFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private void init() {
        MessageBusConnection busConnection = this.myProject.getMessageBus().connect();
        busConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                GwtSourcePathsRefresher.this.processAfterVfsChanges(events);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/gwt/psi/GwtSourcePathsRefresher$1", "after"));
            }
        });
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeListener());
    }

    public void enqueueRefreshSourcePathsTask(final boolean forcePush) {
        this.invalidateSuperSourceCache();
        this.myUpdateQueue.queue(new Update(this){

            public void run() {
                if (GwtSourcePathsRefresher.this.myProject.isDisposed()) {
                    return;
                }
                DumbService dumbService = DumbService.getInstance((Project)GwtSourcePathsRefresher.this.myProject);
                dumbService.runWhenSmart(() -> {
                    Set sourcePaths = GwtSourcePathsRefresher.this.getPaths(GwtModule::getSourceRoots);
                    Set superSourcePaths = GwtSourcePathsRefresher.this.getPaths(GwtModule::getSuperSourceRoots);
                    boolean push = false;
                    if (!sourcePaths.equals(((GwtSourcePathsRefresher)GwtSourcePathsRefresher.this).mySourcePathsSet.mySourcePaths)) {
                        push = true;
                        ((GwtSourcePathsRefresher)GwtSourcePathsRefresher.this).mySourcePathsSet.mySourcePaths.clear();
                        ((GwtSourcePathsRefresher)GwtSourcePathsRefresher.this).mySourcePathsSet.mySourcePaths.addAll(sourcePaths);
                    }
                    if (!superSourcePaths.equals(((GwtSourcePathsRefresher)GwtSourcePathsRefresher.this).mySourcePathsSet.mySuperSourcePaths)) {
                        push = true;
                        ((GwtSourcePathsRefresher)GwtSourcePathsRefresher.this).mySourcePathsSet.mySuperSourcePaths.clear();
                        ((GwtSourcePathsRefresher)GwtSourcePathsRefresher.this).mySourcePathsSet.mySuperSourcePaths.addAll(superSourcePaths);
                    }
                    if (push || forcePush) {
                        GwtLanguageLevelPusher.pushGwtLanguageLevel(GwtSourcePathsRefresher.this.myProject);
                    }
                });
            }
        });
    }

    private void invalidateSuperSourceCache() {
        GwtSuperSourceClassCache.getInstance(this.myProject).invalidateSuperSourceCache();
    }

    @NotNull
    private Set<GwtSourcePath> getPaths(Function<GwtModule, Map<VirtualFile, GwtRelativePath>> getPaths) {
        GwtModulesManager gwtModulesManager = GwtModulesManager.getInstance(this.myProject);
        HashSet sourcePaths = ContainerUtil.newHashSet();
        for (Module module : ModuleHelper.getModules((Project)this.myProject)) {
            GwtFacet gwtFacet = GwtFacet.getInstance(module);
            if (gwtFacet == null) continue;
            List<GwtModule> gwtModules = gwtModulesManager.getGwtModules(module, true);
            for (GwtModule gwtModule : gwtModules) {
                Map<VirtualFile, GwtRelativePath> sourceRoots = getPaths.apply(gwtModule);
                for (Map.Entry<VirtualFile, GwtRelativePath> entry : sourceRoots.entrySet()) {
                    GwtRelativePath relativePath = entry.getValue();
                    if (relativePath == null) continue;
                    sourcePaths.add(new GwtSourcePath(entry.getKey().getPath(), GwtSourcePathsRefresher.getBoolean((Boolean)relativePath.isCaseSensitive().getValue()), GwtSourcePathsRefresher.getBoolean(relativePath.isDefaultExcludes()), GwtSourcePathsRefresher.mergePatterns((String)relativePath.getIncludesAttribute().getValue(), relativePath.getIncludes()), GwtSourcePathsRefresher.mergePatterns((String)relativePath.getExcludesAttribute().getValue(), relativePath.getExcludes())));
                }
            }
        }
        HashSet hashSet = sourcePaths;
        if (hashSet == null) {
            GwtSourcePathsRefresher.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    public boolean isSourceFile(VirtualFile file) {
        if (ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInTestSourceContent(file)) {
            return false;
        }
        return this.isInPaths(file, this.mySourcePathsSet.mySourcePaths);
    }

    public boolean isSuperSourceFile(VirtualFile file) {
        return this.isInPaths(file, this.mySourcePathsSet.mySuperSourcePaths);
    }

    public Set<GwtSourcePath> getSuperSourcePaths(List<GwtModule> gwtModules) {
        if (gwtModules.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList gwtModulePaths = ContainerUtil.newArrayListWithCapacity((int)gwtModules.size());
        for (GwtModule gwtModule : gwtModules) {
            gwtModulePaths.add(gwtModule.getModuleDirectory().getPath());
        }
        HashSet superSourcePaths = ContainerUtil.newHashSet();
        block1: for (GwtSourcePath gwtSourcePath : this.mySourcePathsSet.mySuperSourcePaths) {
            for (String modulePath : gwtModulePaths) {
                if (!FileUtil.isAncestor((String)modulePath, (String)gwtSourcePath.getFullPath(), (boolean)false)) continue;
                superSourcePaths.add(gwtSourcePath);
                continue block1;
            }
        }
        return superSourcePaths;
    }

    private boolean isInPaths(VirtualFile file, Set<GwtSourcePath> paths) {
        for (GwtSourcePath sourcePath : paths) {
            if (!FileUtil.isAncestor((String)sourcePath.getFullPath(), (String)file.getPath(), (boolean)false) || !this.isIncluded(file.getPath(), sourcePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluded(String filePath, GwtSourcePath sourcePath) {
        String path = FileUtil.getRelativePath((String)sourcePath.getFullPath(), (String)filePath, (char)'/');
        if (path == null) {
            return false;
        }
        if (sourcePath.defaultExcludes() && GwtFilePatternUtil.isExcludedByDefault(path, sourcePath.caseSensitive())) {
            return false;
        }
        return !sourcePath.excludes(path) && sourcePath.includes(path);
    }

    private void processAfterVfsChanges(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            GwtSourcePathsRefresher.$$$reportNull$$$0(1);
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null) continue;
            if (file.isDirectory()) {
                if (!(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileCopyEvent) && !(vFileEvent instanceof VFileDeleteEvent)) continue;
                this.enqueueRefreshSourcePathsTask(false);
                return;
            }
            this.invalidateSuperSourceCache();
            if (!file.getName().endsWith(".gwt.xml") || !(vFileEvent instanceof VFileCreateEvent) && !(vFileEvent instanceof VFileMoveEvent) && !(vFileEvent instanceof VFileDeleteEvent) && !(vFileEvent instanceof VFileContentChangeEvent)) continue;
            this.enqueueRefreshSourcePathsTask(false);
            return;
        }
    }

    private static boolean getBoolean(@Nullable Boolean value) {
        return value == null || value != false;
    }

    @NotNull
    private static List<String> mergePatterns(@Nullable String patterns, @Nullable List<GwtFileSet> patternsList) {
        if (patterns == null && ContainerUtil.isEmpty(patternsList)) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                GwtSourcePathsRefresher.$$$reportNull$$$0(2);
            }
            return list;
        }
        String[] patternsArray = patterns == null ? ArrayUtil.EMPTY_STRING_ARRAY : patterns.split("(\\s|,)");
        patternsList = ContainerUtil.notNullize(patternsList);
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)(patternsArray.length + patternsList.size()));
        Collections.addAll(result, patternsArray);
        for (GwtFileSet fileSet : patternsList) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)fileSet.getName().getValue());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            GwtSourcePathsRefresher.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/psi/GwtSourcePathsRefresher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPaths";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/psi/GwtSourcePathsRefresher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mergePatterns";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processAfterVfsChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeListener() {
        }

        private void processEvent(@NotNull PsiTreeChangeEvent event) {
            PsiFile file;
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(0);
            }
            if ((file = event.getFile()) == null || !file.getName().endsWith(".gwt.xml")) {
                return;
            }
            GwtSourcePathsRefresher.this.enqueueRefreshSourcePathsTask(false);
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(1);
            }
            this.processEvent(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(2);
            }
            this.processEvent(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(3);
            }
            this.processEvent(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(4);
            }
            this.processEvent(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeListener.$$$reportNull$$$0(5);
            }
            this.processEvent(event);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/gwt/psi/GwtSourcePathsRefresher$MyPsiTreeChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

