/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.maven;

import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.jps.model.java.JavaSourceRootType;

public class GwtLtgtModuleImporter
extends MavenImporter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.maven.GwtLtgtModuleImporter");
    private static final String GWT_LIB = "gwt-lib";
    private static final String GWT_APP = "gwt-app";
    private static final List<String> SUPPORTED_PACKAGINGS = Arrays.asList("gwt-lib", "gwt-app");
    private static final String DEFAULT_MODULE_TEMPLATE = "src/main/module.gwt.xml";
    private static final String MAIN_MODULE_META_INF_PATH = "META-INF/gwt/mainModule";
    private static final String CONFIG_SKIP_MODULE = "skipModule";
    private static final String CONFIG_MODULE_TEMPLATE = "moduleTemplate";
    private static final String CONFIG_MODULE_NAME = "moduleName";
    private static final String CONFIG_MODULE_SHORT_NAME = "moduleShortName";
    private static final String CONFIG_GENERATE_INHERITS_FROM_DEPENDENCIES = "generateInheritsFromDependencies";
    private static final String CONFIG_DEPENDENCY_ARTIFACTS = "dependencyArtifacts";

    public GwtLtgtModuleImporter() {
        super("net.ltgt.gwt.maven", "gwt-maven-plugin");
    }

    public boolean isApplicable(MavenProject mavenProject) {
        MavenPlugin plugin = mavenProject.findPlugin(this.myPluginGroupID, this.myPluginArtifactID);
        return plugin != null && plugin.isExtensions() && SUPPORTED_PACKAGINGS.contains(mavenProject.getPackaging());
    }

    public void getSupportedDependencyTypes(Collection<String> result, SupportedRequestType type) {
        result.addAll(SUPPORTED_PACKAGINGS);
    }

    public void getSupportedPackagings(Collection<String> result) {
        result.addAll(SUPPORTED_PACKAGINGS);
    }

    public void preProcess(Module module, MavenProject mavenProject, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
    }

    public void process(IdeModifiableModelsProvider modifiableModelsProvider, Module module, MavenRootModelAdapter rootModel, MavenProjectsTree projectsTree, MavenProject mavenProject, MavenProjectChanges changes, Map<MavenProject, String> mavenProjectToModuleName, List<MavenProjectsProcessorTask> postTasks) {
        Project project;
        PsiFile moduleTemplatePsiFile;
        VirtualFile moduleTemplateFile = this.getModuleTemplate(mavenProject);
        if (moduleTemplateFile != null && (moduleTemplatePsiFile = PsiManager.getInstance((Project)(project = module.getProject())).findFile(moduleTemplateFile)) instanceof XmlFile) {
            this.generateModuleFile0(module, project, rootModel, mavenProject, (XmlFile)moduleTemplatePsiFile);
        }
    }

    public boolean isModuleTemplate(@NotNull MavenProject mavenProject, @NotNull VirtualFile virtualFile) {
        if (mavenProject == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(1);
        }
        return virtualFile.equals(this.getModuleTemplate(mavenProject));
    }

    @Nullable
    private VirtualFile getModuleTemplate(@NotNull MavenProject mavenProject) {
        String moduleTemplatePath;
        if (mavenProject == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(moduleTemplatePath = this.findConfigValue(mavenProject, CONFIG_MODULE_TEMPLATE)))) {
            moduleTemplatePath = DEFAULT_MODULE_TEMPLATE;
        }
        if (FileUtil.isAbsolute((String)moduleTemplatePath)) {
            return VirtualFileManager.getInstance().findFileByUrl(VfsUtil.pathToUrl((String)moduleTemplatePath));
        }
        return mavenProject.getDirectoryFile().findFileByRelativePath(moduleTemplatePath);
    }

    private void generateModuleFile0(@NotNull Module module, @NotNull Project project, @NotNull MavenRootModelAdapter rootModel, @NotNull MavenProject mavenProject, @NotNull XmlFile moduleTemplateXmlFile) {
        VirtualFile moduleDir;
        if (module == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(3);
        }
        if (project == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(4);
        }
        if (rootModel == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(5);
        }
        if (mavenProject == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(6);
        }
        if (moduleTemplateXmlFile == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(7);
        }
        if (this.skipModule(mavenProject)) {
            return;
        }
        String moduleName = this.getModuleName(mavenProject);
        if (StringUtil.isEmpty((String)moduleName)) {
            return;
        }
        String moduleDirRelativePath = StringUtil.getPackageName((String)moduleName).replace('.', '/');
        List mavenProjectSources = mavenProject.getSources();
        if (mavenProjectSources.isEmpty()) {
            return;
        }
        String outputDirPath = mavenProject.getGeneratedSourcesDirectory(false) + "/gwt-maven-plugin/";
        try {
            moduleDir = VfsUtil.createDirectories((String)(outputDirPath + moduleDirRelativePath));
        }
        catch (IOException e) {
            LOG.error("Failed to create directory for imported GWT module file", (Throwable)e);
            return;
        }
        PsiDirectory modulePsiDir = PsiManager.getInstance((Project)project).findDirectory(moduleDir);
        if (modulePsiDir == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            String moduleShortName;
            XmlFile moduleXmlFile;
            if (rootModel == null) {
                GwtLtgtModuleImporter.$$$reportNull$$$0(13);
            }
            if (moduleTemplateXmlFile == null) {
                GwtLtgtModuleImporter.$$$reportNull$$$0(14);
            }
            if (project == null) {
                GwtLtgtModuleImporter.$$$reportNull$$$0(15);
            }
            if (mavenProject == null) {
                GwtLtgtModuleImporter.$$$reportNull$$$0(16);
            }
            if (module == null) {
                GwtLtgtModuleImporter.$$$reportNull$$$0(17);
            }
            rootModel.addGeneratedJavaSourceFolder(outputDirPath, JavaSourceRootType.SOURCE);
            String moduleFileName = StringUtil.getShortName((String)moduleName) + ".gwt.xml";
            PsiFile existingModulePsiFile = modulePsiDir.findFile(moduleFileName);
            if (existingModulePsiFile != null) {
                if (!(existingModulePsiFile instanceof XmlFile)) {
                    existingModulePsiFile.delete();
                    existingModulePsiFile = null;
                } else {
                    moduleXmlFile = (XmlFile)existingModulePsiFile;
                    XmlTag rootTag = moduleXmlFile.getRootTag();
                    if (moduleTemplateXmlFile.getRootTag() == null) {
                        if (rootTag != null) {
                            rootTag.delete();
                        }
                    } else {
                        PsiElement rootTagCopy = moduleTemplateXmlFile.getRootTag().copy();
                        if (rootTag == null) {
                            moduleXmlFile.add(rootTagCopy);
                        } else {
                            rootTag.replace(rootTagCopy);
                        }
                    }
                }
            }
            moduleXmlFile = (XmlFile)(existingModulePsiFile != null ? existingModulePsiFile : modulePsiDir.copyFileFrom(moduleFileName, (PsiFile)moduleTemplateXmlFile));
            GwtModule gwtModule = GwtModulesManager.getInstance(project).getGwtModuleByXmlFile((PsiFile)moduleXmlFile);
            if (gwtModule == null) {
                if (moduleXmlFile.getRootTag() == null) {
                    XmlDocument document = moduleXmlFile.getDocument();
                    if (document == null) {
                        LOG.error("Failed to get document from XML file " + moduleXmlFile);
                        return;
                    }
                    document.add((PsiElement)XmlElementFactory.getInstance((Project)project).createTagFromText((CharSequence)"<module/>"));
                } else {
                    moduleXmlFile.getRootTag().setName("module");
                }
                gwtModule = GwtModulesManager.getInstance(project).getGwtModuleByXmlFile((PsiFile)moduleXmlFile);
                LOG.assertTrue(gwtModule != null);
            }
            if (StringUtil.isNotEmpty((String)(moduleShortName = this.getModuleShortName(mavenProject)))) {
                gwtModule.getRenameTo().setStringValue(moduleShortName);
            }
            this.generateInheritsFromDependencies(module, project, mavenProject, gwtModule);
            if (gwtModule.getInheritses().isEmpty()) {
                gwtModule.addInherits().getName().setStringValue("com.google.gwt.core.Core");
            }
            if (gwtModule.getSources().isEmpty() && gwtModule.getSuperSources().isEmpty()) {
                gwtModule.addSource().getPath().setStringValue("client");
                gwtModule.addSource().getPath().setStringValue("shared");
                gwtModule.addSuperSource().getPath().setStringValue("super");
            }
        });
    }

    private void generateInheritsFromDependencies(@NotNull Module module, @NotNull Project project, @NotNull MavenProject mavenProject, @NotNull GwtModule gwtModule) {
        if (module == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(8);
        }
        if (project == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(9);
        }
        if (mavenProject == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(10);
        }
        if (gwtModule == null) {
            GwtLtgtModuleImporter.$$$reportNull$$$0(11);
        }
        if (this.generateInheritsFromDependencies(mavenProject)) {
            HashSet<MavenArtifact> dependencyArtifacts = new HashSet<MavenArtifact>();
            Element dependencyArtifactsElement = this.getConfig(mavenProject, CONFIG_DEPENDENCY_ARTIFACTS);
            if (dependencyArtifactsElement != null) {
                // empty if block
            }
            for (MavenArtifactNode artifactNode : mavenProject.getDependencyTree()) {
                dependencyArtifacts.add(artifactNode.getArtifact());
            }
            HashSet<String> libraries = new HashSet<String>();
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)project);
            for (MavenArtifact artifact : dependencyArtifacts) {
                String otherModuleName;
                MavenProject dependency;
                String scope = artifact.getScope();
                if ((StringUtil.isEmpty((String)scope) || "compile".equals(scope) || "runtime".equals(scope)) && (dependency = mavenProjectsManager.findProject(artifact)) != null && this.isApplicable(dependency) && StringUtil.isNotEmpty((String)(otherModuleName = this.getModuleName(dependency)))) {
                    gwtModule.addInherits().getName().setStringValue(otherModuleName);
                }
                libraries.add(artifact.getLibraryName());
            }
            OrderEnumerator.orderEntries((Module)module).compileOnly().runtimeOnly().forEachLibrary(library -> {
                if (gwtModule == null) {
                    GwtLtgtModuleImporter.$$$reportNull$$$0(12);
                }
                if (libraries.contains(library.getName())) {
                    for (VirtualFile jarRootDir : library.getFiles(OrderRootType.CLASSES)) {
                        String mainModuleName;
                        VirtualFile mainModuleMetaInfFile = jarRootDir.findFileByRelativePath(MAIN_MODULE_META_INF_PATH);
                        if (mainModuleMetaInfFile == null || !StringUtil.isNotEmpty((String)(mainModuleName = GwtLtgtModuleImporter.readMainModuleName(mainModuleMetaInfFile)))) continue;
                        gwtModule.addInherits().getName().setStringValue(mainModuleName);
                    }
                }
                return true;
            });
        }
    }

    private boolean skipModule(MavenProject mavenProject) {
        return "true".equals(this.findConfigValue(mavenProject, CONFIG_SKIP_MODULE));
    }

    private String getModuleName(MavenProject mavenProject) {
        return this.findConfigValue(mavenProject, CONFIG_MODULE_NAME);
    }

    private String getModuleShortName(MavenProject mavenProject) {
        return this.findConfigValue(mavenProject, CONFIG_MODULE_SHORT_NAME);
    }

    private boolean generateInheritsFromDependencies(MavenProject mavenProject) {
        String generateInheritsStr = this.findConfigValue(mavenProject, CONFIG_GENERATE_INHERITS_FROM_DEPENDENCIES);
        return generateInheritsStr == null || "true".equals(generateInheritsStr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readMainModuleName(VirtualFile mainModuleMetaInfFile) {
        try (InputStream in = mainModuleMetaInfFile.getInputStream();){
            String[] stringArray = StringUtil.splitByLines((String)StreamUtil.readText((InputStream)in, (String)"UTF-8"));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String mainModuleName = ((String)StringUtil.split((String)line, (String)"#").get(0)).trim();
                if (StringUtil.isNotEmpty((String)mainModuleName)) {
                    String string = mainModuleName;
                    return string;
                }
                ++n2;
            }
            return null;
        }
        catch (IOException e) {
            LOG.error("Error while reading library jar file", (Throwable)e);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTemplateXmlFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModule";
                break;
            }
        }
        objectArray2[1] = "com/intellij/gwt/maven/GwtLtgtModuleImporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isModuleTemplate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleTemplate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "generateModuleFile0";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = CONFIG_GENERATE_INHERITS_FROM_DEPENDENCIES;
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$generateInheritsFromDependencies$1";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$generateModuleFile0$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

