/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.codeInsight.GwtMethodGenerationUtil;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFixOnPsiElement;
import com.intellij.gwt.inspections.CreateCssClassLocalQuickFix;
import com.intellij.gwt.uiBinder.UiBinderUtil;
import com.intellij.gwt.uiBinder.declarations.UiStyleElement;
import com.intellij.gwt.uiBinder.references.QualifiedUiXmlReference;
import com.intellij.gwt.uiBinder.references.UiXmlVariableReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UiXmlUnresolvedReferencesInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            UiXmlUnresolvedReferencesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            UiXmlUnresolvedReferencesInspection.$$$reportNull$$$0(1);
        }
        if (!UiXmlUnresolvedReferencesInspection.shouldCheck((PsiElement)file)) {
            return null;
        }
        if (file instanceof XmlFile && UiBinderUtil.isUiXmlFile((XmlFile)file)) {
            SmartList problems = new SmartList();
            file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((List)problems, manager, isOnTheFly){
                final /* synthetic */ List val$problems;
                final /* synthetic */ InspectionManager val$manager;
                final /* synthetic */ boolean val$isOnTheFly;
                {
                    this.val$problems = list;
                    this.val$manager = inspectionManager;
                    this.val$isOnTheFly = bl;
                }

                public void visitXmlAttributeValue(XmlAttributeValue value) {
                    UiXmlUnresolvedReferencesInspection.checkReferences(value, this.val$problems, this.val$manager, this.val$isOnTheFly);
                }

                public void visitXmlTag(XmlTag tag) {
                    UiXmlUnresolvedReferencesInspection.checkReference(tag, this.val$problems, this.val$manager, this.val$isOnTheFly);
                    super.visitXmlTag(tag);
                }
            });
            return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
        }
        return null;
    }

    private static void checkReferences(XmlAttributeValue value, List<ProblemDescriptor> problems, InspectionManager manager, boolean isOnTheFly) {
        for (PsiReference reference : value.getReferences()) {
            if (reference instanceof QualifiedUiXmlReference) {
                QualifiedUiXmlReference classRef = (QualifiedUiXmlReference)reference;
                if (classRef.multiResolve(false).length > 0) continue;
                PsiClass qualifierClass = PsiTypesUtil.getPsiClass((PsiType)classRef.getQualifierReference().resolveVariableType());
                String lastName = classRef.getValue();
                LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                UiStyleElement styleElement = classRef.findStyleElement();
                if (styleElement != null) {
                    List<StylesheetFile> cssFiles = styleElement.getStylesheetFiles();
                    if (!cssFiles.isEmpty()) {
                        fixes = new LocalQuickFix[]{new CreateCssClassLocalQuickFix(styleElement.getTag(), lastName)};
                    }
                } else if (qualifierClass != null) {
                    fixes = new LocalQuickFix[]{new CreateMissingMethodQuickFix(qualifierClass, lastName)};
                }
                String message = qualifierClass != null ? GwtBundle.message("problem.description.cannot.resolve.symbol.0.in.1", lastName, qualifierClass.getName()) : GwtBundle.message("problem.description.cannot.resolve.0", lastName);
                problems.add(manager.createProblemDescriptor((PsiElement)value, classRef.getRangeInElement(), message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, fixes));
                continue;
            }
            if (!(reference instanceof UiXmlVariableReference) || reference.resolve() != null) continue;
            UiXmlVariableReference variableReference = (UiXmlVariableReference)reference;
            String message = GwtBundle.message("problem.description.cannot.resolve.0", variableReference.getValue());
            problems.add(manager.createProblemDescriptor((PsiElement)value, reference.getRangeInElement(), message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, new LocalQuickFix[0]));
        }
    }

    private static void checkReference(XmlTag tag, List<ProblemDescriptor> problems, InspectionManager manager, boolean isOnTheFly) {
        String namespace = tag.getNamespace();
        if (namespace.startsWith("urn:import:")) {
            PsiClass psiClass;
            PsiReference reference = tag.getReference();
            if (reference == null) {
                return;
            }
            String packageName = StringUtil.trimStart((String)namespace, (String)"urn:import:");
            String simpleName = tag.getLocalName();
            PsiElement resolvedReference = reference.resolve();
            if (resolvedReference == null || resolvedReference == tag) {
                String message = GwtBundle.message("problem.description.cannot.resolve.symbol.0.in.1", simpleName, packageName);
                problems.add(manager.createProblemDescriptor((PsiElement)tag, reference.getRangeInElement(), message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, new LocalQuickFix[0]));
            } else if (resolvedReference instanceof PsiClass && !InheritanceUtil.isInheritor((PsiClass)(psiClass = (PsiClass)resolvedReference), (String)"com.google.gwt.user.client.ui.IsWidget")) {
                String message = GwtBundle.message("problem.description.class.is.not.widget", simpleName);
                problems.add(manager.createProblemDescriptor((PsiElement)tag, reference.getRangeInElement(), message, ProblemHighlightType.GENERIC_ERROR, isOnTheFly, new LocalQuickFix[0]));
            }
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.unresolved.references.in.ui.xml.files", new Object[0]);
        if (string == null) {
            UiXmlUnresolvedReferencesInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtUiXmlReferences" == null) {
            UiXmlUnresolvedReferencesInspection.$$$reportNull$$$0(3);
        }
        return "GwtUiXmlReferences";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/UiXmlUnresolvedReferencesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/UiXmlUnresolvedReferencesInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CreateMissingMethodQuickFix
    extends BaseGwtLocalQuickFixOnPsiElement {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.create.missing.methods", new Object[0]);
        private final String myMethodName;

        private CreateMissingMethodQuickFix(PsiClass psiClass, String methodName) {
            super(FAMILY_NAME, GwtBundle.message("quickfix.name.create.0.method", methodName), (PsiElement)psiClass);
            this.myMethodName = methodName;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                CreateMissingMethodQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                CreateMissingMethodQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                CreateMissingMethodQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                CreateMissingMethodQuickFix.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof PsiClass)) {
                return;
            }
            if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)startElement.getContainingFile())) {
                return;
            }
            PsiClass psiClass = (PsiClass)startElement;
            PsiMethod method = GwtMethodGenerationUtil.addStringMethod(psiClass, this.myMethodName);
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)method);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/inspections/UiXmlUnresolvedReferencesInspection$CreateMissingMethodQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

