/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFixOnPsiElement;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.javaee.model.annotations.AnnotationModelUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GwtUiFieldAssignmentInspection
extends BaseGwtInspection {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            GwtUiFieldAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            GwtUiFieldAssignmentInspection.$$$reportNull$$$0(1);
        }
        if (!GwtUiFieldAssignmentInspection.shouldCheck((PsiElement)aClass) || UiBinderMappingService.getUiXmlFilesForClass(aClass).isEmpty()) {
            return null;
        }
        SmartList problems = new SmartList();
        aClass.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)problems, manager, isOnTheFly){
            final /* synthetic */ List val$problems;
            final /* synthetic */ InspectionManager val$manager;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$problems = list;
                this.val$manager = inspectionManager;
                this.val$isOnTheFly = bl;
            }

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                Boolean provided;
                PsiAnnotation annotation;
                PsiField field;
                PsiModifierList modifierList;
                PsiElement element;
                PsiExpression left = expression.getLExpression();
                if (left instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)left).resolve()) instanceof PsiField && (modifierList = (field = (PsiField)element).getModifierList()) != null && (annotation = modifierList.findAnnotation("com.google.gwt.uibinder.client.UiField")) != null && ((provided = (Boolean)AnnotationModelUtil.getBooleanValue((PsiAnnotation)annotation, (String)"provided", (boolean)false).getValue()) == null || !provided.booleanValue())) {
                    String message = "Assignment to @UiField annotated field will be ignored because it is initialized by UiBinder";
                    SetProvidedAttributeQuickFix fix = new SetProvidedAttributeQuickFix(annotation);
                    this.val$problems.add(this.val$manager.createProblemDescriptor((PsiElement)expression, "Assignment to @UiField annotated field will be ignored because it is initialized by UiBinder", (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.val$isOnTheFly));
                }
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }
        });
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            GwtUiFieldAssignmentInspection.$$$reportNull$$$0(2);
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Assignment to @UiField fields" == null) {
            GwtUiFieldAssignmentInspection.$$$reportNull$$$0(3);
        }
        return "Assignment to @UiField fields";
    }

    @NotNull
    public String getShortName() {
        if ("GwtUiFieldAssignment" == null) {
            GwtUiFieldAssignmentInspection.$$$reportNull$$$0(4);
        }
        return "GwtUiFieldAssignment";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SetProvidedAttributeQuickFix
    extends BaseGwtLocalQuickFixOnPsiElement {
        private static final String NAME = GwtBundle.message("quickfix.name.set.provided.to.true", new Object[0]);

        private SetProvidedAttributeQuickFix(PsiAnnotation annotation) {
            super(NAME, NAME, (PsiElement)annotation);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                SetProvidedAttributeQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                SetProvidedAttributeQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                SetProvidedAttributeQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                SetProvidedAttributeQuickFix.$$$reportNull$$$0(3);
            }
            if (!(startElement instanceof PsiAnnotation)) {
                return;
            }
            PsiAnnotation psiAnnotation = (PsiAnnotation)startElement;
            PsiExpression trueLiteral = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("true", null);
            psiAnnotation.setDeclaredAttributeValue("provided", (PsiAnnotationMemberValue)trueLiteral);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endElement";
                    break;
                }
            }
            objectArray[1] = "com/intellij/gwt/inspections/GwtUiFieldAssignmentInspection$SetProvidedAttributeQuickFix";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

