/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.AbstractClientCodeReferencesInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClientClassFromNonInheritedModuleUsageInspection
extends AbstractClientCodeReferencesInspection {
    @Override
    protected void checkClassReference(@NotNull PsiJavaCodeReferenceElement reference, @NotNull PsiClass referencedClass, @NotNull String className, @NotNull VirtualFile virtualFile, @NotNull GwtFacet gwtFacet, List<GwtModule> gwtModules, @NotNull GwtModulesManager gwtModulesManager, @NotNull InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        List<GwtModule> referencedModules;
        if (reference == null) {
            ClientClassFromNonInheritedModuleUsageInspection.$$$reportNull$$$0(0);
        }
        if (referencedClass == null) {
            ClientClassFromNonInheritedModuleUsageInspection.$$$reportNull$$$0(1);
        }
        if (className == null) {
            ClientClassFromNonInheritedModuleUsageInspection.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            ClientClassFromNonInheritedModuleUsageInspection.$$$reportNull$$$0(3);
        }
        if (gwtFacet == null) {
            ClientClassFromNonInheritedModuleUsageInspection.$$$reportNull$$$0(4);
        }
        if (gwtModulesManager == null) {
            ClientClassFromNonInheritedModuleUsageInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            ClientClassFromNonInheritedModuleUsageInspection.$$$reportNull$$$0(6);
        }
        if ((referencedModules = gwtModulesManager.findGwtModulesByClientSourceFile(virtualFile)).isEmpty()) {
            referencedModules = gwtModulesManager.findModulesByClass((PsiElement)reference, referencedClass.getQualifiedName());
        }
        if (referencedModules.isEmpty()) {
            return;
        }
        for (GwtModule gwtModule : gwtModules) {
            if (gwtModulesManager.isLibraryModule(gwtModule) || gwtModulesManager.isInheritedOrSelf(gwtModule, referencedModules) || ClientClassFromNonInheritedModuleUsageInspection.isImplicitlyInheritedInTest(reference, referencedModules, gwtModulesManager)) continue;
            GwtModule referencedModule = referencedModules.get(0);
            String message = GwtBundle.message("problem.description.class.0.is.defined.in.module.1.which.is.not.inherited.in.module.2", className, referencedModule.getQualifiedName(), gwtModule.getQualifiedName());
            problems.add(manager.createProblemDescriptor((PsiElement)reference, message, (LocalQuickFix)new InheritModuleQuickFix(gwtModule, referencedModule), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
            return;
        }
    }

    private static boolean isImplicitlyInheritedInTest(PsiJavaCodeReferenceElement reference, List<GwtModule> referencesModules, GwtModulesManager gwtModulesManager) {
        if (!ClientClassFromNonInheritedModuleUsageInspection.isInGwtTestCase(reference)) {
            return false;
        }
        GwtModule junitModule = gwtModulesManager.findGwtModuleByQualifiedName("com.google.gwt.junit.JUnit", reference.getResolveScope());
        return junitModule != null && gwtModulesManager.isInheritedOrSelf(junitModule, referencesModules);
    }

    private static boolean isInGwtTestCase(PsiJavaCodeReferenceElement reference) {
        PsiFile containingFile = reference.getContainingFile();
        VirtualFile file = containingFile.getVirtualFile();
        Project project = reference.getProject();
        if (file == null || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInTestSourceContent(file)) {
            return false;
        }
        if (!(containingFile instanceof PsiJavaFile)) {
            return false;
        }
        PsiClass[] classes = ((PsiJavaFile)containingFile).getClasses();
        if (classes.length != 1) {
            return false;
        }
        PsiClass psiClass = classes[0];
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)true, (String)"com.google.gwt.junit.client.GWTTestCase");
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.client.class.from.non.inherited.module.usage", new Object[0]);
        if (string == null) {
            ClientClassFromNonInheritedModuleUsageInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("GwtClientClassFromNonInheritedModule" == null) {
            ClientClassFromNonInheritedModuleUsageInspection.$$$reportNull$$$0(8);
        }
        return "GwtClientClassFromNonInheritedModule";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtFacet";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtModulesManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClassReference";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InheritModuleQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.inherit.module", new Object[0]);
        private final GwtModule myGwtModule;
        private final GwtModule myReferencedModule;

        InheritModuleQuickFix(GwtModule gwtModule, GwtModule referencedModule) {
            super(GwtBundle.message("quickfix.name.inherit.module.0.from.1", gwtModule.getQualifiedName(), referencedModule.getQualifiedName()));
            this.myGwtModule = gwtModule;
            this.myReferencedModule = referencedModule;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                InheritModuleQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor problemDescriptor) {
            if (project == null) {
                InheritModuleQuickFix.$$$reportNull$$$0(1);
            }
            if (problemDescriptor == null) {
                InheritModuleQuickFix.$$$reportNull$$$0(2);
            }
            if (!ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(new VirtualFile[]{this.myGwtModule.getModuleFile()}).hasReadonlyFiles()) {
                this.myGwtModule.addInherits().getName().setValue((Object)this.myReferencedModule.getQualifiedName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection$InheritModuleQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/ClientClassFromNonInheritedModuleUsageInspection$InheritModuleQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

