/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.startup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.jetbrains.ide.model.Solution;
import com.jetbrains.ide.model.TypingAssistModel_GeneratedKt;
import com.jetbrains.rdserver.FileStructureHost;
import com.jetbrains.rdserver.GotoHost;
import com.jetbrains.rdserver.TypingAssistHost;
import com.jetbrains.rdserver.editors.CompletionHost;
import com.jetbrains.rdserver.editors.CtrlClickHost;
import com.jetbrains.rdserver.editors.DaemonStatusHost;
import com.jetbrains.rdserver.editors.EditorsHost;
import com.jetbrains.rdserver.editors.QuickDocHost;
import com.jetbrains.rdserver.editors.RdLiveTemplateHost;
import com.jetbrains.rdserver.startup.RdAppStarter;
import com.jetbrains.rdserver.startup.RdPostStartupActivityKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/startup/RdPostStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity;", "()V", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.commercial.rdserver"})
public final class RdPostStartupActivity
implements StartupActivity {
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public void runActivity(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = project.getBasePath();
        if (string == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.basePath ?: return");
        String basePath = string;
        LOG.info("Completed opening project with base path " + basePath);
        Solution solution = RdAppStarter.Companion.getInstance().getSolutions().get(basePath);
        if (solution == null) {
            RdPostStartupActivity rdPostStartupActivity;
            RdPostStartupActivity $receiver = rdPostStartupActivity = this;
            LOG.info("Could not find matching solution!");
            return;
        }
        Solution solution2 = solution;
        project.putUserData(RdPostStartupActivityKt.getSOLUTION_KEY(), (Object)solution2);
        EditorsHost.Companion.getInstance(project).attach(solution2);
        QuickDocHost.Companion.getInstance(project).attach(solution2);
        new CompletionHost(project, solution2);
        new TypingAssistHost(project, TypingAssistModel_GeneratedKt.getTypingAssistModel((Solution)solution2));
        new DaemonStatusHost(project, solution2);
        new GotoHost(project, solution2);
        new FileStructureHost(project, solution2);
        new RdLiveTemplateHost(project, solution2).attach();
        new CtrlClickHost(project, solution2);
        solution2.isLoaded().set((Object)true);
        solution2.getSolutionLifecycle().isReadyForTyping().set((Object)true);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RdPostStartupActivity.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(RdPos\u2026rtupActivity::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/startup/RdPostStartupActivity$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.commercial.rdserver"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

