/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.startup;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u00a8\u0006\f"}, d2={"generateIdeaProject", "", "solutionDirectory", "virtualSolution", "", "generateImlFile", "", "file", "Ljava/io/File;", "contentRoot", "generateModulesXml", "imlFile", "intellij.platform.commercial.rdserver"})
public final class IdeaProjectGeneratorKt {
    @NotNull
    public static final String generateIdeaProject(@NotNull String solutionDirectory, boolean virtualSolution) {
        File dotIdea;
        Intrinsics.checkParameterIsNotNull((Object)solutionDirectory, (String)"solutionDirectory");
        File solutionFile = new File(solutionDirectory);
        if (virtualSolution && (dotIdea = new File(solutionFile, ".idea")).exists()) {
            String string = solutionFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"solutionFile.absolutePath");
            return string;
        }
        File ideaBackendDir = new File(solutionFile, ".idea/.idea-backend");
        String imlFileName = FilesKt.getNameWithoutExtension((File)solutionFile) + ".iml";
        File imlPath = new File(ideaBackendDir, imlFileName);
        File dotIdea2 = new File(ideaBackendDir, ".idea");
        File modulesXmlPath = new File(dotIdea2, "modules.xml");
        if (!imlPath.exists() || !modulesXmlPath.exists()) {
            ideaBackendDir.mkdirs();
            IdeaProjectGeneratorKt.generateImlFile(imlPath, solutionDirectory);
            dotIdea2.mkdirs();
            IdeaProjectGeneratorKt.generateModulesXml(modulesXmlPath, imlFileName);
        }
        String string = ideaBackendDir.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ideaBackendDir.absolutePath");
        return string;
    }

    private static final void generateImlFile(File file, String contentRoot) {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<module type=\"JAVA_MODULE\" version=\"4\">\n  <component name=\"NewModuleRootManager\" inherit-compiler-output=\"true\">\n    <exclude-output />\n    <content url=\"file:///" + contentRoot + "\">\n      <sourceFolder url=\"file:///" + contentRoot + "\" isTestSource=\"false\" />\n    </content>\n    <orderEntry type=\"inheritedJdk\" />\n    <orderEntry type=\"sourceFolder\" forTests=\"false\" />\n  </component>\n</module>";
        FilesKt.writeText$default((File)file, (String)content, null, (int)2, null);
    }

    private static final void generateModulesXml(File file, String imlFile) {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project version=\"4\">\n  <component name=\"ProjectModuleManager\">\n    <modules>\n      <module fileurl=\"file://$PROJECT_DIR$/" + imlFile + "\" filepath=\"$PROJECT_DIR$/" + imlFile + "\" />\n    </modules>\n  </component>\n</project>";
        FilesKt.writeText$default((File)file, (String)content, null, (int)2, null);
    }
}

