/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiFile;
import com.jetbrains.ide.model.AutoPopupResult;
import com.jetbrains.ide.model.TextControlTuple;
import com.jetbrains.rdserver.TypingAssistHostKt;
import com.jetbrains.rdserver.editors.DocumentTextHostKt;
import com.jetbrains.rdserver.startup.RdPostStartupActivityKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/editors/RdAutoPopupController;", "Lcom/intellij/codeInsight/AutoPopupController;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "scheduleAutoPopup", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "completionType", "Lcom/intellij/codeInsight/completion/CompletionType;", "condition", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.platform.commercial.rdserver"})
public final class RdAutoPopupController
extends AutoPopupController {
    private final Project project;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public void scheduleAutoPopup(@Nullable Editor editor, @NotNull CompletionType completionType, @Nullable Condition<PsiFile> condition) {
        Intrinsics.checkParameterIsNotNull((Object)completionType, (String)"completionType");
        TextControlTuple lastFocusedTextControl = (TextControlTuple)RdPostStartupActivityKt.getSolution(this.project).getEditors().getLastFocusedTextControlSession().getValue();
        if (editor == null || lastFocusedTextControl == null || Intrinsics.areEqual((Object)DocumentTextHostKt.textControlId(editor), (Object)lastFocusedTextControl.getId()) ^ true) {
            LOG.info("Skipping schedule autopopup request: active editor missing or mismatched");
            return;
        }
        Integer n = (Integer)editor.getUserData(TypingAssistHostKt.getLastTypingTimestamp());
        if (n == null) {
            RdAutoPopupController rdAutoPopupController;
            RdAutoPopupController $receiver = rdAutoPopupController = this;
            LOG.info("Skipping schedule autopopup request: no last typing timestamp");
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"editor.getUserData(lastT\u2026tamp\")\n      return\n    }");
        int timestamp = n;
        LOG.info("Sending autopopup request to frontend");
        lastFocusedTextControl.getTextControl().getAutoPopupResult().fire((Object)new AutoPopupResult(true, timestamp));
    }

    public RdAutoPopupController(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        this.project = project;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RdAutoPopupController.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(RdAut\u2026upController::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/editors/RdAutoPopupController$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.commercial.rdserver"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

