/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.jetbrains.ide.model.CustomStyleHighlighterModel;
import com.jetbrains.ide.model.DefaultHighlighterModel;
import com.jetbrains.ide.model.DocumentVersion;
import com.jetbrains.ide.model.EditableEntity;
import com.jetbrains.ide.model.EditableEntityId;
import com.jetbrains.ide.model.FoldingHighlighterModel;
import com.jetbrains.ide.model.GutterMarkActionModel;
import com.jetbrains.ide.model.GutterMarkHighlighterModel;
import com.jetbrains.ide.model.HighlighterIdList;
import com.jetbrains.ide.model.HighlighterList;
import com.jetbrains.ide.model.HighlighterModel;
import com.jetbrains.ide.model.HtmlStringTooltipModel;
import com.jetbrains.ide.model.Icon;
import com.jetbrains.ide.model.MarkupModelExtension;
import com.jetbrains.ide.model.RdGutterExecutionRequest;
import com.jetbrains.ide.model.RdMarkupModel;
import com.jetbrains.ide.model.RdMarkupModelBase;
import com.jetbrains.ide.model.StringTooltipModel;
import com.jetbrains.ide.model.TooltipModel;
import com.jetbrains.ide.model.TooltipProviderModel;
import com.jetbrains.rdserver.ActionsHostKt;
import com.jetbrains.rdserver.HighlighterRegistrationsHost;
import com.jetbrains.rdserver.HighlighterRegistrationsHostKt;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rdserver.RiderExKt;
import com.jetbrains.rdserver.editors.EditorsHost;
import com.jetbrains.rider.model.highlighterRegistration.IdeaTextAttributes;
import com.jetbrains.rider.rdtext.TextBufferVersion;
import com.jetbrains.rider.util.lifetime.Lifetime;
import gnu.trove.TLongObjectHashMap;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 22\u00020\u0001:\u00012B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010#\u001a\u0004\u0018\u00010\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020%2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010&\u001a\u00020\u001fH\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0019H\u0002J\u000e\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u001dJ\u0010\u0010-\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u001dJ\u0016\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u0002012\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/jetbrains/rdserver/editors/MarkupHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "doc", "Lcom/intellij/openapi/editor/Document;", "editableEntityId", "Lcom/jetbrains/ide/model/EditableEntityId;", "editableEntity", "Lcom/jetbrains/ide/model/EditableEntity;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/ide/model/EditableEntityId;Lcom/jetbrains/ide/model/EditableEntity;Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "frontendMarkupModel", "Lcom/jetbrains/ide/model/RdMarkupModel;", "highlighterMap", "Lgnu/trove/TLongObjectHashMap;", "Lcom/intellij/openapi/editor/RangeMarker;", "highlighterModelMap", "Lcom/jetbrains/ide/model/HighlighterModel;", "listener", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "addOrUpdateHighlighter", "", "id", "", "highlighterModel", "convertFoldingModel", "foldingModel", "Lcom/intellij/openapi/editor/FoldRegion;", "documentVersion", "Lcom/jetbrains/ide/model/DocumentVersion;", "convertHighlighter", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "convertLineMarker", "gutterIconRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "currentDocumentVersion", "getTooltipForHighlighter", "Lcom/jetbrains/ide/model/TooltipModel;", "handleHighlighterLeftClick", "highlighterId", "removeFoldRegion", "region", "removeHighlighter", "reportFoldRegion", "watchEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "intellij.platform.commercial.rdserver"})
public final class MarkupHost {
    private final TLongObjectHashMap<RangeMarker> highlighterMap;
    private final TLongObjectHashMap<HighlighterModel> highlighterModelMap;
    private RdMarkupModel frontendMarkupModel;
    private MarkupModelListener listener;
    private final Project project;
    private final Document doc;
    private final EditableEntity editableEntity;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    public final void watchEditor(@NotNull Editor editor, @NotNull Lifetime lifetime) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
            MarkupModel markupModel = editor.getMarkupModel();
            if (!(markupModel instanceof MarkupModelEx)) {
                markupModel = null;
            }
            MarkupModelEx markupModelEx = (MarkupModelEx)markupModel;
            if (markupModelEx == null) break block2;
            Disposable disposable = RiderExKt.toDisposable(lifetime);
            MarkupModelListener markupModelListener = this.listener;
            if (markupModelListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
            }
            markupModelEx.addMarkupModelListener(disposable, markupModelListener);
        }
    }

    private final void addOrUpdateHighlighter(long id, HighlighterModel highlighterModel) {
        RdMarkupModel rdMarkupModel = this.frontendMarkupModel;
        if (rdMarkupModel == null) {
            return;
        }
        RdMarkupModel frontendMarkupModel = rdMarkupModel;
        HighlighterModel oldModel = (HighlighterModel)this.highlighterModelMap.get(id);
        if (Intrinsics.areEqual((Object)oldModel, (Object)highlighterModel) ^ true) {
            if (oldModel != null) {
                frontendMarkupModel.getHighlightersRemoved().fire((Object)new HighlighterIdList(CollectionsKt.listOf((Object)id)));
            }
            if (highlighterModel != null) {
                this.highlighterModelMap.put(id, (Object)highlighterModel);
                frontendMarkupModel.getHighlightersAdded().fire((Object)new HighlighterList(CollectionsKt.listOf((Object)highlighterModel)));
            }
        }
    }

    private final void removeHighlighter(long id) {
        RdMarkupModel rdMarkupModel = this.frontendMarkupModel;
        if (rdMarkupModel == null) {
            return;
        }
        RdMarkupModel frontendMarkupModel = rdMarkupModel;
        frontendMarkupModel.getHighlightersRemoved().fire((Object)new HighlighterIdList(CollectionsKt.listOf((Object)id)));
        this.highlighterMap.remove(id);
        this.highlighterModelMap.remove(id);
    }

    private final DocumentVersion currentDocumentVersion() {
        TextBufferVersion textBufferVersion;
        TextBufferVersion it = textBufferVersion = this.editableEntity.getText().getBufferVersion();
        return new DocumentVersion(it.getMaster(), it.getSlave());
    }

    public final void reportFoldRegion(@NotNull FoldRegion region) {
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        long id = ((RangeMarkerEx)region).getId();
        HighlighterModel foldingModel = this.convertFoldingModel(region, this.currentDocumentVersion());
        this.highlighterMap.put(id, (Object)((RangeMarker)region));
        this.addOrUpdateHighlighter(id, foldingModel);
    }

    public final void removeFoldRegion(@NotNull FoldRegion region) {
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        long id = ((RangeMarkerEx)region).getId();
        this.removeHighlighter(id);
    }

    private final HighlighterModel convertHighlighter(RangeHighlighterEx highlighter, DocumentVersion documentVersion) {
        GutterIconRenderer gutterIconRenderer = highlighter.getGutterIconRenderer();
        if (gutterIconRenderer != null) {
            return this.convertLineMarker(highlighter, gutterIconRenderer, documentVersion);
        }
        HighlightInfo highlightInfo = HighlightInfo.fromRangeHighlighter((RangeHighlighter)((RangeHighlighter)highlighter));
        if (highlightInfo == null) {
            TextAttributes textAttributes = highlighter.getTextAttributes();
            if (textAttributes == null) {
                return null;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"highlighter.textAttributes ?: return null");
            TextAttributes textAttributes2 = textAttributes;
            IdeaTextAttributes attributes = HighlighterRegistrationsHost.Companion.convertAttributes(textAttributes2);
            return (HighlighterModel)new CustomStyleHighlighterModel(attributes, attributes, highlighter.getLayer(), highlighter.getTargetArea() == HighlighterTargetArea.EXACT_RANGE, documentVersion, null, highlighter.getId(), HighlighterRegistrationsHost.Companion.getCUSTOM_HIGHLIGHTING_ID(), highlighter.getStartOffset(), highlighter.getEndOffset());
        }
        TextAttributesKey textAttributesKey = highlightInfo.forcedTextAttributesKey;
        if (textAttributesKey == null) {
            HighlightInfoType highlightInfoType = highlightInfo.type;
            Intrinsics.checkExpressionValueIsNotNull((Object)highlightInfoType, (String)"highlightInfo.type");
            TextAttributesKey textAttributesKey2 = highlightInfoType.getAttributesKey();
            textAttributesKey = textAttributesKey2;
            Intrinsics.checkExpressionValueIsNotNull((Object)textAttributesKey2, (String)"highlightInfo.type.attributesKey");
        }
        String attributeId = HighlighterRegistrationsHostKt.toAttributeId(textAttributesKey);
        if (!HighlighterRegistrationsHost.Companion.getAllRegisteredAttributeIds().contains(attributeId)) {
            EditorsHost.Companion.getLOG().info("Ignoring highlighter which has not been registered: " + attributeId);
            return null;
        }
        return (HighlighterModel)new DefaultHighlighterModel(highlighter.getLayer(), highlighter.getTargetArea() == HighlighterTargetArea.EXACT_RANGE, documentVersion, null, highlighter.getId(), attributeId, highlighter.getStartOffset(), highlighter.getEndOffset());
    }

    private final HighlighterModel convertLineMarker(RangeHighlighterEx highlighter, GutterIconRenderer gutterIconRenderer, DocumentVersion documentVersion) {
        GutterMarkHighlighterModel gutterMarkHighlighterModel;
        Icon icon;
        javax.swing.Icon icon2 = gutterIconRenderer.getIcon();
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"gutterIconRenderer.icon");
        Icon icon3 = ProtocolConversionsKt.toProtocolModel(icon2);
        if (icon3 == null) {
            return null;
        }
        Icon icon4 = icon = icon3;
        GutterMarkHighlighterModel gutterMarkHighlighterModel2 = gutterMarkHighlighterModel;
        GutterMarkHighlighterModel gutterMarkHighlighterModel3 = gutterMarkHighlighterModel;
        List list = CollectionsKt.emptyList();
        String string = gutterIconRenderer.getTooltipText();
        if (string == null) {
            string = "";
        }
        gutterMarkHighlighterModel2(icon4, list, string, gutterIconRenderer.getClickAction() != null, highlighter.getLayer(), highlighter.getTargetArea() == HighlighterTargetArea.EXACT_RANGE, documentVersion, null, highlighter.getId(), HighlighterRegistrationsHost.Companion.getLINE_MARKER_ID(), highlighter.getStartOffset(), highlighter.getEndOffset());
        return (HighlighterModel)gutterMarkHighlighterModel3;
    }

    private final HighlighterModel convertFoldingModel(FoldRegion foldingModel, DocumentVersion documentVersion) {
        String string = foldingModel.getPlaceholderText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"foldingModel.placeholderText");
        FoldRegion foldRegion = foldingModel;
        if (foldRegion == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeMarkerEx");
        }
        return (HighlighterModel)new FoldingHighlighterModel(string, !foldingModel.isExpanded(), 0, true, documentVersion, null, ((RangeMarkerEx)foldRegion).getId(), HighlighterRegistrationsHost.Companion.getFOLD_REGION_ID(), foldingModel.getStartOffset(), foldingModel.getEndOffset());
    }

    private final TooltipModel getTooltipForHighlighter(long id) {
        Object object = this.highlighterMap.get(id);
        if (!(object instanceof RangeHighlighterEx)) {
            object = null;
        }
        RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)object;
        if (rangeHighlighterEx == null) {
            return (TooltipModel)new StringTooltipModel(null);
        }
        RangeHighlighterEx highlighter = rangeHighlighterEx;
        HighlightInfo highlightInfo = HighlightInfo.fromRangeHighlighter((RangeHighlighter)((RangeHighlighter)highlighter));
        if (highlightInfo != null) {
            return (TooltipModel)new HtmlStringTooltipModel(highlightInfo.getToolTip(), highlightInfo.getDescription());
        }
        return (TooltipModel)new StringTooltipModel(null);
    }

    private final void handleHighlighterLeftClick(long highlighterId) {
        Object object = this.highlighterMap.get(highlighterId);
        if (!(object instanceof RangeHighlighterEx)) {
            object = null;
        }
        RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)object;
        if (rangeHighlighterEx == null) {
            return;
        }
        RangeHighlighterEx highlighter = rangeHighlighterEx;
        GutterIconRenderer gutterIconRenderer = highlighter.getGutterIconRenderer();
        if (gutterIconRenderer == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)gutterIconRenderer, (String)"highlighter.gutterIconRenderer ?: return");
        GutterIconRenderer gutterIconRenderer2 = gutterIconRenderer;
        AnAction anAction = gutterIconRenderer2.getClickAction();
        if (anAction == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)anAction, (String)"gutterIconRenderer.clickAction ?: return");
        AnAction clickAction = anAction;
        Object[] objectArray = EditorFactory.getInstance().getEditors(this.doc);
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"EditorFactory.getInstance().getEditors(doc)");
        Editor editor = (Editor)ArraysKt.firstOrNull((Object[])objectArray);
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        MouseEvent mouseEvent = new MouseEvent(editor2.getComponent(), 500, System.currentTimeMillis(), 16, 0, 0, 1, false, 1);
        AnActionEvent anActionEvent = AnActionEvent.createFromInputEvent((InputEvent)mouseEvent, (String)"unknown", (Presentation)new Presentation(), (DataContext)ActionsHostKt.dataContextForEditor(this.project, editor2));
        Intrinsics.checkExpressionValueIsNotNull((Object)anActionEvent, (String)"AnActionEvent.createFrom\u2026rEditor(project, editor))");
        AnActionEvent actionEvent = anActionEvent;
        clickAction.actionPerformed(actionEvent);
    }

    public MarkupHost(@NotNull Project project, @NotNull Document doc, final @NotNull EditableEntityId editableEntityId, @NotNull EditableEntity editableEntity, final @NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)doc, (String)"doc");
        Intrinsics.checkParameterIsNotNull((Object)editableEntityId, (String)"editableEntityId");
        Intrinsics.checkParameterIsNotNull((Object)editableEntity, (String)"editableEntity");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        this.project = project;
        this.doc = doc;
        this.editableEntity = editableEntity;
        this.highlighterMap = new TLongObjectHashMap();
        this.highlighterModelMap = new TLongObjectHashMap();
        this.editableEntity.getMarkup().advise(lifetime, (Function1)new Function1<RdMarkupModelBase, Unit>(){

            /*
             * Unable to fully structure code
             */
            public final void invoke(final @NotNull RdMarkupModelBase frontendMarkupModel) {
                Intrinsics.checkParameterIsNotNull((Object)frontendMarkupModel, (String)"frontendMarkupModel");
                if (!(frontendMarkupModel instanceof RdMarkupModel)) {
                    MarkupHost.Companion.getLOG().info("No frontend markup model for " + editableEntityId.getFilePath());
                    return;
                }
                MarkupHost.access$setFrontendMarkupModel$p(this, (RdMarkupModel)frontendMarkupModel);
                documentMarkupModel = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)MarkupHost.access$getDoc$p(this), (Project)MarkupHost.access$getProject$p(this), (boolean)true);
                if (documentMarkupModel == null) {
                    MarkupHost.Companion.getLOG().info("No document markup model for " + editableEntityId.getFilePath());
                    return;
                }
                MarkupHost.access$setListener$p(this, new MarkupModelListener(){

                    public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
                        Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
                        Companion.getLOG().info("Updated document highlighter: " + highlighter);
                        HighlighterModel highlighterModel = this.convertHighlighter(highlighter, this.currentDocumentVersion());
                        this.addOrUpdateHighlighter(highlighter.getId(), highlighterModel);
                    }

                    public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                        Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
                        this.removeHighlighter(highlighter.getId());
                    }

                    public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                        Intrinsics.checkParameterIsNotNull((Object)highlighter, (String)"highlighter");
                        Companion.getLOG().info("Added document highlighter: " + highlighter);
                        HighlighterModel highlighterModel = this.convertHighlighter(highlighter, this.currentDocumentVersion());
                        if (highlighterModel != null) {
                            highlighterMap.put(highlighter.getId(), (Object)highlighter);
                            highlighterModelMap.put(highlighter.getId(), (Object)highlighterModel);
                            ((RdMarkupModel)frontendMarkupModel).getHighlightersAdded().fire((Object)new HighlighterList(CollectionsKt.listOf((Object)highlighterModel)));
                        }
                    }
                });
                documentMarkupModel.addMarkupModelListener(RiderExKt.toDisposable(lifetime), MarkupHost.access$getListener$p(this));
                for (MarkupModelExtension ext : ((RdMarkupModel)frontendMarkupModel).getExtensions()) {
                    var5_5 = ext.getKey();
                    switch (var5_5.hashCode()) {
                        case -417562546: {
                            if (!var5_5.equals("GUTTER_MARK_ACTION_MODEL_KEY")) ** break;
                            break;
                        }
                        case 238338327: {
                            if (!var5_5.equals("TOOLTIP_PROVIDER_MODEL_KEY")) ** break;
                            v0 = ext;
                            if (v0 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.ide.model.TooltipProviderModel");
                            }
                            tooltipProviderModel = (TooltipProviderModel)v0;
                            tooltipProviderModel.getGetTooltip().set((Function1)new Function1<Long, TooltipModel>(){

                                @NotNull
                                public final TooltipModel invoke(long id) {
                                    return this.getTooltipForHighlighter(id);
                                }
                            });
                            ** break;
                        }
                    }
                    v1 = ext;
                    if (v1 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.ide.model.GutterMarkActionModel");
                    }
                    gutterMarkActionModel = (GutterMarkActionModel)v1;
                    gutterMarkActionModel.getLeftClick().advise(Lifetime.Companion.getEternal(), (Function1)new Function1<RdGutterExecutionRequest, Unit>(){

                        public final void invoke(@NotNull RdGutterExecutionRequest req) {
                            Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
                            this.handleHighlighterLeftClick(req.getGutterId());
                        }
                    });
lbl31:
                    // 5 sources

                }
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MarkupHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(MarkupHost::class.java)");
        LOG = logger;
    }

    @Nullable
    public static final /* synthetic */ RdMarkupModel access$getFrontendMarkupModel$p(MarkupHost $this) {
        return $this.frontendMarkupModel;
    }

    public static final /* synthetic */ void access$setFrontendMarkupModel$p(MarkupHost $this, @Nullable RdMarkupModel rdMarkupModel) {
        $this.frontendMarkupModel = rdMarkupModel;
    }

    @NotNull
    public static final /* synthetic */ Document access$getDoc$p(MarkupHost $this) {
        return $this.doc;
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(MarkupHost $this) {
        return $this.project;
    }

    @NotNull
    public static final /* synthetic */ MarkupModelListener access$getListener$p(MarkupHost $this) {
        MarkupModelListener markupModelListener = $this.listener;
        if (markupModelListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
        }
        return markupModelListener;
    }

    public static final /* synthetic */ void access$setListener$p(MarkupHost $this, @NotNull MarkupModelListener markupModelListener) {
        $this.listener = markupModelListener;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/editors/MarkupHost$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.commercial.rdserver"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

