/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.jetbrains.ide.model.EditableEntity;
import com.jetbrains.rdserver.RiderExKt;
import com.jetbrains.rdserver.editors.DocumentTextHost$WhenMappings;
import com.jetbrains.rider.rdtext.intrinsics.RdTextChange;
import com.jetbrains.rider.rdtext.intrinsics.RdTextChangeKind;
import com.jetbrains.rider.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0012\u001a\u00020\u0010*\u00020\u0013H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/editors/DocumentTextHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "editableEntity", "Lcom/jetbrains/ide/model/EditableEntity;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/ide/model/EditableEntity;Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "applyingRemoteChange", "", "applyTextChange", "", "change", "Lcom/jetbrains/rider/rdtext/intrinsics/RdTextChange;", "verifyActualText", "toTextChange", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "Companion", "intellij.platform.commercial.rdserver"})
public final class DocumentTextHost {
    private boolean applyingRemoteChange;
    private final Document document;
    @NotNull
    private static final Logger LOG;
    public static final Companion Companion;

    private final void applyTextChange(RdTextChange change) {
        int start = change.getStartOffset();
        switch (DocumentTextHost$WhenMappings.$EnumSwitchMapping$0[change.getKind().ordinal()]) {
            case 1: {
                this.document.insertString(start, (CharSequence)change.getNew());
                break;
            }
            case 2: {
                this.verifyActualText(change);
                this.document.deleteString(start, start + change.getOld().length());
                break;
            }
            case 3: {
                this.verifyActualText(change);
                this.document.replaceString(start, start + change.getOld().length(), (CharSequence)change.getNew());
                break;
            }
            case 4: {
                this.document.replaceString(0, this.document.getTextLength(), (CharSequence)change.getNew());
            }
        }
        if (change.getFullTextLength() != this.document.getTextLength()) {
            LOG.info("Inconsistency detected: expected text length after change " + change.getFullTextLength() + ", actual " + this.document.getTextLength());
        }
    }

    private final void verifyActualText(RdTextChange change) {
        String actualText = ((Object)this.document.getCharsSequence().subSequence(change.getStartOffset(), change.getStartOffset() + change.getOld().length())).toString();
        if (Intrinsics.areEqual((Object)actualText, (Object)change.getOld()) ^ true) {
            LOG.info("Inconsistency detected: expected " + change.getOld() + ", actual " + actualText);
        }
    }

    private final RdTextChange toTextChange(@NotNull DocumentEvent $receiver) {
        RdTextChangeKind kind = $receiver.getOldLength() == 0 ? RdTextChangeKind.Insert : ($receiver.getNewLength() == 0 ? RdTextChangeKind.Remove : ($receiver.isWholeTextReplaced() ? RdTextChangeKind.Reset : RdTextChangeKind.Replace));
        int n = $receiver.getOffset();
        String string = ((Object)$receiver.getOldFragment()).toString();
        String string2 = ((Object)$receiver.getNewFragment()).toString();
        Document document = $receiver.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"document");
        return new RdTextChange(kind, n, string, string2, document.getTextLength());
    }

    public DocumentTextHost(final @NotNull Project project, @NotNull Document document, final @NotNull EditableEntity editableEntity, @NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)editableEntity, (String)"editableEntity");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        this.document = document;
        editableEntity.getText().advise(lifetime, (Function1)new Function1<RdTextChange, Unit>(){

            public final void invoke(final @NotNull RdTextChange change) {
                Intrinsics.checkParameterIsNotNull((Object)change, (String)"change");
                WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public final void run() {
                        applyingRemoteChange = true;
                        try {
                            this.applyTextChange(change);
                        }
                        finally {
                            applyingRemoteChange = false;
                        }
                    }
                });
            }
        });
        editableEntity.getCompareAllTextTask().set((Function1)new Function1<String, Boolean>(){

            public final boolean invoke(@NotNull String text) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                if (Intrinsics.areEqual((Object)document.getText(), (Object)text) ^ true) {
                    Companion.getLOG().info("compareAllText consistency check failed: our text:\n" + document.getText() + "\nFrontend text:\n" + text);
                    bl = false;
                } else {
                    bl = true;
                }
                return bl;
            }
        });
        this.document.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (!applyingRemoteChange) {
                    editableEntity.getText().fire(this.toTextChange(event));
                }
            }
        }, RiderExKt.toDisposable(lifetime));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DocumentTextHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(DocumentTextHost::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/editors/DocumentTextHost$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.commercial.rdserver"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

