/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.editors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.jetbrains.ide.model.CompletionTuple;
import com.jetbrains.ide.model.LastFocusedTextControl;
import com.jetbrains.ide.model.Solution;
import com.jetbrains.ide.model.TextControlTuple;
import com.jetbrains.rdserver.RiderExKt;
import com.jetbrains.rdserver.editors.CompletionSession;
import com.jetbrains.rdserver.editors.EditorsHost;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IViewable;
import com.jetbrains.rider.util.reactive.InterfacesKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rdserver/editors/CompletionHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "solution", "Lcom/jetbrains/ide/model/Solution;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/ide/model/Solution;)V", "intellij.platform.commercial.rdserver"})
public final class CompletionHost {
    private final Project project;

    public CompletionHost(@NotNull Project project, @NotNull Solution solution) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)solution, (String)"solution");
        this.project = project;
        Lifetime lifetime = RiderExKt.toLifetime((Disposable)this.project);
        InterfacesKt.viewNotNull((IViewable)((IViewable)solution.getEditors().getLastFocusedTextControlSession()), (Lifetime)lifetime, (Function2)((Function2)new Function2<Lifetime, TextControlTuple, Unit>(){

            public final void invoke(@NotNull Lifetime textControlLifetime, @NotNull TextControlTuple textControlTuple) {
                Intrinsics.checkParameterIsNotNull((Object)textControlLifetime, (String)"textControlLifetime");
                Intrinsics.checkParameterIsNotNull((Object)textControlTuple, (String)"textControlTuple");
                LastFocusedTextControl textControl = textControlTuple.getTextControl();
                Editor editor = EditorsHost.Companion.getInstance(project).findEditor(textControlTuple.getId());
                if (editor == null) {
                    return;
                }
                final Editor editor2 = editor;
                InterfacesKt.viewNotNull((IViewable)((IViewable)textControl.getCompletionSession()), (Lifetime)textControlLifetime, (Function2)((Function2)new Function2<Lifetime, CompletionTuple, Unit>(){

                    public final void invoke(@NotNull Lifetime sessionLifetime, @NotNull CompletionTuple completionTuple) {
                        Intrinsics.checkParameterIsNotNull((Object)sessionLifetime, (String)"sessionLifetime");
                        Intrinsics.checkParameterIsNotNull((Object)completionTuple, (String)"completionTuple");
                        new CompletionSession(project, editor2, completionTuple, sessionLifetime).run();
                    }
                }));
            }
        }));
    }
}

