/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.references;

import com.intellij.batch.model.BatchJobXmlModel;
import com.intellij.batch.model.BatchXmlDomModelManager;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BatchJobXmlFileReference
extends PsiReferenceBase<PsiElement> {
    public BatchJobXmlFileReference(PsiLiteral element) {
        this(element, ElementManipulators.getManipulator((PsiElement)element).getRangeInElement((PsiElement)element));
    }

    public BatchJobXmlFileReference(PsiLiteral element, TextRange range) {
        super((PsiElement)element, range);
    }

    public PsiElement resolve() {
        String value = this.getValue();
        for (XmlFile xmlFile : this.getAllJobXmlFiles()) {
            String name = xmlFile.getName();
            if (!FileUtil.getNameWithoutExtension((String)name).equals(value)) continue;
            return xmlFile;
        }
        return null;
    }

    @NotNull
    private Set<XmlFile> getAllJobXmlFiles() {
        HashSet files = new HashSet();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module != null) {
            for (BatchJobXmlModel jobXmlModel : BatchXmlDomModelManager.getInstance(module.getProject()).getAllBatchJobModels(module)) {
                files.addAll(jobXmlModel.getConfigFiles());
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            BatchJobXmlFileReference.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            BatchJobXmlFileReference.$$$reportNull$$$0(1);
        }
        return this.getElement();
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            BatchJobXmlFileReference.$$$reportNull$$$0(2);
        }
        return super.handleElementRename(FileUtil.getNameWithoutExtension((String)newElementName));
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<LookupElementBuilder> lookups = new ArrayList<LookupElementBuilder>();
        for (XmlFile file : this.getAllJobXmlFiles()) {
            String fileName = file.getName();
            lookups.add(LookupElementBuilder.create((String)FileUtil.getNameWithoutExtension((String)fileName)).withTypeText(fileName));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(lookups);
        if (objectArray == null) {
            BatchJobXmlFileReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/batch/references/BatchJobXmlFileReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJobXmlFiles";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/batch/references/BatchJobXmlFileReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

