/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spring.security.references.SpringSecurityRolePsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringSecurityRolePsiReferenceProvider
extends PsiReferenceProvider {
    private final boolean tokenize;
    private final boolean includePredefinedRoles;

    protected SpringSecurityRolePsiReferenceProvider(boolean tokenize, boolean includePredefinedRoles) {
        this.tokenize = tokenize;
        this.includePredefinedRoles = includePredefinedRoles;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            SpringSecurityRolePsiReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringSecurityRolePsiReferenceProvider.$$$reportNull$$$0(1);
        }
        String value = this.getStringValue(element);
        PsiReference[] psiReferenceArray = SpringSecurityRolePsiReferenceProvider.getSecurityRolesReferences(element, value, this.tokenize, this.includePredefinedRoles);
        if (psiReferenceArray == null) {
            SpringSecurityRolePsiReferenceProvider.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    public static PsiReference[] getSecurityRolesReferences(@NotNull PsiElement element, @Nullable String value, boolean tokenize, boolean includePredefinedRoles) {
        if (element == null) {
            SpringSecurityRolePsiReferenceProvider.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (!tokenize) {
            return new PsiReference[]{SpringSecurityRolePsiReferenceProvider.getReference(element, value, module, includePredefinedRoles)};
        }
        SmartList references = new SmartList();
        for (String token : StringUtil.tokenize((String)value, (String)",")) {
            if (StringUtil.isEmptyOrSpaces((String)token)) continue;
            references.add(SpringSecurityRolePsiReferenceProvider.getReference(element, token, module, includePredefinedRoles));
        }
        return (PsiReference[])ArrayUtil.toObjectArray((Collection)references, PsiReference.class);
    }

    @Nullable
    protected abstract String getStringValue(PsiElement var1);

    private static PsiReference getReference(PsiElement element, String token, Module module, boolean includePredefinedRoles) {
        return new SpringSecurityRolePsiReference(element, token, module, includePredefinedRoles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/SpringSecurityRolePsiReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/SpringSecurityRolePsiReferenceProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSecurityRolesReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PsiLiteralExpressionProvider
    extends SpringSecurityRolePsiReferenceProvider {
        public PsiLiteralExpressionProvider(boolean tokenize, boolean roles) {
            super(tokenize, roles);
        }

        @Override
        protected String getStringValue(PsiElement element) {
            if (element instanceof PsiLiteralExpression) {
                Object value = ((PsiLiteralExpression)element).getValue();
                return value instanceof String ? (String)value : null;
            }
            return null;
        }
    }

    public static class XmlAttributeValueProvider
    extends SpringSecurityRolePsiReferenceProvider {
        public XmlAttributeValueProvider(boolean tokenize) {
            super(tokenize, true);
        }

        @Override
        protected String getStringValue(PsiElement element) {
            if (element instanceof XmlAttributeValue) {
                return ((XmlAttributeValue)element).getValue();
            }
            return null;
        }
    }
}

