/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.javaee.cloudfoundry.agent.CFAppFogInfra;
import com.intellij.javaee.cloudfoundry.cloud.CFDeploymentConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFManifest;
import com.intellij.javaee.cloudfoundry.cloud.CFServerConfiguration;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CFCloudLocation {
    public static final CloudDeploymentNameProvider NAME_PROVIDER = CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER;
    public static final CFCloudLocation GLOBAL = new CFCloudLocation("GLOBAL", "Global"){

        @Override
        public String getApiUrl(CFServerConfiguration serverConfig) {
            return serverConfig.getApiUrl();
        }

        @Override
        public List<String> getAppUrls(CFServerConfiguration serverConfig, DeploymentTask<CFDeploymentConfiguration> deploymentTask) {
            String defaultDomain;
            CFDeploymentConfiguration deploymentConfig;
            CFDeploymentConfiguration cFDeploymentConfiguration = deploymentConfig = deploymentTask == null ? null : (CFDeploymentConfiguration)deploymentTask.getConfiguration();
            if (deploymentConfig != null) {
                CFAppFogInfra infra;
                if (!deploymentConfig.isDefaultDomain()) {
                    return CFCloudLocation.createUrlSingleton(deploymentConfig.getDomain());
                }
                List<String> manifestAppUrls = new ManifestAppUrlsCase(serverConfig, deploymentConfig).getAppUrls();
                if (!manifestAppUrls.isEmpty()) {
                    return manifestAppUrls;
                }
                if (serverConfig.isAppFog() && (infra = deploymentConfig.getAppFogInfra()) != null) {
                    return CFCloudLocation.createDefaultAppUrlSingleton((DeploymentTask<CFDeploymentConfiguration>)deploymentTask, infra.getDomain());
                }
            }
            if ((defaultDomain = serverConfig.getDefaultDomain()) != null) {
                return CFCloudLocation.createDefaultAppUrlSingleton((DeploymentTask<CFDeploymentConfiguration>)deploymentTask, defaultDomain);
            }
            if (deploymentConfig != null) {
                return CFCloudLocation.createUrlSingleton(deploymentConfig.getDomain());
            }
            return CFCloudLocation.createUrlSingleton("cloudfoundry.com");
        }
    };
    public static final CFCloudLocation LOCAL = new LocalInstanceBase("LOCAL", "Local (vcap.me)"){

        @Override
        protected String getDomain(CFServerConfiguration serverConfig) {
            return "vcap.me";
        }
    };
    public static final CFCloudLocation MICRO_OFFLINE = new LocalInstanceBase("MICRO_OFFLINE", "Micro - offline"){

        @Override
        protected String getDomain(CFServerConfiguration serverConfig) {
            return serverConfig.getDomain();
        }

        @Override
        public String getApiUrl(CFServerConfiguration serverConfig) {
            return this.appendPort(super.getApiUrl(serverConfig), serverConfig);
        }

        @Override
        public List<String> getAppUrls(CFServerConfiguration serverConfig, DeploymentTask<CFDeploymentConfiguration> deploymentTask) {
            return ContainerUtil.map(super.getAppUrls(serverConfig, deploymentTask), url -> this.appendPort((String)url, serverConfig));
        }

        private String appendPort(String url, CFServerConfiguration serverConfig) {
            return url + ":" + serverConfig.getPort();
        }
    };
    public static final CFCloudLocation[] LOCATIONS = new CFCloudLocation[]{GLOBAL, LOCAL, MICRO_OFFLINE};
    private static final Map<String, CFCloudLocation> ourId2Locations = new HashMap<String, CFCloudLocation>();
    private final String myId;
    private final String myName;

    private static List<String> createDefaultAppUrlSingleton(DeploymentTask<CFDeploymentConfiguration> deploymentTask, String domain) {
        DeploymentSource deploymentSource = deploymentTask == null ? null : deploymentTask.getSource();
        String subDomain = deploymentSource == null ? null : NAME_PROVIDER.getDeploymentName(deploymentSource);
        return CFCloudLocation.createUrlSingleton(subDomain, domain);
    }

    private static List<String> createUrlSingleton(String subDomain, String domain) {
        return Collections.singletonList(CFCloudLocation.createUrl(subDomain, domain));
    }

    private static List<String> createUrlSingleton(String domain) {
        return CFCloudLocation.createUrlSingleton(null, domain);
    }

    public static CFCloudLocation get(String id) {
        CFCloudLocation location = ourId2Locations.get(id);
        return location == null ? GLOBAL : location;
    }

    private CFCloudLocation(String id, String name) {
        this.myId = id;
        this.myName = name;
    }

    public String getId() {
        return this.myId;
    }

    public String toString() {
        return this.myName;
    }

    private static String createUrl(String subDomain, String domain) {
        StringBuilder result = new StringBuilder();
        result.append("http://");
        if (subDomain != null) {
            result.append(subDomain);
            result.append(".");
        }
        result.append(StringUtil.isEmpty((String)domain) ? "<>" : domain);
        return result.toString();
    }

    public abstract String getApiUrl(CFServerConfiguration var1);

    public abstract List<String> getAppUrls(CFServerConfiguration var1, DeploymentTask<CFDeploymentConfiguration> var2);

    static {
        for (CFCloudLocation location : LOCATIONS) {
            ourId2Locations.put(location.getId(), location);
        }
    }

    private static class ManifestAppUrlsCase {
        private final CFServerConfiguration myServerConfig;
        private final CFDeploymentConfiguration myDeploymentConfig;
        private final CFManifest myManifest;

        ManifestAppUrlsCase(CFServerConfiguration serverConfig, CFDeploymentConfiguration deploymentConfig) {
            this.myServerConfig = serverConfig;
            this.myDeploymentConfig = deploymentConfig;
            this.myManifest = this.myDeploymentConfig.getManifest();
        }

        public List<String> getAppUrls() {
            if (this.myManifest.getCurrentApplication() == null && this.myManifest.getHosts().isEmpty() && this.myManifest.getDomains().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            List<String> domains = this.getDomains();
            List<String> hosts = this.getHosts();
            for (String domain : domains) {
                for (String host : hosts) {
                    result.add(CFCloudLocation.createUrl(host, domain));
                }
            }
            return result;
        }

        private List<String> getDomains() {
            CFAppFogInfra infra;
            List<String> manifestDomains = this.myDeploymentConfig.getManifest().getDomains();
            if (!manifestDomains.isEmpty()) {
                return manifestDomains;
            }
            if (this.myServerConfig.isAppFog() && (infra = this.myDeploymentConfig.getAppFogInfra()) != null) {
                return Collections.singletonList(infra.getDomain());
            }
            String defaultDomain = this.myServerConfig.getDefaultDomain();
            return Collections.singletonList(defaultDomain != null ? defaultDomain : this.myDeploymentConfig.getDomain());
        }

        private List<String> getHosts() {
            if (this.myManifest.noHostName()) {
                return Collections.singletonList(null);
            }
            List<String> manifestHosts = this.myManifest.getHosts();
            return manifestHosts.isEmpty() ? Collections.singletonList(this.myManifest.getCurrentApplication()) : manifestHosts;
        }
    }

    private static abstract class LocalInstanceBase
    extends CFCloudLocation {
        private LocalInstanceBase(String id, String name) {
            super(id, name);
        }

        @Override
        public String getApiUrl(CFServerConfiguration serverConfig) {
            return CFCloudLocation.createUrl("api", this.getDomain(serverConfig));
        }

        @Override
        public List<String> getAppUrls(CFServerConfiguration serverConfig, DeploymentTask<CFDeploymentConfiguration> deploymentTask) {
            return CFCloudLocation.createDefaultAppUrlSingleton((DeploymentTask<CFDeploymentConfiguration>)deploymentTask, this.getDomain(serverConfig));
        }

        protected abstract String getDomain(CFServerConfiguration var1);
    }
}

