/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.utils;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightMethodBuilder;

public class PlayClassExtensions {
    private static final List<PlayClassExtension> myExtensions = new ArrayList<PlayClassExtension>();
    private static final PlayClassExtension myStringArrayExtension = PlayClassExtensions.createStringArrayExtensions();

    private static PlayClassExtension createStringArrayExtensions() {
        PlayClassExtension extension = new PlayClassExtension("StringArray"){

            @Override
            protected boolean acceptPsiClass(@NotNull PsiClass psiClass) {
                if (psiClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (psiClass instanceof PsiArrayType) {
                    return "java.lang.String".equals(((PsiArrayType)psiClass).getComponentType().getCanonicalText());
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/play/utils/PlayClassExtensions$1", "acceptPsiClass"));
            }
        };
        extension.addExtension("add", "java.lang.String[]", new String[0]);
        extension.addExtension("contains", "java.lang.Boolean", "java.lang.String");
        extension.addExtension("remove", "java.lang.String[]", "java.lang.String");
        return extension;
    }

    private static PlayClassExtension createMapExtensions() {
        PlayClassExtension extension = new PlayClassExtension("java.util.Map");
        extension.addExtension("asAttr", "play.templates.Template.ExecutableTemplate.RawData", new String[0]);
        extension.addExtension("asAttr", "play.templates.Template.ExecutableTemplate.RawData", "java.lang.String");
        return extension;
    }

    private static PlayClassExtension createLongExtensions() {
        PlayClassExtension extension = new PlayClassExtension("java.lang.Long");
        extension.addExtension("asdate", "java.lang.String", "java.lang.String");
        extension.addExtension("asdate", "java.lang.String", "java.lang.String", "java.lang.String");
        extension.addExtension("formatSize");
        return extension;
    }

    private static PlayClassExtension createDateExtensions() {
        PlayClassExtension extension = new PlayClassExtension("java.util.Date");
        extension.addExtension("format", "java.lang.String", "java.lang.String");
        extension.addExtension("format", "java.lang.String", "java.lang.String", "java.lang.String");
        extension.addExtension("since");
        extension.addExtension("since", "java.lang.String", "java.lang.Boolean");
        return extension;
    }

    private static PlayClassExtension createCollectionExtensions() {
        PlayClassExtension extension = new PlayClassExtension("java.util.Collection");
        extension.addExtension("join", "java.lang.String", "java.lang.String");
        extension.addExtension("last", "java.lang.String", "java.lang.Object");
        extension.addExtension("pluralize");
        extension.addExtension("pluralize", "java.lang.String", "java.lang.String");
        extension.addExtension("pluralize", "java.lang.String", "java.lang.String", "java.lang.String");
        return extension;
    }

    private static PlayClassExtension createNumberExtensions() {
        PlayClassExtension extension = new PlayClassExtension("java.lang.Object");
        extension.addExtension("divisibleBy", "java.lang.Number", "java.lang.Boolean");
        extension.addExtension("format", "java.lang.String", "java.lang.String");
        extension.addExtension("formatCurrency", "java.lang.String", "java.lang.String");
        extension.addExtension("page", "java.lang.Integer", "java.lang.Number");
        extension.addExtension("pluralize");
        return extension;
    }

    private static PlayClassExtension createObjectExtensions() {
        PlayClassExtension extension = new PlayClassExtension("java.lang.Object");
        extension.addExtension("addSlashes");
        extension.addExtension("capAll");
        extension.addExtension("capFirst");
        extension.addExtension("cut", "java.lang.String", "java.lang.String");
        extension.addExtension("escape");
        extension.addExtension("nl2br");
        extension.addExtension("raw", "play.templates.Template.ExecutableTemplate.RawData", new String[0]);
        extension.addExtension("yesNo");
        return extension;
    }

    private static PlayClassExtension createStringExtensions() {
        PlayClassExtension extension = new PlayClassExtension("java.lang.String");
        extension.addExtension("asXml", "groovy.util.slurpersupport.GPathResult", new String[0]);
        extension.addExtension("camelCase");
        extension.addExtension("capitalizeWords");
        extension.addExtension("escapeHtml");
        extension.addExtension("escapeJavaScript");
        extension.addExtension("escapeXml");
        extension.addExtension("noAccents");
        extension.addExtension("pad");
        extension.addExtension("slugify");
        extension.addExtension("urlEncode");
        return extension;
    }

    public static List<GrMethod> getStringArrayExtensions(@NotNull Project project) {
        if (project == null) {
            PlayClassExtensions.$$$reportNull$$$0(0);
        }
        return PlayClassExtensions.mapExtensions(project, myStringArrayExtension.getExtensions());
    }

    public static List<GrMethod> getExtensions(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PlayClassExtensions.$$$reportNull$$$0(1);
        }
        ArrayList<GrMethod> exts = new ArrayList<GrMethod>();
        for (PlayClassExtension extension : myExtensions) {
            exts.addAll(PlayClassExtensions.mapExtensions(psiClass.getProject(), extension.getExtensions(psiClass)));
        }
        return exts;
    }

    private static List<GrMethod> mapExtensions(@NotNull Project project, List<PlayMethodExtension> extensions) {
        if (project == null) {
            PlayClassExtensions.$$$reportNull$$$0(2);
        }
        return ContainerUtil.mapNotNull(extensions, methodExtension -> {
            if (project == null) {
                PlayClassExtensions.$$$reportNull$$$0(3);
            }
            GrLightMethodBuilder builder = new GrLightMethodBuilder(PsiManager.getInstance((Project)project), methodExtension.getName());
            builder.setReturnType(methodExtension.getReturnType(), GlobalSearchScope.allScope((Project)project));
            int i = 0;
            for (String paramType : methodExtension.getParamTypes()) {
                builder.addParameter("arg" + i++, paramType, false);
            }
            return builder;
        });
    }

    static {
        myExtensions.add(PlayClassExtensions.createStringExtensions());
        myExtensions.add(PlayClassExtensions.createObjectExtensions());
        myExtensions.add(PlayClassExtensions.createNumberExtensions());
        myExtensions.add(PlayClassExtensions.createCollectionExtensions());
        myExtensions.add(PlayClassExtensions.createDateExtensions());
        myExtensions.add(PlayClassExtensions.createLongExtensions());
        myExtensions.add(PlayClassExtensions.createMapExtensions());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/play/utils/PlayClassExtensions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getStringArrayExtensions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getExtensions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mapExtensions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$mapExtensions$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PlayMethodExtension {
        private final String myName;
        private final String myReturnType;
        private final Set<String> myParamTypes;

        private PlayMethodExtension(@NotNull String name) {
            if (name == null) {
                PlayMethodExtension.$$$reportNull$$$0(0);
            }
            this(name, "java.lang.String", new String[0]);
        }

        private PlayMethodExtension(String name, String returnType, String ... paramTypes) {
            this.myParamTypes = new LinkedHashSet<String>();
            this.myName = name;
            this.myReturnType = returnType;
            for (String type : paramTypes) {
                this.myParamTypes.add(type);
            }
        }

        public String getName() {
            return this.myName;
        }

        public String getReturnType() {
            return this.myReturnType;
        }

        public Set<String> getParamTypes() {
            return this.myParamTypes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/play/utils/PlayClassExtensions$PlayMethodExtension", "<init>"));
        }
    }

    private static class PlayClassExtension {
        private final String myClassFqn;
        protected List<PlayMethodExtension> myExtensions;

        private PlayClassExtension(@NotNull String classFqn) {
            if (classFqn == null) {
                PlayClassExtension.$$$reportNull$$$0(0);
            }
            this.myExtensions = new ArrayList<PlayMethodExtension>();
            this.myClassFqn = classFqn;
        }

        public void addExtension(String extension) {
            this.myExtensions.add(new PlayMethodExtension(extension));
        }

        public void addExtension(String name, String returnType, String ... paramTypes) {
            this.myExtensions.add(new PlayMethodExtension(name, returnType, paramTypes));
        }

        public List<PlayMethodExtension> getExtensions() {
            return this.myExtensions;
        }

        public List<PlayMethodExtension> getExtensions(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                PlayClassExtension.$$$reportNull$$$0(1);
            }
            return this.acceptPsiClass(psiClass) ? this.myExtensions : Collections.emptyList();
        }

        protected boolean acceptPsiClass(PsiClass psiClass) {
            return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)this.myClassFqn);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/play/utils/PlayClassExtensions$PlayClassExtension";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getExtensions";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

