/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.console;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.play.console.BasicConsoleProcessRunner;
import com.intellij.play.console.ProcessLanguageConsoleViewWrapper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class BasicProcessConsoleRunnerWithHistory<T extends LanguageConsoleView> {
    private final T myConsoleView;
    private BasicConsoleProcessRunner myProcessRunner;
    private ProcessLanguageConsoleViewWrapper myComponent;

    public BasicProcessConsoleRunnerWithHistory(@NotNull T consoleView) {
        if (consoleView == null) {
            BasicProcessConsoleRunnerWithHistory.$$$reportNull$$$0(0);
        }
        this.myConsoleView = consoleView;
        this.getComponent();
    }

    public void showConsoleInRunToolwindow() {
        UIUtil.invokeLaterIfNeeded(() -> this.showConsoleInnerRunToolwindow());
    }

    protected BasicConsoleProcessRunner createBasicConsoleProcessRunner() {
        return new BasicConsoleProcessRunner((LanguageConsoleView)this.myConsoleView){

            @Override
            @NotNull
            protected GeneralCommandLine createCommandLine(@NotNull String command) {
                if (command == null) {
                    1.$$$reportNull$$$0(0);
                }
                GeneralCommandLine generalCommandLine = BasicProcessConsoleRunnerWithHistory.this.createCommandLine(command);
                if (generalCommandLine == null) {
                    1.$$$reportNull$$$0(1);
                }
                return generalCommandLine;
            }

            @Override
            public String getHistoryId() {
                return BasicProcessConsoleRunnerWithHistory.this.getToolWindowId();
            }

            @Override
            public String getHistoryPersistenceId() {
                return BasicProcessConsoleRunnerWithHistory.this.getToolWindowId();
            }

            @Override
            protected JComponent getConsoleComponent() {
                return BasicProcessConsoleRunnerWithHistory.this.getComponent();
            }

            @Override
            protected OSProcessHandler createProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
                if (commandLine == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new ColoredProcessHandler(this.createProcess(commandLine), commandLine.getCommandLineString()){

                    protected boolean shouldDestroyProcessRecursively() {
                        return true;
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/play/console/BasicProcessConsoleRunnerWithHistory$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commandLine";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/play/console/BasicProcessConsoleRunnerWithHistory$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createCommandLine";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createCommandLine";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createProcessHandler";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    protected abstract GeneralCommandLine createCommandLine(String var1);

    public BasicConsoleProcessRunner getProcessRunner() {
        if (this.myProcessRunner == null) {
            this.myProcessRunner = this.createBasicConsoleProcessRunner();
        }
        return this.myProcessRunner;
    }

    private void showConsoleInnerRunToolwindow() {
        BasicConsoleProcessRunner processRunner = this.getProcessRunner();
        Executor executor = processRunner.getExecutor();
        ExecutionManager.getInstance((Project)this.getProject()).getContentManager().showRunContent(executor, processRunner.getContentDescriptor());
        ToolWindowManager.getInstance((Project)this.getProject()).getToolWindow(executor.getId()).activate(() -> IdeFocusManager.getInstance((Project)this.getProject()).requestFocus((Component)this.myConsoleView.getCurrentEditor().getContentComponent(), true));
    }

    public Project getProject() {
        return this.myConsoleView.getProject();
    }

    public ProcessLanguageConsoleViewWrapper getComponent() {
        if (this.myComponent == null) {
            this.myComponent = new ProcessLanguageConsoleViewWrapper((LanguageConsoleView)this.myConsoleView){

                @Override
                protected BasicConsoleProcessRunner getProcessRunner() {
                    return BasicProcessConsoleRunnerWithHistory.this.getProcessRunner();
                }
            };
        }
        return this.myComponent;
    }

    protected abstract String getToolWindowId();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/intellij/play/console/BasicProcessConsoleRunnerWithHistory", "<init>"));
    }
}

