/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.intellij.CommonBundle;
import com.intellij.database.SynchronizeHandler;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDbConnectionInfo;
import org.jetbrains.android.database.AndroidDbErrorReporter;
import org.jetbrains.android.database.AndroidDbErrorReporterImpl;
import org.jetbrains.android.database.AndroidDbUtil;
import org.jetbrains.android.database.AndroidRemoteDataBaseManager;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class AndroidSynchronizeHandler
extends SynchronizeHandler {
    public void synchronizationStarted(@NotNull Project project, @NotNull Set<DbDataSource> elements) {
        if (project == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(0);
        }
        if (elements == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(1);
        }
        ArrayList<AndroidDataSource> dataSourcesToSync = new ArrayList<AndroidDataSource>();
        for (DbDataSource element : elements) {
            DatabaseSystem delegate = element.getDelegate();
            if (!(delegate instanceof AndroidDataSource)) continue;
            dataSourcesToSync.add((AndroidDataSource)delegate);
        }
        if (dataSourcesToSync.isEmpty()) {
            return;
        }
        Set<AndroidDataSource> syncedDataSources = AndroidSynchronizeHandler.doSynchronize(project, dataSourcesToSync);
        Iterator<DbDataSource> it = elements.iterator();
        while (it.hasNext()) {
            DbDataSource element = it.next();
            DatabaseSystem delegate = element.getDelegate();
            if (!(delegate instanceof AndroidDataSource) || syncedDataSources.contains(delegate)) continue;
            it.remove();
        }
    }

    @NotNull
    public static Set<AndroidDataSource> doSynchronize(@NotNull Project project, @NotNull Collection<AndroidDataSource> dataSourcesToSync) {
        AndroidDebugBridge debugBridge;
        if (project == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(2);
        }
        if (dataSourcesToSync == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(3);
        }
        if ((debugBridge = AndroidSdkUtils.getDebugBridge((Project)project)) == null) {
            Messages.showErrorDialog((Project)project, (String)AndroidBundle.message((String)"cannot.connect.to.adb.error", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle());
            Set<AndroidDataSource> set = Collections.emptySet();
            if (set == null) {
                AndroidSynchronizeHandler.$$$reportNull$$$0(4);
            }
            return set;
        }
        Set<AndroidDataSource> syncedDataSources = Collections.synchronizedSet(new HashSet<AndroidDataSource>(dataSourcesToSync));
        MySynchronizeDataSourcesTask task = new MySynchronizeDataSourcesTask(project, debugBridge, syncedDataSources);
        ProgressManager.getInstance().run((Task)task);
        Set<AndroidDataSource> set = syncedDataSources;
        if (set == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(5);
        }
        return set;
    }

    private static void doSynchronizeDataSource(@NotNull Project project, @NotNull AndroidDataSource dataSource, @NotNull ProgressIndicator progressIndicator, @NotNull AndroidDebugBridge debugBridge, @NotNull AndroidDbErrorReporter errorReporter) {
        AndroidDbConnectionInfo dbConnectionInfo;
        if (project == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(6);
        }
        if (dataSource == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(7);
        }
        if (progressIndicator == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(8);
        }
        if (debugBridge == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(9);
        }
        if (errorReporter == null) {
            AndroidSynchronizeHandler.$$$reportNull$$$0(10);
        }
        if ((dbConnectionInfo = AndroidDbUtil.checkDataSource(dataSource, debugBridge, errorReporter)) == null) {
            return;
        }
        IDevice device = dbConnectionInfo.getDevice();
        String deviceId = AndroidDbUtil.getDeviceId(device);
        if (deviceId == null) {
            return;
        }
        String packageName = dbConnectionInfo.getPackageName();
        String dbName = dbConnectionInfo.getDbName();
        boolean external = dbConnectionInfo.isExternal();
        Long modificationTime = AndroidDbUtil.getModificationTime(device, packageName, dbName, external, errorReporter, progressIndicator);
        progressIndicator.checkCanceled();
        if (modificationTime == null) {
            return;
        }
        AndroidRemoteDataBaseManager remoteDbManager = AndroidRemoteDataBaseManager.getInstance();
        AndroidRemoteDataBaseManager.MyDatabaseInfo info = remoteDbManager.getDatabaseInfo(deviceId, packageName, dbName, external);
        if (info == null) {
            info = new AndroidRemoteDataBaseManager.MyDatabaseInfo();
        }
        progressIndicator.checkCanceled();
        File localDbFile = new File(dataSource.buildLocalDbFileOsPath());
        info.referringProjects.add(FileUtil.toCanonicalPath((String)project.getBasePath()));
        if (!(localDbFile.exists() && modificationTime.equals(info.modificationTime) || !AndroidDbUtil.downloadDatabase(device, packageName, dbName, external, localDbFile, progressIndicator, errorReporter))) {
            info.modificationTime = modificationTime;
            remoteDbManager.setDatabaseInfo(deviceId, packageName, dbName, info, external);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourcesToSync";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidSynchronizeHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugBridge";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorReporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidSynchronizeHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doSynchronize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "synchronizationStarted";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSynchronize";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doSynchronizeDataSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySynchronizeDataSourcesTask
    extends Task.Modal {
        private final Project myProject;
        private final AndroidDebugBridge myDebugBridge;
        private final Set<AndroidDataSource> myDataSources;

        MySynchronizeDataSourcesTask(@NotNull Project project, @NotNull AndroidDebugBridge debugBridge, @NotNull Set<AndroidDataSource> dataSources) {
            if (project == null) {
                MySynchronizeDataSourcesTask.$$$reportNull$$$0(0);
            }
            if (debugBridge == null) {
                MySynchronizeDataSourcesTask.$$$reportNull$$$0(1);
            }
            if (dataSources == null) {
                MySynchronizeDataSourcesTask.$$$reportNull$$$0(2);
            }
            super(project, AndroidBundle.message((String)"android.db.downloading.progress.title", (Object[])new Object[0]), true);
            this.myProject = project;
            this.myDebugBridge = debugBridge;
            this.myDataSources = dataSources;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                MySynchronizeDataSourcesTask.$$$reportNull$$$0(3);
            }
            Iterator<AndroidDataSource> it = this.myDataSources.iterator();
            while (it.hasNext()) {
                AndroidDataSource dataSource = it.next();
                indicator.setText("Downloading '" + dataSource.getName() + "'");
                Object object = AndroidDbUtil.DB_SYNC_LOCK;
                synchronized (object) {
                    AndroidDbErrorReporterImpl errorReporter = new AndroidDbErrorReporterImpl(this.myProject, dataSource, false);
                    AndroidSynchronizeHandler.doSynchronizeDataSource(this.myProject, dataSource, indicator, this.myDebugBridge, errorReporter);
                    if (errorReporter.hasError()) {
                        it.remove();
                    }
                }
                indicator.checkCanceled();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugBridge";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSources";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/android/database/AndroidSynchronizeHandler$MySynchronizeDataSourcesTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

