/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.database;

import com.intellij.database.autoconfig.DataSourceConfigUtil;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.android.database.AndroidDataSource;
import org.jetbrains.android.database.AndroidDataSourceStorage;
import org.jetbrains.android.database.AndroidRemoteDataBaseManager;
import org.jetbrains.android.database.AndroidRemoteDbInfo;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class AndroidDataSourceProjectComponent
implements ProjectComponent {
    @NotNull
    private final Project myProject;

    public AndroidDataSourceProjectComponent(@NotNull Project project) {
        if (project == null) {
            AndroidDataSourceProjectComponent.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void projectOpened() {
        DataSourceConfigUtil.refreshTablesInBackground((Project)this.myProject, AndroidDataSourceStorage.getInstance(this.myProject).getDataSources());
    }

    public void projectClosed() {
        if (!ProjectFacetManager.getInstance((Project)this.myProject).hasFacets(AndroidFacet.ID)) {
            return;
        }
        String basePath = FileUtil.toCanonicalPath((String)this.myProject.getBasePath());
        if (basePath != null) {
            Set<AndroidRemoteDbInfo> infos = this.collectAllUsedDatabases();
            AndroidRemoteDataBaseManager.getInstance().updateDbUsagesForProject(basePath, infos);
        }
    }

    @NotNull
    private Set<AndroidRemoteDbInfo> collectAllUsedDatabases() {
        HashSet<AndroidRemoteDbInfo> result = new HashSet<AndroidRemoteDbInfo>();
        for (AndroidDataSource source : AndroidDataSourceStorage.getInstance(this.myProject).getDataSources()) {
            AndroidDataSource.State s = source.getState();
            String deviceId = s.deviceId;
            if (deviceId == null) {
                deviceId = "";
            }
            result.add(new AndroidRemoteDbInfo(deviceId, s.packageName, s.databaseName, s.external));
        }
        HashSet<AndroidRemoteDbInfo> hashSet = result;
        if (hashSet == null) {
            AndroidDataSourceProjectComponent.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/database/AndroidDataSourceProjectComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/database/AndroidDataSourceProjectComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAllUsedDatabases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

