/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.properties;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.jam.JamService;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.ConfigurationPropertiesInspection;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.EnableConfigurationProperties;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContext;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ-\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u0013J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u0016\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\"H\u0002J5\u0010#\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u001fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/intellij/spring/boot/model/properties/ConfigurationPropertiesInspection;", "Lcom/intellij/spring/model/highlighting/jam/SpringUastInspectionBase;", "()V", "CANONICAL_PREFIX_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "checkClass", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "uClass", "Lorg/jetbrains/uast/UClass;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lorg/jetbrains/uast/UClass;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "checkMethod", "method", "Lorg/jetbrains/uast/UMethod;", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "findDuplicates", "", "Lcom/intellij/spring/boot/model/properties/jam/ConfigurationProperties;", "jamService", "Lcom/intellij/jam/JamService;", "useScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "configurationProperties", "value", "", "getProblemElement", "Lcom/intellij/psi/PsiElement;", "getPsiElement", "jamAttributeElement", "Lcom/intellij/jam/JamStringAttributeElement;", "inspectConfigurationProperties", "nameIdentifier", "(Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/psi/PsiElement;ZLcom/intellij/spring/boot/model/properties/jam/ConfigurationProperties;)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isSpringBootEnabled", "psiElement", "intellij.spring.boot.core"})
public final class ConfigurationPropertiesInspection
extends SpringUastInspectionBase {
    private final Pattern CANONICAL_PREFIX_PATTERN = Pattern.compile("[a-z]([a-z]|-[a-z]|\\d|\\.[a-z])*");

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)uClass, (String)"uClass");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
        if (psiElement == null) {
            return null;
        }
        PsiElement nameIdentifier = psiElement;
        PsiClass psiClass = uClass.getJavaPsi();
        if (!this.isSpringBootEnabled((PsiElement)psiClass)) {
            return null;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return null;
        }
        ConfigurationProperties configurationProperties = (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
        if (configurationProperties == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)configurationProperties, (String)"ConfigurationProperties.\u2026(psiClass) ?: return null");
        ConfigurationProperties configurationProperties2 = configurationProperties;
        return this.inspectConfigurationProperties(manager, nameIdentifier, isOnTheFly, configurationProperties2);
    }

    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        if (!(method.getReturnType() instanceof PsiClassType)) {
            return null;
        }
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)method.getUastAnchor());
        if (psiElement == null) {
            return null;
        }
        PsiElement nameIdentifier = psiElement;
        PsiMethod psiMethod = method.getJavaPsi();
        if (!this.isSpringBootEnabled((PsiElement)psiMethod)) {
            return null;
        }
        ConfigurationProperties.Method method2 = (ConfigurationProperties.Method)ConfigurationProperties.Method.METHOD_META.getJamElement((PsiModifierListOwner)psiMethod);
        if (method2 == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"ConfigurationProperties.\u2026psiMethod) ?: return null");
        ConfigurationProperties.Method configurationProperties = method2;
        return this.inspectConfigurationProperties(manager, nameIdentifier, isOnTheFly, configurationProperties);
    }

    private final ProblemDescriptor[] inspectConfigurationProperties(InspectionManager manager, PsiElement nameIdentifier, boolean isOnTheFly, ConfigurationProperties configurationProperties) {
        JamStringAttributeElement<String> valueOrPrefixAttribute;
        ProblemsHolder holder = new ProblemsHolder(manager, nameIdentifier.getContainingFile(), isOnTheFly);
        JamStringAttributeElement<String> jamStringAttributeElement = valueOrPrefixAttribute = configurationProperties.getValueOrPrefixAttribute();
        Intrinsics.checkExpressionValueIsNotNull(jamStringAttributeElement, (String)"valueOrPrefixAttribute");
        if (jamStringAttributeElement.getPsiElement() == null) {
            holder.registerProblem(this.getProblemElement(configurationProperties), "Prefix must be specified", new LocalQuickFix[0]);
            return holder.getResultsArray();
        }
        PsiFile psiFile = nameIdentifier.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"nameIdentifier.containingFile");
        SearchScope searchScope = psiFile.getUseScope();
        if (searchScope == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.search.GlobalSearchScope");
        }
        GlobalSearchScope useScope = (GlobalSearchScope)searchScope;
        JamService jamService = JamService.getJamService((Project)holder.getProject());
        String value = configurationProperties.getValueOrPrefix();
        CharSequence charSequence = value;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            holder.registerProblem(this.getPsiElement(valueOrPrefixAttribute), "Prefix must be non-empty", new LocalQuickFix[0]);
        } else {
            if (SpringBootLibraryUtil.isAtLeastVersion(ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile()), SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0) && !this.CANONICAL_PREFIX_PATTERN.matcher(value).matches()) {
                holder.registerProblem(this.getPsiElement(valueOrPrefixAttribute), "Prefix must be in canonical form", new LocalQuickFix[0]);
            }
            JamService jamService2 = jamService;
            Intrinsics.checkExpressionValueIsNotNull((Object)jamService2, (String)"jamService");
            List<ConfigurationProperties> duplicates = this.findDuplicates(jamService2, useScope, configurationProperties, value);
            Collection collection = duplicates;
            if (!collection.isEmpty()) {
                holder.registerProblem(this.getPsiElement(valueOrPrefixAttribute), "Duplicated prefix", new LocalQuickFix[]{new LocalQuickFix(this, jamService, useScope, configurationProperties, value){
                    final /* synthetic */ ConfigurationPropertiesInspection this$0;
                    final /* synthetic */ JamService $jamService;
                    final /* synthetic */ GlobalSearchScope $useScope;
                    final /* synthetic */ ConfigurationProperties $configurationProperties;
                    final /* synthetic */ String $value;

                    public boolean startInWriteAction() {
                        return false;
                    }

                    @NotNull
                    public String getFamilyName() {
                        return "Show duplicates";
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                        void $receiver$iv$iv;
                        Collection $receiver$iv;
                        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                        Intrinsics.checkParameterIsNotNull((Object)descriptor, (String)"descriptor");
                        JamService jamService = this.$jamService;
                        Intrinsics.checkExpressionValueIsNotNull((Object)jamService, (String)"jamService");
                        Iterable iterable = this.this$0.findDuplicates(jamService, this.$useScope, this.$configurationProperties, this.$value);
                        void var5_4 = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            ConfigurationProperties configurationProperties = (ConfigurationProperties)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            JamStringAttributeElement<String> jamStringAttributeElement = it.getValueOrPrefixAttribute();
                            Intrinsics.checkExpressionValueIsNotNull(jamStringAttributeElement, (String)"it.valueOrPrefixAttribute");
                            PsiElement psiElement = ConfigurationPropertiesInspection.access$getPsiElement(this.this$0, jamStringAttributeElement);
                            collection.add(psiElement);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        Collection thisCollection$iv = $receiver$iv;
                        PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
                        if (psiElementArray == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        PsiElement[] findDuplicates = psiElementArray;
                        DataManager dataManager = DataManager.getInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)dataManager, (String)"DataManager.getInstance()");
                        dataManager.getDataContextFromFocusAsync().onSuccess((Consumer)new Consumer<DataContext>(this, findDuplicates){
                            final /* synthetic */ inspectConfigurationProperties.1 this$0;
                            final /* synthetic */ PsiElement[] $findDuplicates;

                            public final void accept(DataContext context) {
                                PsiElement[] psiElementArray = this.$findDuplicates;
                                (psiElementArray.length == 0 ? JBPopupFactory.getInstance().createMessage("No duplicates found for prefix '" + this.this$0.$value + '\'') : NavigationUtil.getPsiElementPopup((PsiElement[])this.$findDuplicates, (String)("Duplicates for prefix '" + this.this$0.$value + '\''))).showInBestPositionFor(context);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$findDuplicates = psiElementArray;
                            }
                        });
                    }
                    {
                        this.this$0 = $outer;
                        this.$jamService = $captured_local_variable$1;
                        this.$useScope = $captured_local_variable$2;
                        this.$configurationProperties = $captured_local_variable$3;
                        this.$value = $captured_local_variable$4;
                    }
                }});
            }
        }
        if (!(configurationProperties instanceof ConfigurationProperties.Method)) {
            PsiClass containingClass;
            UClass containingUClass;
            UAnnotation uAnnotation;
            PsiElement $receiver$iv;
            PsiAnnotation psiAnnotation = configurationProperties.getAnnotation();
            if (psiAnnotation == null) {
                Intrinsics.throwNpe();
            }
            PsiElement psiElement = $receiver$iv = (PsiElement)psiAnnotation;
            if (psiElement != null) {
                PsiElement psiElement2;
                PsiElement it$iv = psiElement2 = psiElement;
                uAnnotation = (UAnnotation)((UastContext)ServiceManager.getService((Project)$receiver$iv.getProject(), UastContext.class)).convertElementWithParent($receiver$iv, UAnnotation.class);
            } else {
                uAnnotation = null;
            }
            if (uAnnotation == null) {
                Intrinsics.throwNpe();
            }
            UClass uClass = containingUClass = UastUtils.getContainingUClass(uAnnotation);
            if (uClass == null) {
                Intrinsics.throwNpe();
            }
            if (!SpringCommonUtils.isComponentOrMeta((PsiClass)(containingClass = uClass.getJavaPsi()))) {
                boolean bl;
                block17: {
                    List enableConfigurationProperties;
                    List list = enableConfigurationProperties = jamService.getJamClassElements((JamMemberMeta)EnableConfigurationProperties.CLASS_META, "org.springframework.boot.context.properties.EnableConfigurationProperties", useScope);
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"enableConfigurationProperties");
                    Iterable $receiver$iv2 = list;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            EnableConfigurationProperties it;
                            EnableConfigurationProperties enableConfigurationProperties2 = it = (EnableConfigurationProperties)element$iv;
                            Intrinsics.checkExpressionValueIsNotNull((Object)enableConfigurationProperties2, (String)"it");
                            if (!enableConfigurationProperties2.getValue().contains(containingClass)) continue;
                            bl = false;
                            break block17;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    holder.registerProblem(this.getProblemElement(configurationProperties), "Not registered via " + '@' + StringUtil.getShortName((String)"org.springframework.boot.context.properties.EnableConfigurationProperties") + " or marked as Spring component ", new LocalQuickFix[0]);
                }
            }
        }
        return holder.getResultsArray();
    }

    @NotNull
    public final List<ConfigurationProperties> findDuplicates(@NotNull JamService jamService, @NotNull GlobalSearchScope useScope, @NotNull ConfigurationProperties configurationProperties, @Nullable String value) {
        List list;
        block5: {
            List list2;
            List methodElements;
            Intrinsics.checkParameterIsNotNull((Object)jamService, (String)"jamService");
            Intrinsics.checkParameterIsNotNull((Object)useScope, (String)"useScope");
            Intrinsics.checkParameterIsNotNull((Object)configurationProperties, (String)"configurationProperties");
            List allConfigurationProperties = jamService.getJamClassElements((JamMemberMeta)ConfigurationProperties.CLASS_META, "org.springframework.boot.context.properties.ConfigurationProperties", useScope);
            List list3 = methodElements = jamService.getJamMethodElements((JamMemberMeta)ConfigurationProperties.Method.METHOD_META, "org.springframework.boot.context.properties.ConfigurationProperties", useScope);
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"methodElements");
            allConfigurationProperties.addAll(list3);
            allConfigurationProperties.remove(configurationProperties);
            List list4 = allConfigurationProperties;
            Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"allConfigurationProperties");
            Collection $receiver$iv = list4;
            switch ($receiver$iv.size()) {
                case 1: {
                    list2 = (List)new SmartList();
                    break;
                }
                case 0: {
                    list = CollectionsKt.emptyList();
                    break block5;
                }
                default: {
                    list2 = new ArrayList();
                }
            }
            List result$iv = list2;
            Iterable $receiver$iv$iv = $receiver$iv;
            for (Object element$iv$iv : $receiver$iv$iv) {
                ConfigurationProperties it;
                ConfigurationProperties configurationProperties2 = it = (ConfigurationProperties)element$iv$iv;
                Intrinsics.checkExpressionValueIsNotNull((Object)configurationProperties2, (String)"it");
                if (!Intrinsics.areEqual((Object)value, (Object)configurationProperties2.getValueOrPrefix())) continue;
                ((Collection)result$iv).add(element$iv$iv);
            }
            list = result$iv;
        }
        return list;
    }

    private final boolean isSpringBootEnabled(PsiElement psiElement) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"ModuleUtilCore.findModul\u2026iElement) ?: return false");
        Module module2 = module;
        return SpringCommonUtils.hasSpringFacet((Module)module2) && SpringBootLibraryUtil.hasSpringBootLibrary(module2);
    }

    private final PsiElement getPsiElement(JamStringAttributeElement<String> jamAttributeElement) {
        PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)UastContextKt.toUElement((PsiElement)((PsiElement)jamAttributeElement.getPsiElement())));
        if (psiElement == null) {
            Intrinsics.throwNpe();
        }
        return psiElement;
    }

    private final PsiElement getProblemElement(ConfigurationProperties configurationProperties) {
        UAnnotation uAnnotation;
        PsiElement $receiver$iv;
        PsiAnnotation psiAnnotation = configurationProperties.getAnnotation();
        if (psiAnnotation == null) {
            Intrinsics.throwNpe();
        }
        PsiElement psiElement = $receiver$iv = (PsiElement)psiAnnotation;
        if (psiElement != null) {
            PsiElement psiElement2;
            PsiElement it$iv = psiElement2 = psiElement;
            uAnnotation = (UAnnotation)((UastContext)ServiceManager.getService((Project)$receiver$iv.getProject(), UastContext.class)).convertElementWithParent($receiver$iv, UAnnotation.class);
        } else {
            uAnnotation = null;
        }
        if (uAnnotation == null) {
            Intrinsics.throwNpe();
        }
        UAnnotation annotationElement = uAnnotation;
        PsiElement psiElement3 = UAnnotationKt.getNamePsiElement(annotationElement);
        if (psiElement3 == null) {
            Intrinsics.throwNpe();
        }
        return psiElement3;
    }

    @NotNull
    public static final /* synthetic */ PsiElement access$getPsiElement(ConfigurationPropertiesInspection $this, @NotNull JamStringAttributeElement jamAttributeElement) {
        return $this.getPsiElement((JamStringAttributeElement<String>)jamAttributeElement);
    }
}

