/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.properties;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.properties.jam.ConfigurationProperties;
import com.intellij.spring.boot.model.properties.jam.EnableConfigurationProperties;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ConfigurationPropertiesDiscoverer
extends CustomLocalComponentsDiscoverer {
    @NonNls
    private static final String CONFIGURATION_PROPERTIES_BEAN_NAME_SUFFIX = "CONFIGURATION_PROPERTIES";

    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel localModel) {
        Module module;
        if (localModel == null) {
            ConfigurationPropertiesDiscoverer.$$$reportNull$$$0(0);
        }
        if ((module = localModel.getModule()) == null || module.isDisposed() || !(localModel instanceof LocalAnnotationModel)) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                ConfigurationPropertiesDiscoverer.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module)) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                ConfigurationPropertiesDiscoverer.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiClass psiClass = (PsiClass)((LocalAnnotationModel)localModel).getConfig();
        EnableConfigurationProperties enableConfigurationProperties = (EnableConfigurationProperties)EnableConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)psiClass);
        if (enableConfigurationProperties == null) {
            List<CommonSpringBean> list = Collections.emptyList();
            if (list == null) {
                ConfigurationPropertiesDiscoverer.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<CommonSpringBean> list = ConfigurationPropertiesDiscoverer.findConfigurationProperties(module, enableConfigurationProperties);
        if (list == null) {
            ConfigurationPropertiesDiscoverer.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static List<CommonSpringBean> findConfigurationProperties(Module module, EnableConfigurationProperties enableConfigurationProperties) {
        final boolean isAtLeast14 = SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_4_0);
        SmartList beans = new SmartList();
        for (final PsiClass configBeanClass : enableConfigurationProperties.getValue()) {
            final ConfigurationProperties configurationProperties = (ConfigurationProperties)ConfigurationProperties.CLASS_META.getJamElement((PsiModifierListOwner)configBeanClass);
            if (configurationProperties == null) continue;
            CustomSpringComponent bean = new CustomSpringComponent("org.springframework.boot.context.properties.ConfigurationProperties", configBeanClass){

                public String getBeanName() {
                    String prefix = configurationProperties.getValueOrPrefix();
                    boolean hasPrefix = StringUtil.isNotEmpty((String)prefix);
                    String qualifiedName = configBeanClass.getQualifiedName();
                    if (isAtLeast14) {
                        return hasPrefix ? prefix + "-" + qualifiedName : qualifiedName;
                    }
                    return hasPrefix ? prefix + "." + ConfigurationPropertiesDiscoverer.CONFIGURATION_PROPERTIES_BEAN_NAME_SUFFIX : qualifiedName;
                }
            };
            beans.add(bean);
        }
        SmartList smartList = beans;
        if (smartList == null) {
            ConfigurationPropertiesDiscoverer.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/properties/ConfigurationPropertiesDiscoverer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/properties/ConfigurationPropertiesDiscoverer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigurationProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComponents";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

