/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions.jam;

import com.intellij.jam.JamClassAttributeElement;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamEnumAttributeElement;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.annotations.JamPsiConnector;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassAttributeMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.boot.model.jam.StringLiteralPsiClassConverter;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.converters.SpringBeanReferenceJamConverter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

abstract class ConditionalOnBeanBase {
    private static final JamClassAttributeMeta.Collection VALUE_ATTRIBUTE = JamAttributeMeta.classCollection((String)"value");
    private static final JamStringAttributeMeta.Collection<PsiClass> TYPE_ATTRIBUTE = JamAttributeMeta.collectionString((String)"type", (JamConverter)new StringLiteralPsiClassConverter());
    private static final JamClassAttributeMeta.Collection ANNOTATION_ATTRIBUTE = JamAttributeMeta.classCollection((String)"annotation");
    private static final JamStringAttributeMeta.Collection<SpringBeanPointer> NAME_ATTRIBUTE = JamAttributeMeta.collectionString((String)"name", (JamConverter)new SpringBeanReferenceJamConverter(null));
    private static final JamEnumAttributeMeta.Single<SearchStrategy> SEARCH_STRATEGY_ATTRIBUTE = JamAttributeMeta.singleEnum((String)"search", SearchStrategy.class);
    protected static final JamAnnotationArchetype ARCHETYPE = new JamAnnotationArchetype().addAttribute((JamAttributeMeta)VALUE_ATTRIBUTE).addAttribute(TYPE_ATTRIBUTE).addAttribute((JamAttributeMeta)ANNOTATION_ATTRIBUTE).addAttribute(NAME_ATTRIBUTE).addAttribute(SEARCH_STRATEGY_ATTRIBUTE);

    ConditionalOnBeanBase() {
    }

    @JamPsiConnector
    @NotNull
    public abstract PsiModifierListOwner getPsiElement();

    protected abstract JamAnnotationMeta getAnnotationMeta();

    public Collection<PsiClass> getValue() {
        List<JamClassAttributeElement> attribute = this.getValueElements();
        return ContainerUtil.map(attribute, JamClassAttributeElement::getValue);
    }

    public Collection<PsiClass> getType() {
        List<JamStringAttributeElement<PsiClass>> attribute = this.getTypeElements();
        return ContainerUtil.map(attribute, JamStringAttributeElement::getValue);
    }

    public Collection<PsiClass> getAnnotation() {
        List<JamClassAttributeElement> attribute = this.getAnnotationElements();
        return ContainerUtil.map(attribute, JamClassAttributeElement::getValue);
    }

    public SearchStrategy getSearch() {
        SearchStrategy searchStrategy = (SearchStrategy)((JamEnumAttributeElement)this.getAnnotationMeta().getAttribute(this.getPsiElement(), SEARCH_STRATEGY_ATTRIBUTE)).getValue();
        return searchStrategy != null ? searchStrategy : SearchStrategy.ALL;
    }

    protected List<JamClassAttributeElement> getValueElements() {
        return (List)this.getAnnotationMeta().getAttribute(this.getPsiElement(), (JamAttributeMeta)VALUE_ATTRIBUTE);
    }

    protected List<JamStringAttributeElement<PsiClass>> getTypeElements() {
        return (List)this.getAnnotationMeta().getAttribute(this.getPsiElement(), TYPE_ATTRIBUTE);
    }

    protected List<JamClassAttributeElement> getAnnotationElements() {
        return (List)this.getAnnotationMeta().getAttribute(this.getPsiElement(), (JamAttributeMeta)ANNOTATION_ATTRIBUTE);
    }

    static enum SearchStrategy {
        CURRENT,
        ANCESTORS,
        ALL;

    }
}

