/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model;

import com.intellij.facet.FacetFinder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.SpringBootModelConfigFileNameContributor;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootConfigurationFileServiceImpl
implements SpringBootConfigurationFileService {
    @Override
    public boolean isApplicationConfigurationFile(@NotNull PsiFile file) {
        if (file == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(0);
        }
        return this.getApplicationConfigurationFileIcon(file) != null;
    }

    @Override
    @Nullable
    public Icon getApplicationConfigurationFileIcon(@NotNull PsiFile file) {
        Module module;
        if (file == null) {
            SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(1);
        }
        if (!SpringCommonUtils.hasSpringFacet((Module)(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file))) || !SpringBootLibraryUtil.hasSpringBootLibrary(module)) {
            return null;
        }
        return (Icon)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            if (file == null) {
                SpringBootConfigurationFileServiceImpl.$$$reportNull$$$0(2);
            }
            VirtualFile virtualFile = file.getVirtualFile();
            boolean includeTestScope = ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(virtualFile);
            Icon icon = null;
            block0: for (SpringBootModelConfigFileContributor contributor : (SpringBootModelConfigFileContributor[])SpringBootModelConfigFileContributor.EP_NAME.getExtensions()) {
                if (contributor.getFileType() != file.getFileType()) continue;
                for (SpringBootModelConfigFileNameContributor fileNameContributor : (SpringBootModelConfigFileNameContributor[])SpringBootModelConfigFileNameContributor.EP_NAME.getExtensions()) {
                    List<VirtualFile> files;
                    if (!fileNameContributor.accept(module) || !(files = contributor.getConfigurationFiles(module, fileNameContributor, includeTestScope)).contains(virtualFile)) continue;
                    icon = fileNameContributor.getFileIcon();
                    break block0;
                }
                break;
            }
            ArrayList dependencies = ContainerUtil.newArrayList((Object[])new Object[]{file, FacetFinder.getInstance((Project)module.getProject()).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID), ProjectRootManager.getInstance((Project)module.getProject())});
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet != null) {
                dependencies.add(springFacet.getConfiguration());
            }
            return CachedValueProvider.Result.create(icon, (Collection)dependencies);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "com/intellij/spring/boot/model/SpringBootConfigurationFileServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicationConfigurationFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getApplicationConfigurationFileIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getApplicationConfigurationFileIcon$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

