/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.spring.boot.application.config.keyPath.ConfigKeyPathReference;
import com.intellij.spring.boot.application.properties.ConfigKeyPathReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigKeyPathEnumReference
extends ConfigKeyPathReferenceSet.Reference
implements EmptyResolveMessageProvider {
    ConfigKeyPathEnumReference(PsiElement element, TextRange textRange, ConfigKeyPathReferenceSet referenceSet, int index) {
        super(element, textRange, referenceSet, index);
    }

    @Override
    public ConfigKeyPathReference.PathType getPathType() {
        return ConfigKeyPathReference.PathType.ENUM;
    }

    @Nullable
    public PsiElement resolve() {
        PsiClass keyClass = this.getKeyClass();
        if (keyClass == null) {
            return null;
        }
        String enumText = this.getValue();
        return (PsiElement)ContainerUtil.find((Object[])keyClass.getFields(), field -> field instanceof PsiEnumConstant && enumText.equalsIgnoreCase(field.getName()) || enumText.equalsIgnoreCase(ConfigKeyPathEnumReference.getSanitizedName(field)));
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass keyClass = this.getKeyClass();
        if (keyClass == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                ConfigKeyPathEnumReference.$$$reportNull$$$0(0);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Object[] enumConstants = (PsiField[])ContainerUtil.findAllAsArray((Object[])keyClass.getFields(), (Condition)Conditions.instanceOf(PsiEnumConstant.class));
        Object[] objectArray = ContainerUtil.map2Array((Object[])enumConstants, LookupElement.class, field -> {
            String sanitizedFieldName = ConfigKeyPathEnumReference.getSanitizedName(field);
            LookupElementBuilder builder = LookupElementBuilder.create((Object)field, (String)sanitizedFieldName).withIcon(field.getIcon(1)).withPresentableText(sanitizedFieldName);
            return TailTypeDecorator.withTail((LookupElement)builder, (TailType)(this.isEnumMapKey() ? TailType.createSimpleTailType((char)this.getKeyValueDelimiter()) : TailType.DOT));
        });
        if (objectArray == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    private static String getSanitizedName(PsiField psiField) {
        String psiFieldName = psiField.getName();
        assert (psiFieldName != null);
        String string = psiFieldName.toLowerCase(Locale.US).replace('_', '-');
        if (string == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String location = this.getKeyClass() == null ? "" : " in " + this.getKeyClass().getQualifiedName();
        String string = "Cannot resolve enum constant '" + this.getValue() + "'" + location;
        if (string == null) {
            ConfigKeyPathEnumReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    protected PsiClass getKeyClass() {
        return this.isFirst() ? this.getInitialKeyClass() : this.getPrevious().getKeyClass();
    }

    @Override
    @Nullable
    protected PsiClass getValueClass() {
        return this.isFirst() ? this.getInitialValueClass() : this.getPrevious().getValueClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/application/properties/ConfigKeyPathEnumReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

