/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.options.SpringBootSettings;
import com.intellij.spring.editor.SpringEditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightColors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import icons.SpringBootApiIcons;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringBootMetadataNotificationPanel
extends SpringEditorNotificationPanel {
    SpringBootMetadataNotificationPanel(@NotNull Module module, @NotNull PsiFile psiFile) {
        if (module == null) {
            SpringBootMetadataNotificationPanel.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            SpringBootMetadataNotificationPanel.$$$reportNull$$$0(1);
        }
        boolean hasAnnotationProcessor2 = SpringBootMetadataNotificationPanel.hasAnnotationProcessor(module);
        this.icon(SpringBootApiIcons.SpringBoot);
        Object object = this.myBackgroundColor = hasAnnotationProcessor2 ? JBColor.lightGray : LightColors.RED;
        if (hasAnnotationProcessor2) {
            this.text("Re-run Spring Boot Configuration Annotation Processor to update generated metadata");
            this.createActionLabel("Hide notification", () -> {
                if (module == null) {
                    SpringBootMetadataNotificationPanel.$$$reportNull$$$0(4);
                }
                SpringBootSettings.getInstance(module.getProject()).setShowAdditionalConfigNotification(false);
                EditorNotifications.getInstance((Project)module.getProject()).updateAllNotifications();
            });
        } else {
            this.text("Spring Boot Configuration Annotation Processor not found in classpath");
            this.createActionLabel("Open Documentation...", () -> {
                if (psiFile == null) {
                    SpringBootMetadataNotificationPanel.$$$reportNull$$$0(3);
                }
                String version = SpringBootMetadataNotificationPanel.detectSpringBootVersion(psiFile);
                BrowserUtil.browse((String)("https://docs.spring.io/spring-boot/docs/" + version + "/reference/html/configuration-metadata.html#configuration-metadata-annotation-processor"));
            });
        }
        this.installOpenSettingsButton(psiFile.getProject(), "Spring Boot");
    }

    private static boolean hasAnnotationProcessor(@NotNull Module module) {
        if (module == null) {
            SpringBootMetadataNotificationPanel.$$$reportNull$$$0(2);
        }
        HashSet allModules = new HashSet();
        ModuleUtilCore.getDependencies((Module)module, (Set)allModules);
        return !ContainerUtil.process((Iterable)allModules, module1 -> !SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor(module1));
    }

    @Nullable
    private static String detectSpringBootVersion(PsiFile psiFile) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null) {
            return "current";
        }
        return SpringBootLibraryUtil.getVersionFromJar(module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootMetadataNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAnnotationProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$1";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

