/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.json.psi.JsonFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.application.metadata.BinderConfigKeyNameBinder;
import com.intellij.spring.boot.application.metadata.RelaxedNamesConfigKeyNameBinder;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import com.intellij.spring.boot.application.metadata.SpringBootConfigurationMetadataParser;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationMetaConfigKeyManagerImpl
extends SpringBootApplicationMetaConfigKeyManager {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManagerImpl");
    @NonNls
    private static final String GRADLE_KAPT_GENERATED_CLASSES_LIBRARY_NAME = "Gradle: kaptGeneratedClasses";
    private static final SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder ourRelaxedConfigKeyNameBinder = new RelaxedNamesConfigKeyNameBinder();
    private static final SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder ourBinderConfigKeyNameBinder = new BinderConfigKeyNameBinder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SpringBootApplicationMetaConfigKey> getAllMetaConfigKeys(@Nullable Module module) {
        if (SpringBootLibraryUtil.isBelowVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
            return Collections.emptyList();
        }
        Module module2 = module;
        synchronized (module2) {
            List fromLibraries = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
                List metaInfConfigFiles = SpringCommonUtils.findConfigFilesInMetaInf((Module)module, (boolean)true, (String)"spring-configuration-metadata.json", JsonFile.class);
                ArrayList<SpringBootApplicationMetaConfigKey> allKeys = new ArrayList<SpringBootApplicationMetaConfigKey>();
                for (JsonFile configMetadataFile : metaInfConfigFiles) {
                    List<SpringBootApplicationMetaConfigKey> keys = SpringBootApplicationMetaConfigKeyManagerImpl.getConfigKeysForFile(module, configMetadataFile);
                    allKeys.addAll(keys);
                }
                return CachedValueProvider.Result.create(allKeys, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            });
            List<SpringBootApplicationMetaConfigKey> localKeys = SpringBootApplicationMetaConfigKeyManagerImpl.getLocalMetaConfigKeys(module);
            return ContainerUtil.concat((List)fromLibraries, localKeys);
        }
    }

    private static List<SpringBootApplicationMetaConfigKey> getConfigKeysForFile(Module module, JsonFile jsonFile) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)jsonFile, () -> {
            ArrayList keys = new ArrayList();
            Processor collect = Processors.cancelableCollectProcessor(keys);
            try {
                SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(jsonFile);
                parser.processKeys(module, (Processor<SpringBootApplicationMetaConfigKey>)collect);
            }
            catch (ProcessCanceledException | IndexNotReadyException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.warn("Error parsing " + jsonFile.getVirtualFile().getPath(), e);
            }
            return CachedValueProvider.Result.create(keys, (Object[])new Object[]{jsonFile, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    private static List<SpringBootApplicationMetaConfigKey> getLocalMetaConfigKeys(Module localModule) {
        return (List)CachedValuesManager.getManager((Project)localModule.getProject()).getCachedValue((UserDataHolder)localModule, () -> {
            LinkedHashSet allModules = new LinkedHashSet();
            ModuleUtilCore.getDependencies((Module)localModule, allModules);
            boolean unitTestMode = ApplicationManager.getApplication().isUnitTestMode();
            if (ContainerUtil.process(allModules, module -> !SpringBootLibraryUtil.hasConfigurationMetadataAnnotationProcessor(module))) {
                Key libraryCheckDependency = unitTestMode ? PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT : ProjectRootManager.getInstance((Project)localModule.getProject());
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{libraryCheckDependency});
            }
            ArrayList allKeys = new ArrayList();
            for (Module module2 : allModules) {
                File localJsonFile = SpringBootApplicationMetaConfigKeyManagerImpl.findLocalMetadataJsonFile(module2, unitTestMode);
                if (localJsonFile == null) continue;
                ArrayList keys = new ArrayList();
                Processor collect = Processors.cancelableCollectProcessor(keys);
                try {
                    SpringBootConfigurationMetadataParser parser = new SpringBootConfigurationMetadataParser(module2, localJsonFile);
                    parser.processKeys(module2, (Processor<SpringBootApplicationMetaConfigKey>)collect);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.warn("Error parsing " + localJsonFile.getPath(), e);
                }
                allKeys.addAll(keys);
            }
            return CachedValueProvider.Result.create(allKeys, (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
        });
    }

    @Nullable
    private static File findLocalMetadataJsonFile(Module module, boolean unitTestMode) {
        if (!unitTestMode) {
            String compilerOutputPath = CompilerPaths.getModuleOutputPath((Module)module, (boolean)false);
            if (compilerOutputPath == null) {
                return null;
            }
            File compilerOutputJson = SpringBootApplicationMetaConfigKeyManagerImpl.findInOutputPath(compilerOutputPath);
            if (compilerOutputJson != null) {
                return compilerOutputJson;
            }
            return SpringBootApplicationMetaConfigKeyManagerImpl.findLocalMetadataJsonFileForKapt(module);
        }
        VirtualFile tempFSVirtualFile = TempFileSystem.getInstance().findFileByPath("/src/spring-configuration-metadata.json");
        if (tempFSVirtualFile == null) {
            return null;
        }
        try {
            File localJsonFile = FileUtil.createTempFile((String)"sb-test", (String)"whatever", (boolean)true);
            FileUtil.writeToFile((File)localJsonFile, (String)VfsUtilCore.loadText((VirtualFile)tempFSVirtualFile));
            return localJsonFile;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    private static File findLocalMetadataJsonFileForKapt(Module module) {
        LibraryOrderEntry entry = OrderEntryUtil.findLibraryOrderEntry((ModuleRootModel)ModuleRootManager.getInstance((Module)module), (String)GRADLE_KAPT_GENERATED_CLASSES_LIBRARY_NAME);
        if (entry == null) {
            return null;
        }
        for (VirtualFile virtualFile : entry.getRootFiles(OrderRootType.CLASSES)) {
            File file = SpringBootApplicationMetaConfigKeyManagerImpl.findInOutputPath(VirtualFileManager.extractPath((String)virtualFile.getUrl()));
            if (file == null) continue;
            return file;
        }
        return null;
    }

    @Nullable
    private static File findInOutputPath(String outputPath) {
        String metadataJsonPath = outputPath + "/META-INF/" + "spring-configuration-metadata.json";
        File localJsonFile = new File(metadataJsonPath);
        if (!localJsonFile.exists()) {
            return null;
        }
        return localJsonFile;
    }

    @Override
    @Nullable
    public SpringBootApplicationMetaConfigKey findApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        return this.doFindApplicationMetaConfigKey(module, configKey, false);
    }

    @Override
    @Nullable
    public SpringBootApplicationMetaConfigKey findCanonicalApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey) {
        return this.doFindApplicationMetaConfigKey(module, configKey, true);
    }

    @Nullable
    private SpringBootApplicationMetaConfigKey doFindApplicationMetaConfigKey(@Nullable Module module, @Nullable String configKey, boolean canonicalNotation) {
        if (configKey == null || module == null) {
            return null;
        }
        List<SpringBootApplicationMetaConfigKey> allKeys = this.getAllMetaConfigKeys(module);
        if (allKeys.isEmpty()) {
            return null;
        }
        if (canonicalNotation) {
            return (SpringBootApplicationMetaConfigKey)ContainerUtil.find(allKeys, key -> configKey.equals(key.getName()));
        }
        SpringBootApplicationMetaConfigKey exact = (SpringBootApplicationMetaConfigKey)ContainerUtil.find(allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createNormalAccessTypeMatchingCondition(configKey));
        if (exact != null) {
            return exact;
        }
        SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder binder = this.getConfigKeyNameBinder(module);
        return (SpringBootApplicationMetaConfigKey)ContainerUtil.find(allKeys, key -> binder.bindsTo((SpringBootApplicationMetaConfigKey)key, configKey));
    }

    @Override
    @NotNull
    public List<SpringBootApplicationMetaConfigKey> findAllApplicationMetaConfigKeys(PsiElement psiElement, @Nullable String configKey) {
        if (configKey == null) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(0);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
        if (module == null) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(1);
            }
            return list;
        }
        List<SpringBootApplicationMetaConfigKey> allKeys = this.getAllMetaConfigKeys(module);
        if (allKeys.isEmpty()) {
            List<SpringBootApplicationMetaConfigKey> list = Collections.emptyList();
            if (list == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        List exact = ContainerUtil.findAll(allKeys, SpringBootApplicationMetaConfigKeyManagerImpl.createNormalAccessTypeMatchingCondition(configKey));
        if (!exact.isEmpty()) {
            List list = exact;
            if (list == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder binder = this.getConfigKeyNameBinder(module);
        List list = ContainerUtil.findAll(allKeys, key -> binder.bindsTo((SpringBootApplicationMetaConfigKey)key, configKey));
        if (list == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private static Condition<SpringBootApplicationMetaConfigKey> createNormalAccessTypeMatchingCondition(@NotNull String configKey) {
        if (configKey == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(5);
        }
        Condition condition = key -> {
            if (configKey == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(10);
            }
            return key.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.NORMAL) && StringUtil.equalsIgnoreCase((CharSequence)key.getName(), (CharSequence)configKey);
        };
        if (condition == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @Override
    @NotNull
    public SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder getConfigKeyNameBinder(@NotNull Module module) {
        if (module == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(7);
        }
        if (SpringBootLibraryUtil.isBelowVersion(module, SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0)) {
            SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder configKeyNameBinder = ourRelaxedConfigKeyNameBinder;
            if (configKeyNameBinder == null) {
                SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(8);
            }
            return configKeyNameBinder;
        }
        SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder configKeyNameBinder = ourBinderConfigKeyNameBinder;
        if (configKeyNameBinder == null) {
            SpringBootApplicationMetaConfigKeyManagerImpl.$$$reportNull$$$0(9);
        }
        return configKeyNameBinder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllApplicationMetaConfigKeys";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/SpringBootApplicationMetaConfigKeyManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createNormalAccessTypeMatchingCondition";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigKeyNameBinder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createNormalAccessTypeMatchingCondition";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfigKeyNameBinder";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createNormalAccessTypeMatchingCondition$7";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

