/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.metadata;

import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKey;
import com.intellij.spring.boot.application.metadata.SpringBootApplicationMetaConfigKeyManager;
import org.jetbrains.annotations.NotNull;

class BinderConfigKeyNameBinder
implements SpringBootApplicationMetaConfigKeyManager.ConfigKeyNameBinder {
    private static final CharFilter UNIFORM_CHAR_FILTER = new CharFilter(){

        public boolean accept(char ch) {
            return Character.isLetterOrDigit(ch) || ch == '.';
        }
    };

    BinderConfigKeyNameBinder() {
    }

    @Override
    public boolean bindsTo(@NotNull SpringBootApplicationMetaConfigKey key, @NotNull String configKeyText) {
        if (key == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(0);
        }
        if (configKeyText == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(1);
        }
        if (!BinderConfigKeyNameBinder.matchesFirstChar(key.getName(), configKeyText)) {
            return false;
        }
        String uniformKeyName = BinderConfigKeyNameBinder.toUniform(key.getName());
        String cleanupConfigKeyText = BinderConfigKeyNameBinder.toUniform(configKeyText);
        boolean exactMatch = uniformKeyName.equals(cleanupConfigKeyText);
        if (key.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.NORMAL)) {
            return exactMatch;
        }
        if (key.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.MAP_GROUP)) {
            return exactMatch || StringUtil.startsWith((CharSequence)cleanupConfigKeyText, (CharSequence)(uniformKeyName + "."));
        }
        if (key.isAccessType(SpringBootApplicationMetaConfigKey.AccessType.INDEXED)) {
            if (exactMatch) {
                return true;
            }
            if (!StringUtil.containsChar((String)configKeyText, (char)'[')) {
                return false;
            }
            String beforeIndexAccess = StringUtil.substringBefore((String)configKeyText, (String)"[");
            return uniformKeyName.equals(BinderConfigKeyNameBinder.toUniform(beforeIndexAccess));
        }
        throw new IllegalArgumentException("unknown access type for " + key);
    }

    @Override
    public boolean matchesPrefix(@NotNull SpringBootApplicationMetaConfigKey key, @NotNull String prefixText) {
        if (key == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(2);
        }
        if (prefixText == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(3);
        }
        if (!BinderConfigKeyNameBinder.matchesFirstChar(key.getName(), prefixText)) {
            return false;
        }
        String uniformKeyName = BinderConfigKeyNameBinder.toUniform(key.getName());
        return StringUtil.startsWith((CharSequence)uniformKeyName, (CharSequence)BinderConfigKeyNameBinder.toUniform(prefixText));
    }

    private static boolean matchesFirstChar(String keyName, @NotNull String configKeyText) {
        if (configKeyText == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(4);
        }
        return !configKeyText.isEmpty() && StringUtil.charsEqualIgnoreCase((char)keyName.charAt(0), (char)configKeyText.charAt(0));
    }

    @NotNull
    private static String toUniform(String input) {
        String lowerCase = StringUtil.toLowerCase((String)input);
        if (StringUtil.isLatinAlphanumeric((CharSequence)lowerCase)) {
            String string = lowerCase;
            if (string == null) {
                BinderConfigKeyNameBinder.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = StringUtil.strip((String)lowerCase, (CharFilter)UNIFORM_CHAR_FILTER);
        if (string == null) {
            BinderConfigKeyNameBinder.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKeyText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixText";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/metadata/BinderConfigKeyNameBinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/metadata/BinderConfigKeyNameBinder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toUniform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "bindsTo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchesPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "matchesFirstChar";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

