/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.hints;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.spring.boot.application.config.hints.HintReferenceBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class NumberHintReferenceBase
extends HintReferenceBase {
    private final Class<? extends Number> myType;

    protected NumberHintReferenceBase(@NotNull PsiElement element, @NotNull TextRange range, Class<? extends Number> numberType) {
        if (element == null) {
            NumberHintReferenceBase.$$$reportNull$$$0(0);
        }
        if (range == null) {
            NumberHintReferenceBase.$$$reportNull$$$0(1);
        }
        super(element, range);
        this.myType = numberType;
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return DefaultLanguageHighlighterColors.NUMBER;
    }

    protected abstract void doDecode(String var1) throws NumberFormatException;

    @Override
    @Nullable
    protected final PsiElement doResolve() {
        String value = this.getValue().trim();
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        try {
            this.doDecode(value);
            return this.getElement();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = "Cannot convert ''{0}'' to " + this.myType.getName();
        if (string == null) {
            NumberHintReferenceBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/config/hints/NumberHintReferenceBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/config/hints/NumberHintReferenceBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

