/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config.gradle;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReferenceResolver;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import icons.GradleIcons;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.settings.GradleExtensionsSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class SpringBootGradlePlaceholderReferenceResolver
extends SpringBootPlaceholderReferenceResolver {
    @Override
    @NotNull
    public List<PsiElement> resolve(SpringBootPlaceholderReference reference) {
        GradleExtensionsSettings.GradleExtensionsData extensionsData = SpringBootGradlePlaceholderReferenceResolver.getExtensionsData(reference);
        if (extensionsData == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradlePlaceholderReferenceResolver.$$$reportNull$$$0(0);
            }
            return list;
        }
        GradleExtensionsSettings.GradleProp property = extensionsData.findProperty(reference.getValue());
        if (property == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradlePlaceholderReferenceResolver.$$$reportNull$$$0(1);
            }
            return list;
        }
        PsiFile buildFile = SpringBootGradlePlaceholderReferenceResolver.resolveBuildFile(reference);
        if (buildFile == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradlePlaceholderReferenceResolver.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<PsiElement> list = SpringBootGradlePlaceholderReferenceResolver.resolveCandidates(buildFile, reference.getValue());
        if (list == null) {
            SpringBootGradlePlaceholderReferenceResolver.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    public List<LookupElement> getVariants(SpringBootPlaceholderReference reference) {
        GradleExtensionsSettings.GradleExtensionsData extensionsData = SpringBootGradlePlaceholderReferenceResolver.getExtensionsData(reference);
        if (extensionsData == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradlePlaceholderReferenceResolver.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiFile buildFile = SpringBootGradlePlaceholderReferenceResolver.resolveBuildFile(reference);
        if (buildFile == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                SpringBootGradlePlaceholderReferenceResolver.$$$reportNull$$$0(5);
            }
            return list;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getElementFactory((Project)reference.getElement().getProject());
        List list = ContainerUtil.map2List((Collection)extensionsData.properties, prop -> {
            List<PsiElement> candidates = SpringBootGradlePlaceholderReferenceResolver.resolveCandidates(buildFile, prop.name);
            LookupElementBuilder builder = candidates.size() != 1 ? LookupElementBuilder.create((String)prop.name) : LookupElementBuilder.create((Object)candidates.get(0), (String)prop.name);
            PsiClassType type = psiElementFactory.createTypeByFQClassName(prop.getTypeFqn());
            return builder.withIcon(GradleIcons.Gradle).withTypeText(type.getPresentableText());
        });
        if (list == null) {
            SpringBootGradlePlaceholderReferenceResolver.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<PsiElement> resolveCandidates(PsiFile buildFile, String name) {
        SmartList results = new SmartList();
        StringSearcher searcher = new StringSearcher(name, true, true);
        searcher.processOccurrences((CharSequence)buildFile.getText(), arg_0 -> SpringBootGradlePlaceholderReferenceResolver.lambda$resolveCandidates$1(buildFile, (List)results, arg_0));
        SmartList smartList = results;
        if (smartList == null) {
            SpringBootGradlePlaceholderReferenceResolver.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    @Nullable
    private static PsiFile resolveBuildFile(SpringBootPlaceholderReference reference) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)reference.getElement());
        String gradleProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        if (module == null || gradleProjectPath == null) {
            return null;
        }
        ExternalProject externalProject = ExternalProjectDataCache.getInstance((Project)module.getProject()).getRootExternalProject(GradleConstants.SYSTEM_ID, new File(gradleProjectPath));
        if (externalProject == null) {
            return null;
        }
        File buildFile = externalProject.getBuildFile();
        if (buildFile == null) {
            return null;
        }
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(buildFile);
        if (virtualFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile);
    }

    @Nullable
    private static GradleExtensionsSettings.GradleExtensionsData getExtensionsData(SpringBootPlaceholderReference reference) {
        Project project = reference.getElement().getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)reference.getElement());
        return GradleExtensionsSettings.getInstance((Project)project).getExtensionsFor(module);
    }

    private static /* synthetic */ boolean lambda$resolveCandidates$1(PsiFile buildFile, List results, int occurrence) {
        PsiElement at = buildFile.findElementAt(occurrence);
        ContainerUtil.addIfNotNull((Collection)results, (Object)at);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/application/config/gradle/SpringBootGradlePlaceholderReferenceResolver";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCandidates";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

