/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.config;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.PropertiesElementFactory;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReferenceResolver;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.model.utils.PlaceholderTextRanges;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.SmartList;
import icons.SpringBootApiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBootPlaceholderReference
extends PsiReferenceBase.Poly<PsiElement> {
    private static final String RANDOM_KEY_PREFIX = "random.";

    protected SpringBootPlaceholderReference(PsiElement element, TextRange range) {
        super(element, range, false);
    }

    @Nullable
    protected abstract PsiElement resolveExistingKey(String var1);

    protected abstract void addExistingKeyVariants(List<LookupElement> var1);

    public static PsiReference[] createPlaceholderReferences(PsiElement element, PairFunction<? super PsiElement, ? super TextRange, ? extends PsiReference> producer) {
        String text = ElementManipulators.getValueText((PsiElement)element);
        Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)text, (String)"${", (String)"}");
        if (ranges.isEmpty()) {
            return EMPTY_ARRAY;
        }
        ArrayList<Object> placeholderReferences = new ArrayList<Object>(ranges.size());
        int startOffset = ElementManipulators.getOffsetInElement((PsiElement)element);
        for (TextRange range : ranges) {
            int colonIdx = range.substring(text).indexOf(58);
            if (colonIdx != -1) {
                range = TextRange.from((int)range.getStartOffset(), (int)colonIdx);
            }
            placeholderReferences.add(producer.fun((Object)element, (Object)range.shiftRight(startOffset)));
        }
        return placeholderReferences.toArray(PsiReference.EMPTY_ARRAY);
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        String key = this.getValue();
        if (StringUtil.startsWith((CharSequence)key, (CharSequence)RANDOM_KEY_PREFIX)) {
            String after = (String)ObjectUtils.assertNotNull((Object)StringUtil.substringAfter((String)key, (String)RANDOM_KEY_PREFIX));
            for (Random random : Random.values()) {
                String randomValue = random.getValue();
                if ((!random.isSupportsParameters() || !StringUtil.startsWith((CharSequence)after, (CharSequence)randomValue)) && !after.equals(randomValue) || SpringBootLibraryUtil.isBelowVersion(this.getModule(), random.getMinimumVersion())) continue;
                PsiClass randomClass = this.findRandomClass();
                ResolveResult[] resolveResultArray = randomClass != null ? PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{randomClass}) : PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{this.getElement()});
                if (resolveResultArray == null) {
                    SpringBootPlaceholderReference.$$$reportNull$$$0(0);
                }
                return resolveResultArray;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringBootPlaceholderReference.$$$reportNull$$$0(1);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        IProperty systemProperty = this.getSystemProperties().findPropertyByKey(key);
        if (systemProperty != null) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{systemProperty.getPsiElement()});
            if (resolveResultArray == null) {
                SpringBootPlaceholderReference.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        PsiElement existingKey = this.resolveExistingKey(key);
        if (existingKey != null) {
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{existingKey});
            if (resolveResultArray == null) {
                SpringBootPlaceholderReference.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }
        GlobalSearchScope contentScope = this.getModule().getModuleContentScope();
        Collection properties = PropertyKeyIndex.getInstance().get(key, this.getElement().getProject(), this.getElement().getResolveScope().uniteWith(contentScope));
        ArrayList<PsiElement> allResults = new ArrayList<PsiElement>(properties);
        for (SpringBootPlaceholderReferenceResolver placeholderReferenceResolver : (SpringBootPlaceholderReferenceResolver[])SpringBootPlaceholderReferenceResolver.EP_NAME.getExtensions()) {
            allResults.addAll(placeholderReferenceResolver.resolve(this));
        }
        ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(allResults);
        if (resolveResultArray == null) {
            SpringBootPlaceholderReference.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @Nullable
    private PsiClass findRandomClass() {
        return SpringCommonUtils.findLibraryClass((Module)this.getModule(), (String)this.getRandomClassName());
    }

    @NotNull
    private String getRandomClassName() {
        if (SpringBootLibraryUtil.isAtLeastVersion(this.getModule(), SpringBootLibraryUtil.SpringBootVersion.VERSION_2_0_0)) {
            if ("org.springframework.boot.env.RandomValuePropertySource" == null) {
                SpringBootPlaceholderReference.$$$reportNull$$$0(5);
            }
            return "org.springframework.boot.env.RandomValuePropertySource";
        }
        if ("org.springframework.boot.context.config.RandomValuePropertySource" == null) {
            SpringBootPlaceholderReference.$$$reportNull$$$0(6);
        }
        return "org.springframework.boot.context.config.RandomValuePropertySource";
    }

    private Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
    }

    @NotNull
    private PropertiesFile getSystemProperties() {
        PropertiesFile propertiesFile = PropertiesElementFactory.getSystemProperties((Project)this.myElement.getProject());
        if (propertiesFile == null) {
            SpringBootPlaceholderReference.$$$reportNull$$$0(7);
        }
        return propertiesFile;
    }

    @NotNull
    public Object[] getVariants() {
        SmartList variants = new SmartList();
        this.addExistingKeyVariants((List<LookupElement>)variants);
        for (IProperty property : this.getSystemProperties().getProperties()) {
            String string = property.getKey();
            if (string == null) continue;
            variants.add(LookupElementBuilder.create((Object)property, (String)string).withIcon(SpringBootApiIcons.SpringBoot));
        }
        PsiClass randomClass = this.findRandomClass();
        if (randomClass == null) {
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
            if (objectArray == null) {
                SpringBootPlaceholderReference.$$$reportNull$$$0(8);
            }
            return objectArray;
        }
        Module module = this.getModule();
        for (Random random : Random.values()) {
            if (SpringBootLibraryUtil.isBelowVersion(module, random.getMinimumVersion())) continue;
            String randomText = random.getValue();
            String insertString = RANDOM_KEY_PREFIX + randomText;
            variants.add(LookupElementBuilder.create((Object)randomClass, (String)insertString).withIcon(SpringBootApiIcons.SpringBoot));
            if (!random.isSupportsParameters()) continue;
            variants.add(LookupElementBuilder.create((Object)randomClass, (String)insertString).withPresentableText(RANDOM_KEY_PREFIX + randomText + "(value,[max])").withIcon(SpringBootApiIcons.SpringBoot).withInsertHandler((InsertHandler)ParenthesesInsertHandler.WITH_PARAMETERS));
        }
        for (SpringBootPlaceholderReferenceResolver springBootPlaceholderReferenceResolver : (SpringBootPlaceholderReferenceResolver[])SpringBootPlaceholderReferenceResolver.EP_NAME.getExtensions()) {
            variants.addAll(springBootPlaceholderReferenceResolver.getVariants(this));
        }
        Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
        if (objectArray == null) {
            SpringBootPlaceholderReference.$$$reportNull$$$0(9);
        }
        return objectArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/boot/application/config/SpringBootPlaceholderReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRandomClassName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemProperties";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static enum Random {
        INT("int", true, SpringBootLibraryUtil.SpringBootVersion.ANY),
        LONG("long", true, SpringBootLibraryUtil.SpringBootVersion.ANY),
        VALUE("value", false, SpringBootLibraryUtil.SpringBootVersion.ANY),
        UUID("uuid", false, SpringBootLibraryUtil.SpringBootVersion.VERSION_1_4_0);

        private final String myValue;
        private final boolean mySupportsParameters;
        private final SpringBootLibraryUtil.SpringBootVersion myMinimumVersion;

        private Random(String value, boolean supportsParameters, SpringBootLibraryUtil.SpringBootVersion minimumVersion) {
            this.myValue = value;
            this.mySupportsParameters = supportsParameters;
            this.myMinimumVersion = minimumVersion;
        }

        SpringBootLibraryUtil.SpringBootVersion getMinimumVersion() {
            return this.myMinimumVersion;
        }

        String getValue() {
            return this.myValue;
        }

        boolean isSupportsParameters() {
            return this.mySupportsParameters;
        }
    }
}

